; updated 09/09/83 JJK, add PLM86 comments for extrn program
; 01/022/85 DC, add alias names so you can use it to call more than one
;  procedure per compilation unit (with different parameter lists).
; 02/15/90  DR, added paging service system common
; 02/27/90 JA, make reentrant.
; 03/27/90  DR, remove paging service system common
; 09/08/90 JA, CallProcStack dec sp (di) by 2, since stosw is post-dec.

CallProcSeg segment word 'Code'
assume cs: CallProcSeg

public CallProc, CallProc0, CallProc1, CallProc2, CallProc3
;
; CallProc: PROCEDURE (pProc) PUBLIC;
;	DECLARE pProc POINTER;
;
CallProc proc far
CallProc0 label far
CallProc1 label far
CallProc2 label far
CallProc3 label far
	push	bp
	pop	bp
	pop	ax			; ipRet
	pop	bx			; csRet
	pop	cx			; pProc.ip
	pop	dx			; pProc.cs
	push	bx
	push	ax
	push	dx
	push	cx
	ret				; CALL pProc
CallProc endp

public CallProcStack, CallProcStack0, CallProcStack1, CallProcStack2
;
; CallProcStack: PROCEDURE (pProc, pStack) PUBLIC;
;	DECLARE pProc POINTER;
;
CallProcStack proc far
CallProcStack0 label far
CallProcStack1 label far
CallProcStack2 label far
nArgCopied EQU 40		; 20 words of arguments at most.
;   Stack here
;	  ipRet
;	  csRet
;	  raStack
;	  saStack
;	  pProc.ip
;	  pProc.cs
;	  argn
;	  argn-1
;	  ...
;	  arg0	<- DS:SI
	pop	ax			; ipRet
	pop	bx			; csRet
	pop	di			; raStack
	pop	es			; saStack
	pop	cx			; pProc.ip
	pop	dx			; pProc.cs
; build stack for CPRet to link back to, see below
	push	bx		; csRet
	push	ax		; ipRet
	push	bp
	push	ds
; build new stack, see next "Stack here" comment.
	std				; so stosw does post-decrement "push", i.e. *es:di--
	dec di			; di starts pointing to 1st stack location since post-dec.
	dec di
	mov	si, sp
	add	si, nArgCopied+6; The 6 is bp,ipRet,csRet; sp pointed to ds.
	mov	ax, ss
	mov	ds, ax		; ds:si -> arg0

	xchg	ax, dx
	stosw			; pProc.cs
	xchg	ax, cx
	stosw			; pProc.ip
	mov	ax, ss
	stosw			; ssOriginal
	mov	bp, di		; bp -> spOriginal
	mov	ax, sp
	stosw			; spOriginal
	mov	cx, nArgCopied/2
	rep	movsw		; arg0..argn

	mov	ax, es
	add	di, 2		; di -> argn
	mov	ss, ax
	mov	sp, di
	mov	ds, ax		; medium model ss==ds

;   Stack here
;	  argn
;	  argn-1
;	  ...
;	  arg0
;	  spOriginal <- BP
;	  ssOriginal
;	  pProc.ip
;	  pProc.cs
	CALL DWORD PTR [BP+4]

CPRet:
;   Stack here
;	  argj
;	  argj-1
;	  ...
;	  arg0
;	  spOriginal <- BP
;	  ssOriginal
; Also, AX=ercRet.
; Link back to original stack, remember sp,bp for argument counting.
	mov bx, sp		; bp-sp = nArgCopied-nArgUsed
	mov	dx, [BP]
	mov ss, [BP+2]
	mov sp, dx
;	Stack here
;	  ds
;	  bp
;	  ipRet
;	  csRet
;	  argn
;	  argn-1
;	  ...
;	  arg0
	sub	bx, bp		; bx = nArgUsed-nArgCopied
	add	bx, nArgCopied; bx = nArgUsed
	pop	ds
	pop	bp
	pop	dx			; simulate RET BX
	pop	cx
	add	sp, bx
	push	cx
	push	dx
	ret

CallProcStack endp

CallProcSeg ends

end
