$MOD286
; file: RMOSSwitch_all.asm
;
; Supports real to protected and protected to real transitions
; for RMOS.
;
; 06/04/86  DR created
; 10/11/86  DR use generic ports in finger area
; 10/13/86  DR CallVideoRom
; 10/28/86  DR use 32-bit LGDTR/LIDTR on 386
; 01/05/87  DR ammended exception handling
; 02/06/87  FW EnterBootRom
; 02/13/87  DR change addressing for biggered gdtLink
; 02/20/87  DR RmosGPFault
; 03/12/87  FW preserve correct video ram enable state on 286i across finger
; 04/01/87  DR rmos msw
; 04/06/87  DR hardware math server
;--- 2.1 ---
; 05/07/87  DR Rmos pit support
;--- 2.2 ---
; 07/30/87  DR enable interrupts on return from cross interrupt prior
;              to reentering real mode
;--- 2.2 ---
; 10/16/87  JM support return of pointers in ES:BX from protected servers
;			 	to real mode clients (required for batch bytestreams).
; 11/17/87  FW 386i port.
; 01/14/88  FW Must enable 386i boot rom in EnterBootRom.
; 04/07/88  JM support > 16mb memory.
;--- 3.0 ---
; 08/26/88  JA Use Descriptors.mdf.  Move rgsgAlias.
; 10/06/88  KH PS2 changes
; 10/17/88  KH Use baselinearOffset in GoProtected. 
; 10/24/88  KH finger_pidCoprocessor has owning process' offset from start of ;              rgPcb, not segment, so that toggling MSB(it) is safe 
; 03/03/89  KH When paging is turned off, use sgIdentityLowmem instead of 
;              sgLowmem., and change GDTR to find the GDT 
; 02/08/89  JA/RLM GP conditional compile.
; 02/14/89  JA/RLM Move rgsgAlias to rmwa in tss.
; 07/24/89  JA ClearPagingBit do far jmp after cr3 load.
; 09/21/89  JA EnterBootRom should work for GP as is.
; 12/21/89  MTR Fix divide overflow in CoprocessorTrapCommon (iPcbCoprocessor
;               was being computed as oPcbRun-(oPcbRun-oRgPcb)/sPcb).  Allow
;               nPcb>255 to work.  LoadCoprocessor no longer zots user's DX.
;  1/17/90  JA Shorten SystemCall, remove differences among CEntry,OsSub,RqInt.
; 02/22/90	JC	Included following BTOS fix:
;				Put a jump to the next instruction following PagingOff
;				label to prevent a crash 89 due to hardware problem with
;				prefetching next instruction on switch from protected
;				to real mode
; 04/18/90  JM  bigger p series gdtLink.
; 09/05/90  SG  Add b38lcw support.
; 11/21/90  AT  SuperGen support.
; 11/29/90  AT  Fixed SuperGen use of A20 when going protected.
; 02/12/91  SG  Enterbootrom for B38lcw.
; 02/21/91	JF	Copy CoprocessorTrap into Crash_all so that it can be called
;				from PC Emulator.
; 03/26/91	SG	Add SG5000 support for autodump; also port 98h change for p2.
; 04/22/91  MTR Add vfSGenP1 stuff (cf. 'p1 hack')
; 05/13/91  GWH Remove above p1 hack.

%set(fDebug,0h)
%IF(NOT %*IsDef(%GP)) THEN (%DEFINE(GP)(0))FI

public CrossInterrupt, CrossReturn, RealDispatcher, SwapXbEarReal
public SaFixupRealDispatcher, RmosCoprocessorTrap
public RmosDivideOverflow
public RmosGpFault, RmosRet, RmosCoprocessorNotPresentTrap
public RealKernelEntry, RealRqInterfaceEntry, RealOssubEntry
public CallRealCommIsr, CallRealIsr, RmosBogusOpHandler, CallVideoRom 
public EnterBootRom, OssubReturn

; publics for debugging
public SystemCall, EnterCEntry, EnterOssub, EnterRqInterface

extrn CEntry:far, RqInterface:far, OssubEntry:far
extrn ErrorExit:far, FarDealiasToSr:far, FarAliasIpcSr:far
extrn beeper:far
%if (not %gp) then(
extrn Crash:far; p1 hack
)fi


$INCLUDE(:f1:Descriptors.mdf)
$INCLUDE(:f1:Srp386.mdf)
$INCLUDE(:f1:ioaddr1.edf)

sGdtLink     equ 7
wSignatureDR equ 7264h
parityOn equ 1  ; keep video ram disabled on NewGen (FW)
parityOff equ 0 ; keep video ram disabled on NewGen (FW)
parityErrClr  equ  0ch
parityOnB38  equ  08h
pcbSize equ 18
c287State equ 94

; b38lcw equates for memory controller

AAXS          EQU   0DH	
SeqIndexReg   EQU  03c4h		; from vidNgen.edf
VidToHiAddr   EQU  0320h 

ercStrayInterrupt equ 26
ercDivideOverflow equ 27
ercBogusOp equ 28
ercCoprocessorNotPresent equ 29
ercRmosGpFault equ 81

wEarNewgenGc003Fake equ 0FFFFh	 ; to fake ear on Gc003
newgenVideoBit equ 2			           ; ParityEnablePortNGen bit
; The following is used to determine in a hacky way whether we are running on
; a newgen.  The code compares finger_portParity against the following, if
; they are the same, it assumes newgen.  The right way to do this is to put
; the processor type into the finger area and test that.
parityEnablePortNewGen equ 802Eh
parityEnablePort386i equ 0A806H

; sgen equates
lShadowRomEnableReg equ 0C02h

b38lcw equ 14
SG5000 equ 15

; real mode work area is in the TSS

rmwaBase          equ [si] 

Rmwa_wSpReal      equ word ptr rmwaBase[0]
Rmwa_wSSReal      equ word ptr rmwaBase[2]
Rmwa_sgSS         equ word ptr rmwaBase[4]
Rmwa_ear          equ word ptr rmwaBase[6]
Rmwa_wDSReal      equ word ptr rmwaBase[8]
Rmwa_wFlReal      equ word ptr rmwaBase[0ah]
Rmwa_wCSReal      equ word ptr rmwaBase[0ch]
Rmwa_wIPReal      equ word ptr rmwaBase[0eh]
Rmwa_rgSgAlias    equ word ptr rmwaBase[10h]
Rmwa_otherStuff   equ word ptr rmwaBase[30h]
; rmwa_rgSgAlias is at least 16 words

; 286 code/data descriptor
Desc286_limit     equ word ptr es:[bx+0]
Desc286_base      equ word ptr es:[bx+2]
Desc286_baseHi    equ byte ptr es:[bx+4]
Desc286_access    equ byte ptr es:[bx+5]
Desc286_rsvd      equ word ptr es:[bx+6]


DGroup group data
data segment word public 'data'
extrn pRgoGdtLink:dword
extrn sgRealInterface:word
extrn oPcbRun:word
extrn oRgPcb:word
extrn sgTssIntLast:word
extrn pCoprocessorState:dword
extrn oCoprocessor:word

%if(%fDebug)then(
public ercRetTrap
ercRetTrap dw 0FFFEh
)fi

%if (not %gp) then(
extrn vfSGenP1:byte; p1 hack
)fi

data ends

RealInterface_code segment public 'code'

CrossInterrupt proc far
assume cs:RealInterface_code, ds:nothing, es:nothing
	push ax
	push bx

; determine the interrupt level - the interrupt vectors are
; a CS:IP hack where iLevel is encoded in the ra - the computed
; value is actually iLevel*8, which is what is needed access
; the IDT

	call GetIp ; pushes ip
GetIp:
	pop	bx
	sub bx, 4
	and bx, 0FFF0h
	shr bx, 1

; finish pushing a CTOS context frame
	push ds
	push cx
	push es
	push si
	push dx
	push di
	push bp

	mov  cx, ss ; for ResumeRealMode

	mov si,  offset Continue_CrossInterrupt
	jmp near ptr GoProtected

Continue_CrossInterrupt:
	mov si, dx ; si is rmwaBase
	mov rmwa_wSpReal, sp
	mov rmwa_wSsReal, cx

; make a null protected mode stack
	mov ax, sgSend
	mov ss, ax

	mov ax, sgIdt
	mov es, ax

	cmp byte ptr es:[bx+5], accessTaskGate
	je CallInterruptTask

; assume protected mode SS still valid
	mov ax, rmwa_sgSS
	mov ss, ax
	push ercStrayInterrupt
	call ErrorExit

CallInterruptTask:
	call dword ptr es:[bx]
; allow any pended interrupts to happen
	sti

; set addressability to rmwa
	str ax
	sub ax, 8
	mov ds, ax
	mov ax, sgLowMem
	mov es, ax
assume es:Finger
	mov si, finger_rmwaBase

	mov  bp, sp

ResumeRealMode:
; execution resumes here when interrupt done and/or kernel
; reschedules this task

; on entry, cx is real mode ss, bp is real mode sp
;           es is base for finger area
;           ds:si point to rmwa within TSS

	cli

; put desired ear into finger area
	mov ax, rmwa_ear
	mov finger_ear, ax


ResumeRealModeEarSet:

; do nothing if not fResetOnFinger
	test finger_f287ResetOnFinger, 1
	jz MarkTss
; do nothing if half-loaded or unloaded
	test finger_pidCoprocessor, 8000h ; half-loaded?
	jnz MarkTss
	cmp finger_pidCoprocessor, 0      ; unloaded?
	jz MarkTss

; save environment
	or finger_pidCoprocessor, 8000h   ; mark half-loaded
	inc finger_rsvd1 ; FOR DEBUGGING
	mov  ax, ds ; save ds
	mov  bx, DGroup
	mov  ds, bx
assume ds:dgroup
	mov  bx, word ptr [pCoprocessorState+2]
	mov  es, bx
assume es:nothing
	mov  bx, oCoprocessor
	clts
	db   09bh, 026h, 0d9h, 037h, 09bh	;fstenv	es:byte Ptr[bx]
	mov  ds, ax ; restore ds

assume ds:nothing

MarkTss:
; mark current tss not busy so we can reload TR later
	mov ax, 8
	mov es, ax
	str bx
	mov al, byte ptr es:[bx+5]
	and al, 0FDh
	mov byte ptr es:[bx+5], al

	mov ax, sgLowMem	
	mov es, ax
assume es:Finger

	mov ax, sgIdentityLowMem	;must be identity map because we use it after  
								;paging is turned off        
	mov es, ax
assume es:Finger

; set up real mode cs:ip  and ss:sp in fingerarea
	mov ax, finger_raIntReturn
	mov finger_raRealEntry, ax
	mov ax, finger_saIntReturn
	mov finger_saRealEntry, ax
	mov finger_ssReal, cx
	mov finger_spReal, bp

; save tr and msw in finger area, as they are corrupted
	mov finger_wTr, bx
	smsw ax
	mov finger_wMsw, ax

	mov	al, finger_f386
	rcr al, 1
	jc Real386Entry

Real286Entry:
; save idtr and gdtr in finger area, also.
	sgdt finger_gdtr
	sidt finger_idtr

	xor ax, ax
	mov dx, finger_portProtectEnable
	out dx, ax
	mov dx, finger_portParity ; turn off parity
	mov ax, parityOff
	out dx, ax

; finally, give the finger

	mov ax, wSignatureDR
	mov finger_wSignature, ax

	mov dx, finger_portFinger
	out dx, ax

	jmp .+0 ; never executed - ROM returns at CrossReturn


Real386Entry:

; save idtr and gdtr in finger area, also.
	db 66h
	sgdt finger_gdtr
	db 66h
	sidt finger_idtr

	mov	al, finger_fPaging
	rcr al, 1
	jnc PagingOff
	
;idtr and gdtr must work after paging is turned off	
	cmp finger_gdtrBaseHi,0
	je ClearPagingBit
	
	mov al, finger_bBaseLinearOffset
	sub	al,1
	and finger_gdtrBaseHi,al
	and finger_idtrBaseHi,al

	db 66h
	lgdt finger_gdtr
	db 66h
	lidt finger_idtr

; replace so load after paging enabled works
	mov al, finger_bBaseLinearOffset
	or finger_gdtrBaseHi, al
	or finger_idtrBaseHi, al

ClearPagingBit:
; clear paging bit in CR0
	db 66h
	xor ax, ax ; xor eax, eax
	smsw dx
	xchg ax, dx
   	db 0Fh, 22h, 000h  ; mov cr0, eax
	xchg ax, dx
;clear page cache
	db 0Fh, 22h, 018h  ; mov cr3, eax
	Jmp far ptr PagingOff

PagingOff:
; While switching from protected to real mode, the prefetch unit
; may goof up fetching instructions starting with MOV DS, AX
;
; The result is an invalid op code is fetched causing a trap which
; then is transformed into a crash 89 due to the wrong stack segment
;
; The address from the prefetch unit does not always increment 
; sequentially (a hardware problem) and may be corrected by clearing
; the prefetch queue with a JMP instruction

	jmp dummylabel
dummylabel:
; But we got to PagingOff with a Jmp.  Isn't this redundant?

	mov ax, sgIdentityLowMem	
	mov es, ax ;sgLowMem won't work any more
	mov ss, ax
	mov ds, ax
;	mov fs, ax
	db 8Eh, 0E0h
;	mov gs, ax
	db 8Eh, 0E8h

; turn off A20 so that the wrap at 1Mb will work
%IF(%GP) THEN (
	mov dx, finger_portProtectEnable
	in  ax, dx
	and ax, NOT protectedBootRom
	out dx, ax
) ELSE (

	cmp		finger_wProcType, b38lcw
	jne		notB38lcw

	MOV		AL,cmdWrite82106		; turn off A20
	out		Reg82c106Cmd,AL
WaitCmdTaken1:
	in		AL,Reg82c106Cmd
	and		AL,2
	jne		WaitCmdTaken1			; Wait for controller to take cmd
	mov		al, GetReal
	out		Reg82c106Data,al
WaitCmdTaken2:
	in		AL,Reg82c106Cmd
	and		AL,2
	jne		WaitCmdTaken2			; Wait for kbd controller to take cmd
	jmp		finishReg

NotB38lcw:
;P1 ...
	cmp  finger_wProcType,SG5000
	jne  NotSGen
	mov  dx, protectedModeEnablSgen	; Mask A20
	in   al,dx					
	cmp  al, 0ffh					; check if p1
	je   MustBeP1
	mov  al, 0						; else, p2
	out  dx, al
	jmp  FinishReg
MustBeP1:
	mov  dx, SystemCtlPortSGEN		; Mask A20 on p1, port 98h
	in   al, dx
	or   al, 2
	out  dx, al
	jmp  FinishReg

NotSGen:
; ... P1
	xor ax,ax
	mov dx, finger_portProtectEnable
	out dx,al
)FI
finishReg:
; set PE bit to zero
	db 0Fh, 20h, 000h  ; mov eax, cr0
	and  al, 0FEh
   	db 0Fh, 22h, 000h  ; mov cr0, eax
;	jmp Restore386RealIdtr
	db 0EAh
	dw offset Restore386RealIdtr
SaFixupRealDispatcher label far
	dw 0

Restore386RealIdtr:
	xor ax, ax
	mov es, ax
	lidt finger_idtr386Real
	jmp short RestoreRealStack


CrossReturn label far

; after finger, continue real mode execution here

	xor ax, ax
	mov es, ax
%IF(NOT %GP) THEN (
	cmp finger_wProcType, b38lcw
	je  B38ParityOn
	mov dx, finger_portParity		 ; turn on parity 
	mov ax, parityOn
	out dx, ax
	jmp RestoreRealStack
B38ParityOn:
	mov al, parityErrClr
	out sysControlPortB, al
	mov al, parityOnB38
	out sysControlPortB, al
	xor al, al
	out RTCmosAddressReg, al

)FI

RestoreRealStack:
%IF(NOT %GP) THEN (
;set up ear
	cmp finger_wProcType, b38lcw
	je  eardone
	cmp finger_wProcType,SG5000
	je  notRomEntry
	mov ax, finger_ear
	or ax, ax
	je  EarDone

; The following is a hacky way to determine whether we are running on
; a 286i.  The right way to do this is to put the processor type into the
; finger area and test that.
	cmp dx, parityEnablePortNewGen
	jne SetEar
	mov cx, ax              ;save ear
	mov ax, parityOn+newgenVideoBit
	out dx, ax
	mov ax, cx              ;
	cmp ax, wEarNewgenGC003Fake
	je EarDone
	in dx, al
	and al, NOT newgenVideoBit
	out dx,al
	mov ax, finger_ear

SetEar:
	mov dx, finger_portXBusEar
	out dx, ax
EarDone:
	cmp finger_portParity, 5555h   ; is this a 386i enterbootrom call?
	je  enableRom386i
	cmp finger_portParity, 7777h   ; is this a b38lcw enterbootrom call?
	jne  notRomEntry
b38RomEntry:
									; enable video ram and bootrom
	out    EnableMemCntlB38lcw, AL	; dummy write enables memory config
	jmp    $+2						;  regs
	mov    BL, AAXS					; first index into shadow memory
	mov    CX, 6
RemoveShadow:
	mov    AL, BL					; AAXS (0dh) - FAXS (12h)
	out    MemCntlIndexB38lcw, AL	; Out index register
	jmp    $+2
	xor    AL, AL
	out    MemCntlRegB38lcw, AL		; disable 0a0000h - 0affffh
	inc    BL
	loop   RemoveShadow

	out    DisableMemCntlB38lcw, AL	; disable access to config regs
	jmp    $+2
	mov    DX, SeqIndexReg			; enable CT Regs on vga chip
	mov    AL, 08h
	out    DX, AL
	jmp    $+2
	mov    DX, VidToHiAddr			; change video memory to low mem
	xor    AL, AL
	out    DX, AL
	jmp    notRomEntry

enableRom386i:
	xor ax, ax
	mov dx, parityEnablePortNewGen
	out dx, ax                     ; turn on 386i boot rom
notRomEntry:
)FI%' NOT GP

	clts
	mov ax, finger_RmosMSW ; so MP, EM will be set for RMOS
	lmsw ax

	mov ax, finger_ssReal
	mov bp, finger_spReal
	mov ss, ax
	mov sp, bp

	inc finger_cGoReal	

	pop bp
	pop di
	pop dx
	pop si
	pop es
	pop cx
	pop ds
	pop bx
	pop ax
	iret

CrossInterrupt endp

GoProtected proc near
;
; On entry, si is the return address.
;
; Corrupts ax and dx.
;
; On exit, ds is data alias for TSS, cs is this segment, es is
; a valid selector, dx is rmwaBase
;

; establish addressing to finger area
	xor ax, ax
	mov es, ax
assume es:Finger

%IF(NOT %GP) THEN (
	cmp finger_wProcType, SG5000
	je RestoreDTRs
	cmp finger_wProcType, b38lcw
	je RestoreDTRs

; clear X-Bus ear
	mov dx, finger_portXBusEar
	out dx, ax


; If we are on a newgen, and some non-video ear was in effect, then the
; code upon entry to real mode turned off the NewGen video bit.  We must
; now turn it on again, if this is the case.  Since it would take longer
; to test to see if that is the case than to just do the I/O, we'll just
; do the I/O in all cases, since it all other cases such I/O is benign.
; For the 386i this is also benign.

	mov dx, finger_portParity
	mov ax, parityOn+newgenVideoBit
	out dx,ax

;	mov finger_checkLevel, bx ; for debugging
)FI%' NOT GP

; Paging not enabled yet. We must load gdtr and idtr with physical
; addresses. Since baseLinearOffset is the Msb of the start of la space, use 
; it to convert the linear address in finger_gdtr and finger_idtr to physical.
RestoreDTRs:
	test finger_fPaging,1
	jz Restore24BitGdtAndIdt

	cmp finger_gdtrBaseHi,0
	je Restore24bitGDTandIDT
	mov al, finger_bBaseLinearOffset
	sub	al,1
	and finger_gdtrBaseHi,al
	and finger_idtrBaseHi,al

	db 66h
	lgdt finger_gdtr
	db 66h
	lidt finger_idtr

; replace so load after paging enabled works
	mov al, finger_bBaseLinearOffset
	or finger_gdtrBaseHi, al
	or finger_idtrBaseHi, al
	jmp GdtAndIdtRestored

Restore24BitGdtAndIdt:
; restore pointers to GDT and IDT
	lgdt finger_gdtr
	lidt finger_idtr
GdtAndIdtRestored:


; set protected mode port
%IF(%GP) THEN (
	mov dx, finger_portProtectEnable
	in  ax, dx
	or ax, protectedBootRom
	out dx, ax
) ELSE (
	cmp finger_wProcType,b38lcw
	jne Notb38lcw2
	MOV		AL,cmdWrite82106
	out		Reg82c106Cmd,AL
WaitCmdTaken1A:
	in		AL,Reg82c106Cmd
	and		AL,2
	  jne	WaitCmdTaken1A		;Wait for controller to take cmd
	mov		al, GoPro82106
	out		Reg82c106Data,al
WaitCmdTaken2A:
	in		AL,Reg82c106Cmd
	and		AL,2
	jne		WaitCmdTaken2A		;Wait for kbd controller to take cmd
	jmp		Chg_MSW


Notb38lcw2:
	mov  dx, finger_portProtectEnable
	cmp  finger_wProcType, SG5000
	jne  NotPS2b
	mov  dx, protectedModeEnablsgen	; Enable A20
	in   al, dx
	cmp  al, 0ffh
	je   Must2BeP1
	mov  al, 02h
	out dx,al
	jmp Chg_MSW

Must2BeP1:
	mov  dx, SystemCtlPortSGEN	; enable A20
	in  al,dx
	and al,0FDh
	out dx,al
	jmp Chg_MSW
NotPS2b:
	mov ax, 1
	out dx, ax
)FI

; go protected - used saved msw
Chg_MSW:
	mov ax, finger_wMsw
	lmsw ax
	jmp near ptr ClearQueue
ClearQueue:

; put a selector in CS
	jmp far ptr EstablishCS
EstablishCS label far

; turn paging back on if necessary
	mov ax, sgIdentityLowMem
	mov es, ax
assume es:Finger
	mov al, finger_fPaging
	rcr al, 1
	jnc RestoreTR

; load CR3 with address of page map
	db   66h 
	mov  ax, finger_paGlobalPagemap  ; mov eax, paPagemap
	db 0Fh, 22h, 018h  ; mov cr3, eax

; turn on paging bit in CR0
	mov  ax, 8000h
	db   66h
    shl  ax, 16 ; shl eax, 16
	smsw ax
	db 0Fh, 22h, 000h  ; mov cr0, eax
; restore pointers to GDT and IDT
	db 66h
	lgdt finger_gdtr
	db 66h
	lidt finger_idtr

RestoreTR:
	mov ax, finger_wTr
	ltr ax

	inc finger_cGoProtected ; for debugging

; establish addressing for TSS
	sub ax, 8 ; data alias for TSS
	mov ds, ax
	mov dx, finger_rmwaBase
	jmp si
GoProtected endp


RealKernelEntry proc far
	xor di, di
	jmp short SystemCall
RealKernelEntry endp

RealRqInterfaceEntry proc far
	mov di, 2
	jmp short SystemCall
RealRqInterfaceEntry endp

RealOssubEntry proc far
RealOssubEntryNear:
	mov di, 4
	jmp short SystemCall
RealOssubEntry endp

SystemCall proc near

; save real mode DS in a register since DS is reset
; by GoProtected

; DI indicates the type of system call
;
; 0 = kernel call
; 2 = rqInterface
; 4 = ossub 

	mov cx, ds
	mov si, offset Continue_SystemCall
	jmp near ptr GoProtected

Continue_SystemCall:
	mov si, dx ; si is rmwa base

; indicate to debugger that real context frame is not valid
	mov rmwa_wSpReal, 0FFFFh

; save real DS and SS
	mov Rmwa_wDSReal, cx
	mov bx, ss
	mov Rmwa_wSSReal, bx

; Establish protected mode stack - this must be done on each
; entry since program may change SS.
;
; First rewrite sa field in gdt links - this field needed
; for dealiasing from selector to sa.
;
; bx = ssReal

	mov ax, DGroup
	mov es, ax
assume es:DGroup

; do nothing for interrupt task

	str ax
	cmp ax, sgTssIntLast
	ja NotInterruptTask
	mov bx, rmwa_sgSS
	jmp short EstablishSS

NotInterruptTask:

	mov es, word ptr [pRgoGdtLink+2]
assume es:nothing
	mov ax, Rmwa_sgSS
	shr ax, 3 ; iSgSS = shr(rmwa_sgSS,3)
	mov dx, sGdtLink
	mul dx
	xchg ax,bx        ; bx = .rgGdtLink(iSgSS), ax = ssReal

	mov dx, es:[bx+2] ; dx = link.sa
	cmp dx, ax ; if rgGdtLink(iSgSS).sa = ssReal then done
	jne StackSwitch
	mov bx, Rmwa_sgSS
	jmp short EstablishSS

StackSwitch:
	cmp dx, 0FFFFh
	je InitStack

; user is switching stacks, need a new selector

	push ds
	mov bx, DGroup
	mov ds, bx
	call FarAliasIpcSr
	mov bx, ax
	pop ds
	jmp EstablishSS

InitStack:
; stack descriptor has never been initialized, so do it
	mov es:[bx+2], ax ; rgGdtLink(iSgSS).sa = ssReal
; shl(double(ss),4)
	xor dx, dx
	clc
	rcl ax, 1
	rcl dx, 1	; SHL(ax,dx),1
	rcl ax, 1
	rcl dx, 1	; SHL(ax,dx),2
	rcl ax, 1
	rcl dx, 1	; SHL(ax,dx),3
	rcl ax, 1
	rcl dx, 1	; SHL(ax,dx),4

; let es:bx address the gdt slot
	mov cx, sgGdt
	mov es, cx
	mov bx, rmwa_sgSS
	mov Desc286_base, ax
	mov Desc286_baseHi, dl

EstablishSS:
	mov ss, bx	

; dispatch to system call
;	SP -> |IPHack|
;	   +2 |CSHack|
;	   +4 |  FL  |
;	   +6 |IPReal|
;	   +8 |CSReal|
	pop  bx; BX = encoded IP
	pop  ax ;SI = encoded CS

	pop  rmwa_wFlReal
	pop  rmwa_wIpReal
	pop  rmwa_wCsReal

; Push return frame for appropriate dispatch after call.
	push cs
	push CS:ipReturnFromSystemCall[di]
	push rmwa_wFlReal

	push ax ; encoded CS
	push bx ; encoded IP
	jmp  WORD PTR CS:ipSystemEntry[di]
; .. does short call first to avoid double far call for ossubs.

ipReturnFromSystemCall DW ReturnFromSystemCall,ReturnFromSystemCall,OssubReturn
ipSystemEntry          DW EnterCEntry,         EnterRqInterface,    EnterOssub

EnterCEntry:
	jmp far ptr CEntry

EnterRqInterface:
	jmp far ptr RqInterface

EnterOssub:
; cx:di = pRmwa_rgSgAlias, needed by OssubEntry
	mov cx, ds
	lea di, rmwa_rgSgAlias
; dx = rmwa_sgSS, needed by OssubEntry
	mov dx, rmwa_sgSS
; make DS=SS for medium model
	push ss
	pop  ds
; cx:di is pRmwa_rgSgAlias
	jmp far ptr OssubEntry

OssubReturn:
; system common routines which must return a pointer in ES:BX (e.g. batch 
; bytestreams) instead return the pointer in CX:BX and we to move it to real
; mode programs's ES:BX.
	push cx		; save returned ES
	push bx		; save returned BX

	mov dx, ax ; ercRet
	str	 bx
	sub  bx, 8
	mov  ds, bx
	mov bx, sgLowMem
	mov es, bx
assume es:Finger
	mov si, finger_rmwaBase
	lea di, rmwa_rgSgAlias
DealiasLoop:
	mov ax, word ptr [di]
	or ax, ax
	jz RestoreRmosESBX
	call FarDealiasToSr
	add di, 2
	jmp short DealiasLoop

RestoreRmosESBX:
	pop di		; returned BX
	pop cx		; returned ES
	jmp short PushContextFrame

ReturnFromSystemCall:
	mov dx, ax ; ercRet
	mov bx, sgLowMem
	mov es, bx
assume es:Finger
	mov si, finger_rmwaBase

PushContextFrame:
; build a context frame for reentry to real mode
	push rmwa_wFlReal
	push rmwa_wCSReal
	push rmwa_wIPReal


%if(%fDebug)then(
; debugging code - trap on erc
	mov bx, DGroup
	mov es, bx
assume es:DGroup
	cmp ax, ercRetTrap
assume es:nothing
	jne PushContextFrame
	int 3
PushContextFrame:
)fi
	
	push dx           ; ax, ercRet
	push di           ; rmos BX saved above
	push rmwa_wDSReal ; ds
	push cx 		  ; garbage
	push cx			  ; rmos ES saved above
;	push si
;	push dx
;	push di
	sub  sp, 6
	push bp
; end of context frame

	mov cx, rmwa_wSSReal
	mov bp, sp
	jmp near ptr ResumeRealMode		

SystemCall endp


RealDispatcher proc far
	sti
; get real mode ss:sp out of tss 
	str ax
	sub ax, 8
	mov ds, ax
	mov ax, sgLowMem
	mov es, ax
assume es:Finger
	mov si, finger_rmwaBase
	mov cx, rmwa_wSsReal
	mov bp, rmwa_wSpReal
	jmp near ptr ResumeRealMode	

RealDispatcher endp

SwitchStackAndCallReal proc near
;
; For use by EnterBootRom and CallVideoRom.  Used only when real mode
; procedure cannot run on the same stack as protected mode.  Switches
; to a dedicated stack at 0:800h.
;
;   SS:SP are a protected mode stack
;	DX = DX for real mode
;	AX = AX,BX,CX,ES,SI for real mode
;	CX = DS for real mode
;	DS = caller's DS (preserved)
;	DI = IP for real mode
;   SI = CS for real mode

; save current SS:SP
	mov bx, sgLowMem
	mov es, bx
assume es:Nothing
	mov es:[7feh], sp
	mov bx, ss
	mov es:[7fch], bx

; switch to dedicated real mode interrupt stack
	mov bx, sgIdentityLowMem
	mov ss, bx
	mov sp, 7fch

	push ds

; set up rmwa_wSSReal, rmwa_sg
	push si
	mov es, bx
assume es:Finger
	mov si, finger_RmwaBase
	str bx
	sub bx, 8
	mov ds, bx
	mov rmwa_wSSReal, 0  ; real mode SS
	mov rmwa_sgSS, sgLowMem
	pop si

	call far ptr CallRealIsrEntry
	pop ds

	pop  si ; saved ss
	pop  cx ; saved sp
; restore stack
	mov ss, si
	mov sp, cx
	ret
SwitchStackAndCallReal endp

EnterBootRom proc far
; procedure (rES, rDX)

rES equ word ptr [bp+8]
rDX equ word ptr [bp+6]

	push bp
	mov bp, sp
; Hack alert!  On the 386i we have to turn on the bootrom, but we have to do 
; it after we are executing in real mode in the lower 1Mb of memory.  Since
; the boot rom sits at the top of the first 16Mb memory space, we cannot
; enable it from protected mode, because the descriptor tables and global
; page table may lie under the rom.  Since processor type is not available in
; the finger area, clobber the variable finger_portparity with the value 
; 5555h.   After we are in real mode, if finger_portparity is 5555h, then
; we know we are on a 386i and can enable the bootrom before jumping to it.
	mov ax, sgLowMem
	mov es, ax
assume es:Finger

%IF(NOT %GP) THEN (
	cmp  finger_wProcType, SG5000
	je   EnterSgenRom
	cmp  finger_wProcType, b38lcw
	jne  Notb38lcw3
	mov  finger_portparity, 7777h	; b38lcw enterbootrom flag
	mov   al, 80h
	out   rtcmosAddressReg, al		; disable nmis 
	jmp  not386iRomEntry

Notb38lcw3:
	mov ax, finger_portParity ;are we on a 386i?
	cmp ax, parityEnablePort386i
	jne not386iRomEntry
	mov finger_portparity, 5555h

not386iRomEntry:
)FI%' NOT GP

	mov dx, rDX
	mov ax, rES    ; ax will be real mode es when real mode reentered
	mov si, 0FFFFh ; cs of bootrom entry
	xor di, di     ; ip
	cli
	call SwitchStackAndCallReal
; Never returns
	jmp .+0

%if (not %gp) then(
EnterSgenRom:
;	mov    ax, dgroup				; p1 hack...
;	mov    ds, ax					; assert: did not go real if sgen
;assume ds: dgroup
;	test   vfSGenP1, 1
;assume ds: nothing
;	jz     NotSGenP1
;	push   0						; we work OK; boot rom does not
;	call   Crash					; will not EnterBootRom if vfSGenP1
;NotSGenP1:							; ...p1 hack

	mov    bx, rES 					; get parameter off stack
	test   bx, 1h					; wstype set?  
	jz     testDisk
	test   bx, 10h					; Yes, so test for nodump flag
	jnz    NoAutoDump
	jmp    AutoDump
testDisk:
	test   bx, 02h					;
	jz     NoAutoDump
AutoDump:
	mov    al, 0bfH					; address 3fh + bit 7 set (no nmi)
	out    RTCmosAddressReg, AL
	jmp    $+2
	mov    al, 0aah					; auto dump signature
	out    RTCmosDataReg, AL
	jmp    $+2
	
NoAutoDump:
	mov    dx, lShadowRomEnableReg
	xor    al, al					; ExRomEn#=0, RomEn#=0
	out    dx, al
	jmp    $+2

	mov    dx, protectedModeEnablSGEN;
	in     al,dx
	cmp    al, 0ffh
	je     Must3BeP1

	mov    al, 3h					; system reset
	out    dx, al					; should not return
	jmp .+0 

Must3BeP1:
	mov    dx, SystemCtlPortSGEN	; 
	mov    al, 1					; system reset
	out    dx, al					; should not return
	jmp .+0 
)fi

EnterBootRom endp




CallVideoRom proc far
; procedure (bChar, oPRomCode)
opRomCode equ word ptr [bp+6]
bChar equ byte ptr [bp+8]
	push bp
	mov bp, sp
	mov al, bChar
	mov di, opRomCode
	mov si, word ptr [di+2] ; get real cs:ip
	mov di, word ptr [di]
	xor cx, cx ; real DS = 0
	pushf
	cli
	call SwitchStackAndCallReal
	popf
	pop bp
	ret 4

CallVideoRom endp

CallRealIsr proc far
; procedure (ip, cs, ds)

; Used to make a procedure call to a real mode from a protected mode
; interrupt handler.  Allows setting of CS:IP and DS. 
;
; Requires that the protected mode interrupt stack be in the first
; megabyte, since the stack is not switched.  Interrupt stacks are
; allocated in the first megabyte if they are defined in Sysgen.asm
; by setting the 8000h bit in the stack size parameter.

isrIP equ word ptr [bp+10]
isrCS equ word ptr [bp+8]
isrDS equ word ptr [bp+6]

	push bp
	mov  bp, sp
	mov  di, isrIP
	mov  si, isrCS
	mov  cx, isrDS
	call far ptr CallRealIsrEntry	
	pop  bp
	ret 6
CallRealIsr endp

CallRealCommIsr proc far
; The CommNub calls CallRealCommIsr to transfer control to a
; real mode comm interrupt routine.  Since parameters are passed
; in registers, this can only be called from assembly language.
;
; On entry,
;   SS:SP are an interrupt stack, return address on stack
;	DX = i/o port
;	BX = ISR BX
;	CX = ISR DS
;	DS = caller's DS (preserved)
;	DI = opProc
	
	mov ax, bx


; put pProc in si:di
	mov si, word ptr [di+2]
	mov di, word ptr [di]

CallRealIsrEntry label far
	pushf ; so that NT bit is preserved
	push ds

	mov bx, sgLowMem
	mov	es, bx  ; address finger area
assume es:Finger

; push address that ISR will return to

	push finger_saIntReturn		; cs
	push offset RealCommIsrRet	; ip

; push IRet frame
	pushf   ; if mediated, want interrupts on in real mode
	push si ; cs
	push di ; ip

; push rest of it
	push ax ; push ax - undefined
	push ax ; push bx - CallRealCommIsr BX or undefined
	push cx ; push ds - real mode DS
	push ax ; push cx - undefined
	push ax ; push es - EnterBootRom ES or undefined
	push ax ; push si - undefined
	push dx ; push dx - real mode DX
	sub sp, 4
			; push di - undefined
			; push bp - undefined

	mov bp, sp ; real mode sp
; fetch real mode SS
	mov si, finger_RmwaBase
	str bx
	sub bx, 8
	mov ds, bx
	mov cx, rmwa_wSSReal  ; real mode SS
	cli        ; in case we are mediated (interrupts could be on)

; go to common code that resumes real mode
	jmp ResumeRealModeEarSet

; wind up here when comm isr does a RET
RealCommIsrRet:
	cli ; cannot handle interrupt in go protected path; interrupts
        ; restored below before return to caller
; need to preserve DS, BX, AX for CommNub, DS saved in CX
	mov bp, ax
	mov cx, ds
	mov si,  offset Continue_RealCommIsrRet
	jmp near ptr GoProtected
Continue_RealCommIsrRet:

; restore protected mode interrupt stack
	mov si, dx
	mov ax, rmwa_sgSS
	mov ss, ax

	mov ax, bp
; on exit, AX preserved
	pop ds
	popf
RmosRet label far
	ret

CallRealCommIsr endp

RmosBogusOpHandler proc far
; A pointer to this routine is placed in real mode interrupt vector
; 6 by initVector_p.plm.  On a 386, a LOCK prefix preceeding an I/0
; instructions causes and illegal opcode exception (int 6).  This
; handler patches the LOCK prefix to a NOP.  If the illegal opcode is
; not a LOCK, the user is terminated via ErrorExit;

opCodeLock equ 0F0h
opCodeNop  equ 090h
flFault equ word ptr ss:[bp+6]
csFault equ word ptr ss:[bp+4]
ipFault equ word ptr ss:[bp+2]

	push bp
	mov bp, sp
	push es
	push bx

	mov bx, csFault
	mov es, bx
	mov bx, ipFault
	cmp byte ptr es:[bx], opcodeLock
	jne BogusOpExit
	mov byte ptr es:[bx], opcodeNop

	pop bx
	pop es
	pop bp
	iret

BogusOpExit:
	push ercBogusOp
	jmp short DoCrash

RmosBogusOpHandler endp

RmosDivideOverflow proc far
	push bp
	mov  bp, sp
	push ercDivideOverFlow
	jmp short DoErrorExit

RmosDivideOverflow endp

RmosGpFault proc far
	push bp
	mov  bp, sp
	push ercRmosGpFault
	jmp short DoErrorExit

RmosGpFault endp

DoErrorExit proc near
; DoErrorExit terminiates the user via ErrorExit.  Assumes caller is
; still in real mode and erc has been pushed on the stack. Also, BP
; points to an interrupt frame.

csErrorExitHack equ 0FFEFh
ipErrorExitHack equ 336h

; make stack look like error exit was called from the cs:ip
; that the exeception occured at
 
	push csFault
	push ipFault
	push flFault
	push csErrorExitHack
	push ipErrorExitHack
	jmp RealOssubEntryNear	
DoErrorExit endp

DoCrash proc near
; DoCrash terminiates the user via Crash.  Assumes caller is
; still in real mode and erc has been pushed on the stack. Also, BP
; points to an interrupt frame.

csCrashHack equ 0FFDFh
ipCrashHack equ 432h

; make stack look like error exit was called from the cs:ip
; that the exeception occured at
 
	push csFault
	push ipFault
	push flFault
	push csCrashHack
	push ipCrashHack
	jmp RealOssubEntryNear	
DoCrash endp

SwapXbEarReal proc far

	push ds
	mov ax, DGROUP
	mov ds, ax
ASSUME  DS:Dgroup

	mov ax, [bp+4]
	cmp ax, sgRealInterface
	pop ds
ASSUME DS:Nothing

	je RealCaller
	mov ax, 0
	ret 2

RealCaller:
	push bp
	mov bp, sp
	push ds

;Note that we swap ear only for calling process
	str ax
	sub ax, 8
	mov ds, ax
	mov ax, sgLowMem
	mov es, ax
assume es:Finger
	mov si, finger_rmwaBase

	mov ax, rmwa_ear
	mov bx, [bp+6]
	mov rmwa_ear, bx

	pop ds
	mov sp, bp
	pop bp
	ret 2
SwapXbEarReal endp

; Coprocessor state save model.
;
; The coprocessor is in one of three states
;
; 1) unloaded - contains no process state
; 2) half-loaded - hardware reset occured, regs valid, environment invalid
; 3) loaded - contains process state
;
; When trap 7 occurs, the compare the running process to the process
; owning the coprocessor and take the following action.
;      
;             Unloaded           Half-loaded         Loaded
; SAME        n/a                restore env         do nothing
;
; DIFFERENT   restore state(new) restore envn (old)  save state (old) 
;                                save state (old)    restore state (new)
;                                restore state (new)


RmosCoprocessorNotPresentTrap proc far
; The default protected mode int 75 handler will terminate
; the user.  This interrupt may be replaced by a
; math server.  If the interrupt handler returns, TS is cleared
; to suppress subsequent traps.
	int 75 
	clts
	iret
RmosCoprocessorNotPresentTrap endp


RmosCoprocessorTrap proc far
	push	ds
	push	es
	push	ax
	push	bx

	xor		ax, ax
	mov		es, ax ; address finger area
assume es:Finger

	mov		ax, finger_saDGroup
	mov		ds, ax

	mov		bx, finger_saCoprocessorState

	inc		finger_rsvd2  ; FOR DEBUGGING
	jmp		short CommonCoprocessorTrap

RmosCoprocessorTrap endp

CoprocessorTrap proc far
; NOTE: this code has been copied into Crash_all.asm so that it can be 
; called from the PC Emulator.
	push	ds
	push	es
	push	ax
	push	bx

	mov		ax, sgLowMem
	mov		es, ax; address finger area
assume es:Finger
	inc		finger_rsvd3  ; FOR DEBUGGING

	mov		ax, DGroup
	mov		ds, ax
assume DS:DGroup
	mov		bx, word ptr [pCoprocessorState+2]

CommonCoprocessorTrap:
	pushf
	cli
	clts
	db		9Bh ; wait - in case of coprocessor error in another process
	test	finger_pidCoprocessor, 8000h
	jz		TestSame

; half-loaded, so load environment
	push	es
	push	bx
	mov		es, bx
	mov		bx, oCoprocessor
	db		09bh, 026h, 0d9h, 027h, 09bh	;fldenv	es:byte ptr [bx], wait
	pop		bx
	pop		es
	and		finger_pidCoprocessor, 7FFFh ; unmark half-loaded
TestSame:
	mov 	ax, oPcbRun
	sub 	ax, orgPcb
	cmp		ax, finger_pidCoprocessor
	je		EarlyRet

	push	cx
	push	dx

	mov		finger_pidCoprocessor, ax ; the new owner

; finger_pidCoprocessor (ax) is (oPcbRun-orgPcb)
; iPcbCoprocessor (ax) = ax/size(pcb)
	xor		dx, dx
	mov		cx, pcbSize
	div		cx

	mov		es, bx   ; saCoprocessorState

; if coprocessor state is valid (iPcbCoprocessor <> 0), save it
	mov		bx, oCoprocessor
	or		bx, bx
	jz		LoadCoprocessor
	db		09bh, 026h, 0ddh, 037h, 09bh	;fnsave	es:byte Ptr[bx]
LoadCoprocessor:

	mov		cx, c287state
	mul		cx
	mov		bx, word ptr [pCoprocessorState]
	add		bx, ax
	mov		oCoprocessor, bx

	db		09bh, 026h, 0ddh, 027h, 09bh	;frstor	es:byte ptr [bx], wait

; assert - finger_pidCoprocess is (oPcb-orgPcb) of coprocessor owner
;          saCoprocessr:oCoprocessor addresses save area of coprocessor owner

	pop		dx
	pop		cx
EarlyRet:
	popf
	pop		bx
	pop		ax
	pop		es
	pop		ds
	iret	
CoprocessorTrap endp

RealInterface_code ends

end
