$TITLE('<Os>RemoteAddr_bmic.asm')
$MOD386
;
;  <Os>RemoteAddr_Bmic.asm
;


%SET(CtosP,1)
%SET(GP,0)
%SET(BT,0)
%SET(DualMode,0)
%SET(FS,0)
%SET(BMIC,0FFh)
%SET(fDebugDma,0)
%SET(export,0)

$Include(:f1:SrpHw.mdf)
$Include(:f1:Cdt.mdf)
$Include(:f1:Icc.mdf)
$Include(:f1:Comarch.mdf)

ercOk Equ 0
ercOldOS Equ 121
ercNoSuchProcessor	Equ 152


Public	BuildRemoteAddr
Public	RemotebSlotBr0

%IF (NOT (%FS)) THEN (
Public pMyIcc, Peek,Peekw,Peekb, Poke,Pokew,Pokeb, PXchg,PXchgw,PXchgb, PLoad
Public PSet, PaMyIcc
Public	InitRemoteCdt
Public	ReadyRemoteBoot
Public	GetCdtAddr
Public	LockSlotCdt
Public	InitSlotAddressTables
Public	BSlotLocal
Public	CdtCopyBack
Public	CdtLoad
Public	AllocRemoteIccSegment
) FI

%IF (%FS) THEN (
Extrn	AllocP: Far
) ELSE (
Extrn	AllocPSub: Far
Extrn	BmicCmd: Far
Extrn	Crash: Far
Extrn	Delay: Far
Extrn	ReleaseP: Far
Extrn	PaFromP: Far
Extrn	StealAlignedSl: Far
) FI

userNumOs EQU 0FFFFh

DGroup	Group Data

Data	Segment	Public 'Data'

%IF (NOT (%FS)) THEN (
EXTRN   bMySlot: BYTE, pCdt: DWORD, mpbSlotiSlot: BYTE
EXTRN	rgSgIcc: WORD, mpiSlotSg: WORD
EXTRN	vf: BYTE
EXTRN	iMySlot: BYTE

EXTRN raLog: WORD
EXTRN rgLogIcc: DWORD


PUBLIC	mpiSlotBr0Cdt, mpiSlotpCdt
mpiSlotBr0Cdt DW 10 DUP(0)
mpiSlotpCdt DD 10 DUP(0)

PUBLIC	addr0
addr0	DW 3 DUP(?)	; p, br0

PUBLIC	addrReset
addrReset	DW 3 DUP(?)	; p, br0

PUBLIC qCdtCollision
qCdtCollision DD 0

PUBLIC pmpISlotPaCdt
pmpISlotPaCdt DD 0

PUBLIC rgIoDoorbell
rgIoDoorbell DW ?,?,?,?,?,?,?,?,?,?	; PC vs BMIC different

PUBLIC rgIoDoornail
rgIoDoornail DW ?,?,?,?,?,?,?,?,?,?	; PC vs BMIC different

PUBLIC pfPcRemoteAddr
pfPcRemoteAddr DD fPc

PUBLIC comarchConfig
comarchConfig DB sComarchConfig DUP(?)
ORG OFFSET comarchConfig
comarchConfig_qbMemory DD ?		
comarchConfig_qbSerialId DD ?	
comarchConfig_romVer     DW ?	
comarchConfig_osBuffer   DW 8 DUP(0)	
comarchConfig_resetType  DB ?	
comarchConfig_bootType   DB ?
comarchConfig_memError   DB ?
comarchConfig_ercType    DB ?
ORG OFFSET comarchConfig+sComarchConfig

PUBLIC paComarchConfig
paComarchConfig DD ?

cIccAllocDelay DW 100
) FI

Data	Ends

$Include(:f1:vfEqu.idf)


Kernel	SEGMENT	PUBLIC	'Code'
EXTRN SuspendDma: NEAR
EXTRN UnsuspendDma: NEAR
KGroup GROUP Kernel

Assume Cs : KGroup, Ds : DGroup

fPc DB ?

lmaskParagraph EQU 0FFF0h
lmaskPage EQU 0F000h
lRemoteReference386High EQU 0E0h
lmaskBase386High EQU 0F0h

%*Define(PRemoteAxBx) LOCAL PBmic PRet (
; EAx is pa, return p(Ax,Bx).
	Test fPc, 1
	Jz  %PBmic
	Mov Cx, Ax
	And Cx, NOT lMaskParagraph
	Push Cx			; ra
	And Ax, lMaskParagraph
	Push EAx		; base
	Push 0FFFFh		; limit
	Jmp  Short %PRet

%PBmic:
	Mov	Cx, Ax
	And Cx, NOT lMaskPage
	Push Cx			; ra
	Shr	EAx, 12
	Push	0		; Wacky: base is 0, limit is pa page.
	Push	0
	Push	Ax
%PRet:
	Push	userNumOs
%IF (%FS) THEN (
	Call	AllocP
) ELSE (
	Call	AllocPSub
) FI
;	ES:BX is p

	Mov	Ax, ES
	Pop Bx			; ra
;	(Ax:Bx) is p
)

;
;  BuildRemoteAddr:PROCEDURE(pa, oAddr) ercType;
;  DECLARE pa DWORD, oAddr OFFSET, addr BASED oAddr STRUCTURE(p PTR, br0 WORD);
;  END;
;
oAddr	Equ	word Ptr [Bp+6]
pa		Equ dword Ptr [Bp+8]
BuildRemoteAddr	Proc	Far
	Push	Bp
	Mov	Bp, Sp
	Mov	EAx, dword ptr pa
; EAx is pa, return p(Ax,Bx).
	%PRemoteAxBx
	Mov	Si, oAddr
	Mov	[Si], Bx
	Mov	[Si+2], Ax
	Mov	WORD PTR [Si+4], 0
	Pop	Bp
	Xor	Ax, Ax
	Ret	6
BuildRemoteAddr Endp


; RemotebSlotBr0: PROCEDURE(bSlot, br0);
;    Declare bSlot Byte;
;    Declare br0 Word;
; End RemotebSlotBr0;

br0		Equ SS : WORD Ptr [Bp+6]
bSlot	Equ	SS : byte Ptr [Bp+8]

RemotebSlotBr0	Proc	Far
	Ret	4
RemotebSlotBr0	Endp


%IF (NOT (%FS)) THEN (

;
;  PMyIcc:PROCEDURE(pa) POINTER;
;  DECLARE pa DWORD;
;  END;
;
; If on PC, just AllocP to local icc segment.

pa		Equ dword Ptr [Bp+6]
PMyIcc	Proc	Far
	Enter 0,0
	Mov	EAx, dword ptr pa
; EAx is pa, return p(Ax,Bx).
	%PRemoteAxBx
	Mov Es, Ax
	Leave
	Ret	4
PMyIcc Endp


;	Peek: Procedure (p) DWORD;

p EQU DWORD PTR [BP+6]
Peek PROC FAR
	ENTER 0,0
	LES BX, p
	%Peek EAX,ES:[BX]
	MOV EDX, EAX
	SHR EDX, 16
	LEAVE
	RET 4
Peek ENDP

Peekw PROC FAR
	ENTER 0,0
	LES BX, p
	%Peekw EAX,ES:[BX]
	MOV EDX, EAX
	SHR EDX, 16
	LEAVE
	RET 4
Peekw ENDP

Peekb PROC FAR
	ENTER 0,0
	LES BX, p
	%Peekb EAX,ES:[BX]
	MOV EDX, EAX
	SHR EDX, 16
	LEAVE
	RET 4
Peekb ENDP

;	Poke: Procedure (p, d);

p EQU DWORD PTR [BP+10]
d EQU DWORD PTR [BP+6]
Poke PROC FAR
	ENTER 0,0
	LES BX, p
	MOV EAX, d
	%Poke ES:[BX],EAX
	LEAVE
	RET 8
Poke ENDP

p EQU DWORD PTR [BP+8]
w EQU [BP+6]
Pokew PROC FAR
	ENTER 0,0
	LES BX, p
	MOV AX, w
	%Pokew ES:[BX],AX
	LEAVE
	RET 6
Pokew ENDP

b EQU [BP+6]
Pokeb PROC FAR
	ENTER 0,0
	LES BX, p
	MOV AX, w
	%Pokeb ES:[BX],AL
	LEAVE
	RET 6
Pokeb ENDP

p EQU DWORD PTR [BP+10]
d EQU DWORD PTR [BP+6]
PXchg PROC FAR
	ENTER 0,0
	LES BX, p
	MOV EAX, d
	%PXchg EAX,ES:[BX]
	MOV EDX, EAX
	SHR EDX, 16
	LEAVE
	RET 8
PXchg ENDP

p EQU DWORD PTR [BP+8]
w EQU [BP+6]
PXchgw PROC FAR
	ENTER 0,0
	LES BX, p
	MOV AX, w
	%PXchgw AX,ES:[BX]
	LEAVE
	RET 6
PXchgw ENDP

b EQU [BP+6]
PXchgb PROC FAR
	ENTER 0,0
	LES BX, p
	MOV AX, b
	%PXchgb AL,ES:[BX]
	LEAVE
	RET 6
PXchgb ENDP

;	PLoad: Procedure (pRemote, pTo, cb);
pRemote EQU DWORD PTR [BP+12]
pTo     EQU DWORD PTR [BP+8]
cb      EQU WORD PTR  [BP+6]
PLoad PROC FAR
	ENTER 0,0
	MOVZX ECX, cb
	ROR ECX, 2
	OR  CX, CX
	JZ  PLoadTail
	XOR EBX, EBX
PLoadLoop:
	LES BX, pRemote
	%Peek	EAX,ES:[EBX-4][ECX*4]
	LES BX, pTo
	MOV ES:[EBX-4][ECX*4], EAX
;	Loop PLoadLoop
	DEC CX
	JNZ PLoadLoop
PLoadTail:
	ROL ECX, 2
	OR  CX, CX
	JZ  PLoadDone
PLoadbLoop:
	LES BX, pRemote
	%Peekb	EAX,ES:[EBX-1][ECX]
	LES BX, pTo
	MOV ES:[EBX-1][ECX], AL
;	Loop PLoadbLoop
	DEC CX
	JNZ  PLoadbLoop
	
PLoadDone:
	LEAVE
	RET 10
PLoad ENDP

;	PSet: Procedure (b, pRemote, cb);
b       EQU BYTE PTR  [BP+12]
pRemote EQU DWORD PTR [BP+8]
cb      EQU WORD PTR  [BP+6]
PSet PROC FAR
	ENTER 0,0
	MOVZX ECX, cb
	ROR ECX, 2
	OR  CX, CX
	JZ  PSetTail
	XOR EBX, EBX
PSetLoop:
	LES BX, pRemote
	MOV AL, b
	MOV AH, AL
	MOV DX, AX
	ROL EAX, 16
	MOV AX, DX
	%Poke	ES:[EBX-4][ECX*4], EAX
;	Loop PSetLoop
	DEC CX
	JNZ  PSetLoop
PSetTail:
	ROL ECX, 2
	OR  CX, CX
	JZ  PSetDone
PSetbLoop:
	LES BX, pRemote
	MOV AL, b
	%Pokeb	ES:[EBX-4][ECX*4], AL
;	Loop PSetbLoop
	DEC CX
	JNZ  PSetbLoop
	
PSetDone:
	LEAVE
	RET 8
PSet ENDP

p EQU [BP+6]
PaMyIcc PROC FAR
	TEST fPc, 1
	JZ  PMI
	JMP PaFromP
PMI:
	ENTER 0,0
	MOV AX, WORD PTR p+2
	MOVZX EBX, WORD PTR p
;	LSL EAX, AX	; paBase
	DB 66h, 0Fh, 03h, 0C0h
	SHL EAX, 12
	ADD EAX, EBX
	MOV EDX, EAX
	SHR EDX, 16
	LEAVE
	RET 4
PaMyIcc ENDP
;
;
;  GetCdtAddr: Procedure (bSlot) Pointer;
;    Declare bSlot Byte;
;  End GetCdtAddr;
;
;  Routine sets up remote Cdt for reference
;  and returns a pointer to it in Es:Bx
;

bSlot	Equ	SS : byte Ptr [Bp+6]
GetCdtAddr	Proc	Far
	Push   Bp
	Mov    Bp, Sp
	Mov    Al, bSlot
	CMP    AL, bMySlot
	JNE    NotUs
	Les    Bx, pCdt
	Jmp    GCARet

NotUs:
; Make bSlot(Ax) into iSlot(Ax)
	Cbw
	Mov    Bx, Ax
	Mov    Al, mpbSlotiSlot[Bx]
	Cbw
; Load pre-recorded base,  pCdt
	Mov    Bx, Ax
	Shl    Bx, 2	; Address pointer table
	Les    Bx, mpiSlotpCdt[Bx]

;	Mov    Cx, ES
;	Or     Cx, Bx
;	Jcxz   InitSlotAddressTablesLocal

GCARet:
	Pop	Bp
	Ret	2

GetCdtAddr	Endp


bSlot	Equ	SS : byte Ptr [Bp+6]
;
;	InitSlotAddressTables:PROCEDURE(bSlot) ercType;
;or InitSlotAddressTables:PROCEDURE(bSlot) POINTER;
;	 Declare bSlot Byte;
;	END InitSlotAddressTables;
;
;	Call this routine the first time communicating with a remote board.
;	Returns ercOk/ercNonExistantBoard or pCdt.
;
InitSlotAddressTables	Proc	Far
	Push	Bp
	Mov	Bp, Sp
;InitSlotAddressTablesLocal:

	Les	Bx, pCdt
	Mov	Al, bSlot
	Cmp	Al, 9	; bus config table index
	Ja	ISATNSP
	Cbw
	Mov	Si, Ax
	Test	Byte Ptr Es:rgbBusConfigTable[Bx][Si], 80h ;80h means dead or null
	Jz	ISATOk
ISATNSP:
	Jmp	ISATNoSuchProcessor
ISATOk:

	Movzx	ESI, mpbSlotiSlot[Si]
	Les	Bx, mpiSlotpCdt[ESI*4]
	MOV	CX, ES
	JCXZ	ISATNSP

	%Peek EAX, Es:bMemorySize[Bx]
	SHR	EAx, 8
	Cmp	EAx, 0A600FFh
	Jne	ISATNSP

	%Peekb EAX, Es:fOsInitialized[Bx]
	Test	EAx, 1
	Jz	OldOS

;	Translate cdt.paIccSeg into addrIcc.
	%Peek ECX, Es:paIccSeg[Bx]
	Or	ECX, ECX
	Jz	OldOS	

	MOV	AX, mpiSlotSg[ESI*2]
	MOV	rgSgIcc[ESI*2], AX
	%PIcc rgSgIcc[ESi*2]
;	ES:Di is pIccSeg
;	Di(ra) for any Icc seg is always 0.  That means paragraph aligned.

	Xor	Ax, Ax
	Jmp	ISATExit

ISATNoSuchProcessor:
	Mov	Ax, ercNoSuchProcessor
	Xor	Bx, Bx
	Mov	Es, Bx
	Pop	Bp
	Ret 2

OldOS:
	Mov	Ax, ercOldOS
ISATExit:
	Les	Bx, mpiSlotpCdt[ESI*4]
	Pop	Bp
	Ret	2
InitSlotAddressTables	Endp


;	InitRemoteCdt
;
; Called by RemoteBoot to initialize a remote processor's Cdt
; The following information is copied from this processor's Cdt:
;	rgbBusConfigTable
;	bMasterFP
;	rgbFpXlate
; A gratuitous user number is also supplied.
;

bSlot		equ	byte ptr [bp+1Ch]
wUserNumber	equ	word ptr [bp+1Ah]
flagCdtIO	equ	byte ptr [bp+18h]
saPb		equ word ptr [bp+16h]
raPb		equ word ptr [bp+14h]
cb			equ word ptr [bp+12h]
paIcc		equ word ptr [bp+0Eh]
qbIcc		equ word ptr [bp+0Ah]
bDumpCmd	equ byte ptr [bp+08h]

; Called immediately after a boot.  Fill out cdt with slot-specific stuff.
InitRemoteCdt	Proc	Far
	Push	Bp
	Push	Ds
	Mov	Bp, Sp
	Push	word ptr bSlot
	Call	InitSlotAddressTables
	Or	Ax, Ax
	Jz	IRCOk
	Cmp	Ax, ercOldOs
	Je	IRCOk
	Pop	Ds
	Jmp	IRCExit		; Bad image booted - no valid cdt.

IRCOk:
	Mov	Di, Bx

;  Now Es:Di address the remote Cdt.

	Push	Di			; remember remote cdt offset

	Mov	Ax, wUserNumber
	Mov	Es : Word ptr nUserNumber[Di], Ax

	MOV AX, saPb		;if non-zero then set up pb/cb in cdt
	OR  AX, raPb
	JZ  foo
	MOV AX, raPb
	MOV ES: word ptr paConfigFile[DI], AX
	MOV AX, saPb
	MOV ES: word ptr paConfigFile[DI+2], AX
	MOV AX, cb
	MOV ES: word ptr cbConfigFile[DI], AX

foo:
	MOV EAX, paIcc		;if non-zero then set up pa/qb in cdt
	OR  EAX, EAX
	JZ  bar
	MOV ES: dword ptr paIccSeg[DI], EAX
	MOV EAX, qbIcc
	MOV ES: dword ptr qbIccSeg[DI], EAX

bar:
	mov al, bDumpCmd
	mov es: byte ptr bDumpCommand[di], al
	Mov	Al, flagCdtIO
	Mov	Es : Byte Ptr fCdtIO[Di], Al
	Xor	Al, Al
	Mov	Es : Byte Ptr fOsInitialized[Di], Al
	Mov	Es : Byte Ptr fWatchDog[Di], Al

;	Remember some slots before loading DS
	Mov	Al, bMySlot
	Mov	Ah, bSlot

	Lds	Si, pCdt

;  And Ds:Si addresses the local Cdt

Assume Ds : Nothing

	Mov	Es : Byte Ptr bMasterFP[Di], Al

;  Copy the hardware type over to help
;  out generic diagnostic type programs

	Mov	Al, Ah	; bSlot
	Cbw
	Add	Si, Ax
	Mov	Bl, Ds : Byte Ptr rgbBusConfigTable[Si]
	Sub	Si, Ax
	Mov	Es : Byte Ptr bProcessorType[Di], Bl

;  following assumes rgbFpXlate and rgbBusConfigTableEnts
;  are contiguous since whole is moved as a block

	Mov	Bl, Ds : Byte Ptr VerifyCode[Si]
	Mov	Es : Byte Ptr VerifyCode[Di], Bl
	Mov	Bx, Ds : Word Ptr wPanelStatus[Si]
	Mov	Es : Word Ptr wPanelStatus[Di], Bx
	Add	Di, OFFSET rgbFpXlate
	Add	Si, OFFSET rgbFpXlate
	Mov	Cx, sFpCount+cBusConfigTableEnts
	cld
Rep	MovSb

	Pop	Di			; Es:Di again remote Cdt addr
	Pop	Ds
Assume Ds : Dgroup

%IF(%BMIC) THEN (
	Mov		Dl, bSlot
	Shl		Dx, 12
	Or		Dx, lPortComarchSlot
	Mov		Al, bSlot
	Out		Dx, Al
) ELSE (
	Mov	Si, Ax
;	Shl	Si, 1
;	Mov	Dx, rgIoDoorbell[Si]
	%Doorbell
)FI
	Xor	Ax, Ax
IRCExit:
	Pop	Bp
	Ret	0Eh
InitRemoteCdt	Endp


bSlot		Equ	Byte Ptr [Bp+06h]
AllocRemoteIccSegment Proc Far
	Push	Bp
	Mov	Bp, Sp
	Push	word ptr bSlot
	Call	InitSlotAddressTables
	Cmp	Ax, ercOk
	Je	ArisOk
	Cmp	Ax, ercOldOs
	Jne	ArisExit
ArisOk:
	Xor EAx, EAx
	Mov Cx, cIccAllocDelay
ArisLoop:
	Push	ES
	PushA
	Push 1
	Call Delay
	PopA
	Pop		ES
	Or  EAX, Es:qbIccSeg[Bx]
	Loopz ArisLoop
	Jz   ArisErc

	Push Es
	Push Bx
	Shr EAx, 4
	Push Ax
	Push 0F000h
	CALL StealAlignedSl
	Push Ax				; p for ReleaseP
	Push Ax				; p for PaFromP
	Push 0
	CALL PaFromP		; returned in dx,ax
	Pop Cx				;sn from stealslforos
	Pop Bx
	Pop Es

	Mov  Es:Word Ptr paIccSeg[Bx], Ax
	Mov  Es:Word Ptr paIccSeg[Bx+2], Dx
	Push Cx
	Push 0
	Push usernumos
	Call ReleaseP
	Xor Ax, Ax
ArisExit:
	Mov cIccAllocDelay, 50	; Subsequent processors need less delay
	Mov Sp, Bp
	Pop	Bp
	Ret	2

ArisErc:
	Mov Ax, ercNoSuchProcessor
	Jmp ArisExit
AllocRemoteIccSegment Endp

; ReadyRemoteBoot (bslot):dword
;	returns DX: ROM error codes
;	returns AX: mem size, boot command

bSlot		Equ	Byte Ptr [Bp+06h]

ReadyRemoteBoot	Proc	Far
	Push	Bp
	Mov	Bp, Sp
;BmicCmd:PROCEDURE(bSlot, iCmd, paMem, paEisa, qb) BYTE
	Push	WORD PTR bSlot
	Push	lComarchCmdGetConfig
	Push	0
	Push	0	; paMem ignored
	Push	WORD PTR paComarchConfig+2
	Push	WORD PTR paComarchConfig
	Push	0	; qbHi
	Push	sComarchConfig
	Call	BmicCmd
	Cmp		Al, lComarchCmdDone
	Mov		Ax, 0
	Jne		RrbRet

; Returns Dh = config error code, Dl = memory error code
;		  Ah = memory size in 128K blocks, Al=boot command

	Mov		EAx, comarchConfig_qbMemory
	Add		EAx, 1FFFFh	; round up to 128K multiple
	Shr		EAx, 9		; Shr 17, Shl 8 to put into Ah.
	Mov		Al, comarchConfig_BootType
	Mov		Dx, Word Ptr comarchConfig_memError
RrbRet:
	Pop	Bp
	Ret	2

ReadyRemoteBoot	Endp


BSlotLocal Proc Far
	TEST BYTE PTR vf_fComarch, 1
	JNZ  EisaSlot
	MOV  AX, 9
	RET
EisaSlot:
	Mov		Dx, lPortBmicSelect
	Mov		Al, iBmicbSlot
	Out		Dx, Al
	Mov		Dx, lPortBmicReg
	In		Al, Dx
	XOR  AH, AH
	Ret
BSlotLocal Endp


bSlot	Equ	SS : byte Ptr [Bp+6]

; Set Cdt lock semaphore.
; Also ES:DI set to pCdt.
LockSlotCdt PROC FAR	; (bSlot) POINTER PUBLIC;
	PUSH	BP
	MOV	BP, SP
	PUSH	[BP+6]
	CALL	GetCdtAddr	; returns ES:BX

; Lock the remote CDT, using exponential backoff if collision

	Mov	Al, 0FFh		; .7 Set => Lock it
	Mov	Di,1			; Initial collision wait flag
TryAgain:
	%PXchgb Al,Es:fLockByte[Bx]
	Or	Al,Al
	Jns	LockedIt		; If result is signed, try again
           
	INC	WORD PTR qCdtCollision
	ADC	WORD PTR qCdtCollision+2, 0
	Mov	Cx, Di
	Rol	Di, 1
Here:	Loop	Here
	Jmp	TryAgain

LockedIt:
	POP	BP
	RET 2
LockSlotCdt ENDP


; Fetch Cdt from Master Fp.
CdtLoad PROC FAR	; PUBLIC;
dir     EQU WORD PTR [BP-8]
 dirFetch EQU 0
 dirStore EQU 1
pRemote EQU DWORD PTR [BP-6]
cb      EQU WORD PTR  [BP-2]

	ENTER 6,0			 

; Find pRemote (our cdt copy on MasterFp).
	Test BYTE PTR vf_fComarch, 1
	JZ   CcbDone	; Local copy == master copy.

; Pc has paMpISlotPaCdt in low memory (pa 1F8h), points to table mpiSlotPaCdt 


	PUSH 9			; bSlotMaster
	CALL GetCdtAddr	; Inits pMpiSlotpCdt

	PUSH dirFetch
	JMP  Short CcbPCdt
CdtLoad ENDP

; Copy local Cdt to Master Fp so everybody can see our changes.
CdtCopyBack PROC FAR	; PUBLIC;
dir     EQU WORD PTR [BP-8]
dirStore EQU 1
pRemote EQU DWORD PTR [BP-6]
cb      EQU WORD PTR  [BP-2]
	ENTER 6,0
; Find pRemote (our cdt copy on MasterFp).
	Test BYTE PTR vf_fMasterFp, 1
	JNZ  CcbDone	; Local copy == master copy.
	PUSH dirStore
CcbPCdt:
; Pc has paMpISlotPaCdt in low memory (pa 1F8h), points to table mpiSlotPaCdt 
	Mov	Al, iMySlot
	Cbw
	Shl	Ax, 2
	Mov Si, Ax
	Les Bx, mpiSlotpCdt[Si]
	MOV Ax, Es
	Or	Ax, Ax
	Jnz	CcbCopy

	Les	Bx, pmpiSlotPaCdt
	Add	Bx, Si
	Push	Si
	%Peek EAX, Es:[Bx]
	%PRemoteAxBx
;	Ax:Bx is pCdt
	Pop	Si
	MOV mpiSlotpCdt[Si+2], Ax
	MOV mpiSlotpCdt[Si], Bx
CcbCopy:
	Mov	WORD PTR pRemote+2, Ax
	Mov	WORD PTR pRemote,   Bx

	MOV ECX, sCdt
	ROR ECX, 2
	OR  CX, CX
	JZ  CcbTail
	XOR EBX, EBX
CcbLoop:
	CMP dir,dirStore
	JE  CcbStore
; Fetch
	LES BX, pRemote
	%Peek	EAX, ES:[EBX-4][ECX*4]

	LES BX, pCdt
	MOV ES:[EBX-4][ECX*4], EAX
	JMP CcbNext
CcbStore:
	LES BX, pCdt
	MOV EAX, ES:[EBX-4][ECX*4]
	LES BX, pRemote
	%Poke	ES:[EBX-4][ECX*4], EAX
CcbNext:
;	Loop CcbLoop
	DEC CX
	JNZ CcbLoop

CcbTail:
	ROL ECX, 2
	OR  CX, CX
	JZ  CcbDone
CcbbLoop:
	CMP dir,dirStore
	JE  CcbbStore
; Fetch
	LES BX, pRemote
	%Peekb	EAX, ES:[EBX-1][ECX]
	LES BX, pCdt
	MOV ES:[EBX-1][ECX], AL
	JMP CccbNext
CcbbStore:
	LES BX, pCdt
	MOV AL, ES:[EBX-1][ECX]
	LES BX, pRemote
	%Pokeb	ES:[EBX-1][ECX], AL
CccbNext:
;	Loop CcbbLoop
	DEC CX
	JNZ  CcbbLoop
	
CcbDone:
	LEAVE
	RET
CdtCopyBack ENDP
) FI

Kernel Ends

END


;03/13/92 by JA, created from RemoteAddr_All.Asm for Bmic boards.
;03/24/92 by JA, PSet, PaMyIcc.
;04/28/92 by JA, CdtCopyBack
;06/09/92 by JA, CdtLoad, AllocRemoteIccSegment
;10/09/92 by sg, fix peek, poke ret values
;10/29/92 by sg  fix readyremoteboot qb
;10/30/92 by sg/ja fix initremotecdt, readyremoteboot slot references
;11/09/92 by JA, ArisLoop PUSH/POP ES
;12/17/92 by sg, fix peek proc to return dword in dx,ax; shl eax returned from 
;				lsl in paMyIcc
;12/21/92 by sg, fix parameters for pafromp, releasep
;12/22/92 by JA, StealAlignedSl; more DX,AX stuff
;1/11/93 by JA, CdtCopyBack Push/Pop Si
;1/27/93 by sg, fix ReadyRemoteBoot so returns boottype
;5/20/93 by JA, expunge mpiSlotExchRqWait. Delay less in icc seg alloc.
;06/02/93 by JM, import ralog,raLogIcc.
;6/3/93 by JA, rgIoDoornail.
;6/11/93 by JA, SuspendDma, UnsuspendDma EXTRN in KGroup.  Code seg is Kernel.
;7/19/93 by sg, Modify ReadyRemoteBoot to return error codes also.
;8/05/93 by sg, error codes were reversed in ROM; modify here so can check for 
;				memory error
