; ScInterface_All.Asm
;
;	Conditional modules:
;
;		ScInterface_P
;		ScInterface_Mf
;		ScInterface_MfP
;

%if(not %*isdef(%bsac)) then (%set(bsac,0))fi

;*********************************************************************
; Start Macro definitons
;*********************************************************************

%*define (InitOsSub) (
Data segment public 'data'
Data ends

OsSubSeg segment public 'data'
cpOsSubTable dw 0
osSubTable label dword
OsSubSeg ends
public cpOsSubTable, osSubTable

OssubORg_data segment word 'const'
rgoOssubDesc label word
OssubORg_data ends
public rgoOssubDesc

OssubRgbDesc_data segment byte 'const'
OssubRgbDesc_data ends

DGroup group Data, OssubORg_data, OssubRgbDesc_data, OsSubSeg

%set(iCount,0)
)

%*define (EndOsSub) (
OsSubSeg segment public 'data'
org offset cpOsSubTable 
dw %iCount
OsSubSeg ends
)

%*define (InterfaceFunction( iFunction, "FunctionName", "InternalName", "args")) local rgbDesc (%'
%IF (%iCount NE %eval(%iFunction)) THEN (%'
%Out(
!!! ERROR in %iFunction - %FunctionName !!!)) ELSE (%'
%set(iCount,%iCount+1)%'

%Out(%iFunction,)

%IF (NOT(%*Isdef(%Internalname))) THEN (
extrn %Internalname: far 
%define(tmpInternalName) (%Internalname)
) FI

OsSubSeg segment public 'data'
dd %Internalname
OsSubSeg ends

SS%EVAL(%iFunction/8)   SEGMENT AT (0FFFFh-(16*(%iFunction/8)))
        ORG     (230h+(100h*(%iFunction/8))+2*%iFunction-10h*(%iFunction/8))
sc_%FunctionName  EQU     THIS BYTE
        SS%EVAL(%iFunction/8)   ENDS
PUBLIC  sc_%FunctionName

%IF (%CtosP) THEN (
; %FunctionName
OssubORg_data segment word 'const'
%set(nPs,0)%'
%'
%set(i,%len(%args))%'
%while(%i GT 0)(%IF (%EQS(%substr(%args,%i,1),p)) THEN (%'
%set(nPs, %nPs+1)) FI%'
%set(i,%i-1))%'
%'
%IF (%nPs EQ 0) THEN (%'
	dw 0
) ELSE (%'
	dw offset DGroup:%rgbDesc
OssubRgbDesc_data segment byte 'const'
%rgbDesc label byte
%set(i,%len(%args))%'
%set(oParam,0)%'
%while(%i GT 0)(%'
%IF (%EQS(%substr(%args,%i,1),p)) THEN (%'
	db %eval(%oParam+6)
) FI%'
%set(oParam,%oParam+2)%'
%set(i,%i-1))%'
	db 0
OssubRgbDesc_data ends
) FI%'
OssubORg_data ends
) FI %'CtosP
) FI %'iCount ok
)
;*********************************************************************
; End Macro definitons
;*********************************************************************
;
; Define system common calls using the following macro:
; 	InterfaceFunction(iProc, ExternalName, InternalName, params)
; where
;	iProc - system common procedure number
;	ExternalName - procedure name known to clients
;	InternalName - procedure name in the OS which does the work
;   params - 'p-' pointer, 'w' word, '-' place holder (no action taken)
;
; The InterfaceFunction macro creates the following things:
;	- a public label for the cs:ip hack prefixes with sc_ (e.g. 
;		'sc_PutFrameChars'). Module OsSubset is obsolete.
;	- an entry in the kernel jump table (ossubtable)
;	- an entry in the parameter description tables.
;
;If the interface has no pointers, then use the null string.
;
;
;

%InitOsSub
%InterfaceFunction( 0, "QueryDefaultRespExch","ExchSync",	"p-")
%InterfaceFunction( 1, "QueryProcessNumber", "ProcCurrent",  "p-")
%InterfaceFunction( 2, "Log",                "LogUser",  "p-")
%InterfaceFunction( 3, "ULCMPB",             "UserULCMPB",  "p-p-w")
%InterfaceFunction( 4, "InitNetAgent",       "InitNetAgent",  "p-")
%InterfaceFunction( 5, "StringsEqual",       "StringsEqual",  "p-p-")
%InterfaceFunction( 6, "ResetStack",         "ResetStack",  "")
%InterfaceFunction( 7, "InitNetServer",      "InitNetServer",  "")
%InterfaceFunction( 8, "AssignKbd",          "AssignKbd",  "")
%InterfaceFunction( 9, "SetSwapDisable",     "SetSwapDisable",  "")
%InterfaceFunction(10, "ErrorExit",          "ErrorExit",  "")
%InterfaceFunction(11, "Exit",               "Exit",  "")
%InterfaceFunction(12, "TestPartitionFlags", "TestPartitionFlags",  "")

%IF (%CtosP) THEN (
%InterfaceFunction(13, "QuietForSwap",       "NotImplemented4Args",  "")
) ELSE (
%InterfaceFunction(13, "QuietForSwap",       "QuietForSwap",  "")
) FI

%InterfaceFunction(14, "Delay",              "Delay",  "")
%InterfaceFunction(15, "AssignVidOwner",     "AssignVidOwner",  "")
%InterfaceFunction(16, "Crash",              "Crash",  "")
%InterfaceFunction(17, "PosFrameCursor",     "NotImplemented6Args",  "")
%InterfaceFunction(18, "PutFrameAttrs",      "NotImplemented10Args",  "")

%IF (%CtosP) THEN (%'  GpKluge
%InterfaceFunction(19, "PutFrameChars",      "NotImplemented12Args",  "wwwp-w")
) ELSE (
%InterfaceFunction(19, "PutFrameChars",      "PutFrameChars",  "wwwp-w")
) FI

%InterfaceFunction(20, "QueryFrameChar",     "NotImplemented10Args",  "wwwp-")
%InterfaceFunction(21, "ResetFrame",         "NotImplemented2Args",    "")

%IF (%CtosP) THEN (%'  GpKluge
%InterfaceFunction(22, "ScrollFrame",        "NotImplemented10Args",    "")
) ELSE (
%InterfaceFunction(22, "ScrollFrame",        "ScrollFrame",    "")
) FI

%InterfaceFunction(23, "FillFrame",          "NotImplemented10Args",    "")
%InterfaceFunction(24, "FillFrameRectangle", "NotImplemented10Args",    "")
%InterfaceFunction(25, "BitBlt",             "NotImplemented8Args",    "")
%InterfaceFunction(26, "FrameBackSpace",     "NotImplemented14Args", "wp-p-p-")
%InterfaceFunction(27, "OpenByteStreamLp",   "OpenByteStreamLp","p-p-wp-wwp-w")
%InterfaceFunction(28, "FlushBufferLp",      "FlushBufferLp",    "p-p-wp-")
%InterfaceFunction(29, "CheckpointBsLp",     "CheckpointBsLp",    "p-w")
%InterfaceFunction(30, "GetUserNum",      	 "GetUserNum",    "p-")
%InterfaceFunction(31, "GetPAscb",           "GetPAscb",    "p-")
%InterfaceFunction(32, "PutAttr",            "NotImplemented14Args",    "")
%InterfaceFunction(33, "SynthesizeLine",     "NotImplemented12Args",    "")
%InterfaceFunction(34, "MapBsDevice",        "ReturnOk8Args",    "p-p-")
%InterfaceFunction(35, "InitSysByteStream",  "NotImplemented8Args",    "")
%InterfaceFunction(36, "CloseSysByteStream", "NotImplemented2Args",    "w")
%InterfaceFunction(37, "GetBsLfaSysBs",      "NotImplemented10Args", "p-p-w")
%InterfaceFunction(38, "SetBsLfaSysBs",      "NotImplemented10Args", "p-www")
%InterfaceFunction(39, "SetSysBs",           "SCUndefined",    "")
%InterfaceFunction(40, "DoWriteSysOut",      "NotImplemented6Args",   "p-w")
%InterfaceFunction(41, "DoReadSysIn",        "NotImplemented4Args",   "p-")
%InterfaceFunction(42, "ChkPtBsSysOut",      "NotImplemented6Args",   "p-w")
%InterfaceFunction(43, "ReleaseByteStreamLp","ReleaseByteStreamLp",   "p-")

%IF (%Mf) THEN (
%InterfaceFunction(44, "GetModuleID",        "NotImplemented8Args",   "wwp-")
) ELSE (
%InterfaceFunction(44, "GetModuleID",        "GetModuleID",    "wwp-")
) FI

%IF (%Srp) THEN (
%InterfaceFunction(45, "GetProcInfo", "GetProcInfo", "p-p-p-p-wp-")
%InterfaceFunction(46, "GetSlotInfo", "GetSlotInfo", "wp-wp-")
) ELSE (
%InterfaceFunction(45, "GetProcInfo",        "NotImplemented22Args",    "")
%InterfaceFunction(46, "GetSlotInfo",        "NotImplemented12Args",    "")
) FI

%InterfaceFunction(47, "GetPStructure",      "GetPStructure",    "wwp-")
%InterfaceFunction(48, "LockVideo",          "ReturnOK0Args",    "")
%InterfaceFunction(49, "UnLockVideo",        "ReturnOK0Args",    "")
%InterfaceFunction(50, "LockVideoForModify", "NotImplemented0Args",    "")
%InterfaceFunction(51, "UnLockVideoForModify","NotImplemented0Args",   "")
%InterfaceFunction(52, "SwapXBusEAR",        "SwapXBEAR",    "")
%InterfaceFunction(53, "SetScreenControl",   "NotImplemented24Args","p-wp-wp-wp-w")
%InterfaceFunction(54, "Blent",              "NotImplemented2Args","")
%InterfaceFunction(55, "ReadCommLineStatus", "ReadCommLineStatus_sc",   "wwp-")
%InterfaceFunction(56, "WriteCommLineStatus","WriteCommLineStatus_sc",  "www")
%InterfaceFunction(57, "GetpRgLineMap",		 "NotImplemented4Args","")
%InterfaceFunction(58, "dummy",				 "SCUndefined","")
%InterfaceFunction(59, "dummy",				 "SCUndefined","")
%InterfaceFunction(60, "dummy",				 "SCUndefined","")
%InterfaceFunction(61, "dummy",				 "SCUndefined","")
%InterfaceFunction(62, "dummy",				 "NotImplemented2Args","")
%InterfaceFunction(63, "dummy",				 "NotImplemented0Args","")
%InterfaceFunction(64, "dummy",				 "SCUndefined","")
%InterfaceFunction(65, "KbdNotify",			 "KbdNotify","")
%InterfaceFunction(66, "GetIBusData",    "NotImplemented20Args", "wp-p-p-p-w")
%InterfaceFunction(67, "ProcessInputEvent",  "NotImplemented26Args",       "")
%InterfaceFunction(68, "TerminateVidLock",   "NotImplemented2Args",        "")
; 10.0 VAM
%InterfaceFunction(69, "PutFrameCharsAndAttrs","NotImplemented18Args","wwwp-wp-w")
%InterfaceFunction(70, "QueryFrameCharsAndAttrs","NotImplemented18Args","wwwp-wp-w")
%InterfaceFunction(71, "QueryFrameBounds",  "NotImplemented10Args",   "wp-p-")
%InterfaceFunction(72, "QueryFrameCursor",  "NotImplemented10Args",   "wp-p-")
%InterfaceFunction(73, "MoveFrameRectangle","NotImplemented18Args",     "")

%IF (%CtosP) THEN (
%InterfaceFunction(74, "WakeUpSched",      "WakeUpSched",      "")
%InterfaceFunction(75, "ExitAndRemove",    "ExitAndRemove",      "")
%InterfaceFunction(76, "QueryModel",       "QueryModel",      "")
) ELSE (
%InterfaceFunction(74, "WakeUpSched",      "NotImplemented0Args",   "")
%InterfaceFunction(75, "ExitAndRemove",    "ExitAndRemove",      "")
%InterfaceFunction(76, "QueryModel",       "NotImplemented6Args",   "")
) FI

%InterfaceFunction(77, "QueryLoadAddress", "QueryLoadAddress",      "")
%InterfaceFunction(78, "SetPStructure",    "SetPStructure",      "wwwp-w")
;	11.0 Graphics interface
%InterfaceFunction(79, "VamStatus",        "NotImplemented0Args",  "")
%InterfaceFunction(80, "LockRasterRegion", "NotImplemented8Args",  "")
%InterfaceFunction(81, "UnLockRaster",     "NotImplemented0Args",  "")
%InterfaceFunction(82, "RasterOp",         "NotImplemented32Args", "p-wwp-wwp-wwwwp-")
%InterfaceFunction(83, "DoRasterText",     "NotImplemented14Args", "p-wwwp-")
%InterfaceFunction(84, "ScrollRasterLines","NotImplemented10Args","")
%InterfaceFunction(85, "DefineCursor",    "NotImplemented22Args", "p-p-p-wwwww")
%InterfaceFunction(86, "SetCursor",       "NotImplemented6Args",  "p-w")
%InterfaceFunction(87, "PosCursor",       "NotImplemented8Args",  "p-ww")
%InterfaceFunction(88, "RemoveCursor",    "NotImplemented4Args",  "p-")
%InterfaceFunction(89, "SetCursorBlinking","NotImplemented10Args","p-www")
%InterfaceFunction(90, "HandleCursorIrpt","NotImplemented10Args", "p-www")
%InterfaceFunction(91, "ChangeCursor",    "NotImplemented8Args",  "p-p-")
%InterfaceFunction(92, "SetCursorPriority","NotImplemented6Args", "p-w")
%InterfaceFunction(93, "SetCursorColor",  "NotImplemented8Args",  "p-ww")
%InterfaceFunction(94, "QueryCursorPosition","NotImplemented12Args", "p-p-p-")
%InterfaceFunction(95, "Draw",            "NotImplemented14Args", "wwwwwp-")
%InterfaceFunction(96, "GetContiguousBm", "NotImplemented8Args",  "p-p-")
%InterfaceFunction(97, "BuildRasterText", "NotImplemented22Args", "p-wp-wwwwp-")
%InterfaceFunction(98, "RasterOpText",    "NotImplemented22Args", "p-wp-wwwwwww")
; End graphics

%InterfaceFunction(99, "InstallSystemCommon",  "SCUndefined",  "")

%IF (%CtosP) THEN (
%InterfaceFunction(100, "SaFromSn",        "SaFromSn",      "wwp-")
%InterfaceFunction(101, "PaFromSn",        "PaFromSn",      "wwp-")
%InterfaceFunction(102, "DefineInterlevelStack","DefineInterlevelStack", "")
%InterfaceFunction(103, "ReuseAlias",      "ReuseAlias",      "")
%InterfaceFunction(104, "GetFRmosUser",    "GetFRmosUser",      "wp-")
%InterfaceFunction(105, "ServiceOverlayC", "ServiceOverlayC",      "")
%InterfaceFunction(106, "PassThroughIO",   "PassThroughIO",      "")
) ELSE (
%InterfaceFunction(100, "SaFromSn",        "NotImplemented8Args",      "wwp-")
%InterfaceFunction(101, "PaFromSn",        "NotImplemented8Args",      "wwp-")
%InterfaceFunction(102, "DefineInterlevelStack","NotImplemented6Args", "")
%InterfaceFunction(103, "ReuseAlias",      "NotImplemented6Args",      "")
%InterfaceFunction(104, "GetFRmosUser",    "NotImplemented6Args",      "wp-")
%InterfaceFunction(105, "ServiceOverlayC", "NotImplemented0Args",      "")
%InterfaceFunction(106, "PassThroughIO",   "NotImplemented6Args",      "")
) FI

%InterfaceFunction(107, "FSCanon",         "FSCanon",      "p-w")
%InterfaceFunction(108, "Gfx_ConvertWords","NotImplemented12Args",   "p-p-ww")

%IF (%CtosP) THEN (
%InterfaceFunction(109, "SnFromSr",        "SnFromSr",      "wp-")
) ELSE (
%InterfaceFunction(109, "SnFromSr",        "NotImplemented6Args",    "wp-")
) FI

;	Internal routines needed by the file system 
;***** CAUTION: The following have not had their parameters assigned
%InterfaceFunction(110, "Log",        "Log",           "")

%InterfaceFunction(111, "DisplayInfoOnLeds",   "DisplayInfoOnLeds",     "ww")
%InterfaceFunction(112, "InPlm",      "InPlm",           "")
%InterfaceFunction(113, "OutPlm",     "OutPlm",           "")
%InterfaceFunction(114, "InputPlm",   "InputPlm",           "")
%InterfaceFunction(115, "OutputPlm",  "OutputPlm",           "")
%InterfaceFunction(116, "ULCMPB",     "ULCMPB",           "")
%InterfaceFunction(117, "AllocPSub",  "AllocPSub",           "")
%InterfaceFunction(118, "ReleasePSub","ReleasePSub",           "")
%InterfaceFunction(119, "PaFromP",    "PaFromP",           "")
;	Debugger uses secret bit-mapped video routines
%InterfaceFunction(120, "DbgPutChars","NotImplemented10Args",          "")
%InterfaceFunction(121, "DbgScroll","NotImplemented0Args",           "")
%InterfaceFunction(122, "DbgSwitch","NotImplemented8Args",           "")
%InterfaceFunction(123, "FloppyInterruptSubr","NotImplemented0Args",       "")
%InterfaceFunction(124, "NotifyRgVidMemLineUser","NotImplemented2Args",  "")
;************************************************************

%IF (%CtosP) THEN (
%InterfaceFunction(125, "BuildLdtSlot",    "BuildLdtSlot",      "")
%InterfaceFunction(126, "ReUseAliasLarge", "ReUseAliasLarge",      "")
%InterfaceFunction(127, "MapSgUserNum",    "NotImplemented8Args",   "")
%InterfaceFunction(128, "FSrpUpProc",      "NotImplemented0Args", "")
%InterfaceFunction(129, "SystemCommonInstall", "SystemCommonInstall", "wp-p-wwp-w")
%InterfaceFunction(130, "SystemCommonQuery","SystemCommonQuery",   "wp-w")
%InterfaceFunction(131, "EnterBootrom",     "EnterBootrom",   "")
%InterfaceFunction(132, "QueryLdtr",        "QueryLdtr",   "wp-")
%InterfaceFunction(133, "CallRealCommIsr",  "CallRealCommIsr",   "")
%InterfaceFunction(134, "SetLdtrDs",        "SetLdtrDs",   "")
%InterfaceFunction(135, "NotifyMultiProcessSwap","NotifyMultiProcessSwap", "")
) ELSE (
%InterfaceFunction(125, "BuildLdtSlot",    "NotImplemented10Args",      "")
%InterfaceFunction(126, "ReUseAliasLarge", "NotImplemented10Args",      "")
%InterfaceFunction(127, "MapSgUserNum",    "NotImplemented8Args",   "")
%InterfaceFunction(128, "FSrpUpProc",      "NotImplemented0Args", "")
%InterfaceFunction(129, "SystemCommonInstall", "SystemCommonInstall", "wp-p-wwp-w")
%InterfaceFunction(130, "SystemCommonQuery","SystemCommonQuery",   "wp-w")
%InterfaceFunction(131, "EnterBootrom",    "NotImplemented6Args",    "")
%InterfaceFunction(132, "QueryLdtr",       "NotImplemented6Args",    "wp-")
%InterfaceFunction(133, "CallRealCommIsr", "NotImplemented0Args",    "")
%InterfaceFunction(134, "SetLdtrDs",       "NotImplemented4Args",    "")
%InterfaceFunction(135, "NotifyMultiProcessSwap","NotImplemented0Args", "")
) FI

%InterfaceFunction(136, "GetDAINumber", "NotImplemented8Args", "p-p-")

%InterfaceFunction(137, "SetUpLpIsr",   "SetUpLpIsr", "p-")
%InterfaceFunction(138, "QueryCoprocessor",  "QueryCoprocessor",  "p-")
%InterfaceFunction(139, "WriteIBusEvent", 	"WriteIBusEvent",	"p-w")

%IF (%CtosP) THEN (
%InterfaceFunction(140, "FillBufferLp",       "FillBufferLp","p-wp-p-")
%InterfaceFunction(141, "GetCommLineDmaStatus", "GetCommLineDmaStatus", "wp-w")
%InterfaceFunction(142, "ReceiveCommLineDma", "ReceiveCommLineDma", "wp-wp-")
%InterfaceFunction(143, "TransmitCommLineDma","TransmitCommLineDma", "wp-w")
) ELSE (
%InterfaceFunction(140, "FillBufferLp",       "NotImplemented14Args","p-wp-p-")
%InterfaceFunction(141, "GetCommLineStatus",  "NotImplemented8Args","wp-w")
%InterfaceFunction(142, "ReceiveCommLineDma", "NotImplemented12Args","wp-wp-")
%InterfaceFunction(143, "TransmitCommLineDma","NotImplemented8Args", "wp-w")
) FI

%InterfaceFunction(144, "GetLocalDAINumber",  "GetLocalDAINumber","p-")

%IF (%Mf) THEN (
%InterfaceFunction(145, "WriteIBusDevice",    "NotImplemented8Args","wp-w")
) ELSE (
%InterfaceFunction(145, "WriteIBusDevice", 	  "WriteIBusDevice",	"wp-w")
) FI

%InterfaceFunction(146, "SwapDebuggerVideo","NotImplemented8Args",        "")
%InterfaceFunction(147, "DbgPosCursor","NotImplemented4Args",        "")

%IF (%CtosP) THEN (
%InterfaceFunction(148, "CacheInit",         "CacheInit",         "p-wwp-wwp-")
%InterfaceFunction(149, "CacheGetEntry",     "CacheGetEntry",     "wwp-wp-p-")
%InterfaceFunction(150, "CacheReleaseEntry", "CacheReleaseEntry", "wwwwww")
%InterfaceFunction(151, "CacheGetStatus",    "CacheGetStatus",    "wwp-p-")
%InterfaceFunction(152, "CacheFlush",        "CacheFlush",        "wwp-p-wwp-")
%InterfaceFunction(153, "CacheClose",        "CacheClose",        "ww")
) ELSE (
%InterfaceFunction(148, "CacheInit",         "NotImplemented20Args", "")
%InterfaceFunction(149, "CacheGetEntry",     "NotImplemented18Args", "")
%InterfaceFunction(150, "CacheReleaseEntry", "NotImplemented12Args",  "")
%InterfaceFunction(151, "CacheGetStatus",    "NotImplemented12Args",  "")
%InterfaceFunction(152, "CacheFlush",        "NotImplemented20Args", "")
%InterfaceFunction(153, "CacheClose",        "NotImplemented4Args",  "")
)FI
%InterfaceFunction(154, "StealAlignedSL", 	"StealAlignedSL", "ww")
%InterfaceFunction(155, "MapBusAddress", 	"MapBusAddress", "p-wwp-p-")
%InterfaceFunction(156, "UnmapBusAddress",  "UnmapBusAddress", "ww")
%InterfaceFunction(157, "QueryUserLocation","QueryUserLocation", "wp-w")
%InterfaceFunction(158, "UpdateFsDeviceName", "NotImplemented4Args", "p-")

%IF (%CtosP) THEN (
%InterfaceFunction(159, "LockInContext", "LockInContext", "w")
%InterfaceFunction(160, "UnLockInContext", "UnLockInContext", "w")
%InterfaceFunction(161, "DirtyCode", "DirtyCode", "p-")
) ELSE (
%InterfaceFunction(159, "LockInContext", "NotImplemented2Args", "")
%InterfaceFunction(160, "UnLockInContext", "NotImplemented2Args", "")
%InterfaceFunction(161, "DirtyCode", "NotImplemented4Args", "")
) FI

%IF (%Srp) THEN (
%InterfaceFunction(162, "GetSlotFromName", "GetSlotFromName", "p-wp-")
) ELSE (
%InterfaceFunction(162, "GetSlotFromName", "NotImplemented10Args", "")
) FI

%IF (%CtosP) THEN (
%InterfaceFunction(163, "CacheGetStatistics", "CacheGetStatistics", "wwp-")
) ELSE (
%InterfaceFunction(163, "CacheGetStatistics", "NotImplemented8Args", "")
)FI

%IF (%CtosP) THEN (
%InterfaceFunction(164, "DmaTransfer", "DmaTransfer", "w")
) ELSE (
%InterfaceFunction(164, "DmaTransfer", "NotImplemented2Args", "")
)FI

%if (%bsac) then (
%InterfaceFunction(165, "CallACS", "NotImplementedBSAC", "p-ww")
) else (
%InterfaceFunction(165, "CallACS", "NotImplemented8Args", "")
)fi

%IF (%CtosP) THEN (
%InterfaceFunction(166, "DmaTransferForMassIo", "DmaTransferForMassIo", "w")
) ELSE (
%InterfaceFunction(166, "DmaTransferForMassIo", "NotImplemented2Args", "")
)FI

%IF (%Mf) THEN (
%InterfaceFunction(167, "AllocMemDisk", "AllocMemDisk", "p-w")
) ELSE (
%InterfaceFunction(167, "AllocMemDisk", "NotImplemented6Args", "")
) FI

%InterfaceFunction(168, "CRAQOSNamePlace", "CRAQOSNamePlace", "p-p-p-")
%InterfaceFunction(169, "Doze", "Doze", "w")

%IF (%CtosP) THEN (
%InterfaceFunction(170, "CheckUserActive", "CheckUserActive", "w")
) ELSE (
%InterfaceFunction(170, "CheckUserActive", "NotImplemented2Args", "")
) FI

%InterfaceFunction(171, "ReadDbgTerm", "ReadDbgTerm", "p-")
%InterfaceFunction(172, "WriteDbgTerm", "WriteDbgTerm", "w")

%IF ((%Mf) AND (%CtosP)) THEN(
%InterfaceFunction(173, "RemapBusAddress", "RemapBusAddress", "wwp-wwp-p-")
%InterfaceFunction(174, "ReserveBusAddress", "ReserveBusAddress", "wp-")
) ELSE (
%InterfaceFunction(173, "RemapBusAddress", "NotImplemented20Args", "")
%InterfaceFunction(174, "ReserveBusAddress", "NotImplemented6Args", "")
) FI


%IF (%CtosV) THEN (
%InterfaceFunction(175, "SemClear", "SemClear", "p-")
%InterfaceFunction(176, "SemLock", "SemLock", "p-w")
%InterfaceFunction(177, "SemMuxWait", "SemMuxWait", "p-p-w")
%InterfaceFunction(178, "SemNotify", "SemNotify", "p-ww")
%InterfaceFunction(179, "SemSet", "SemSet", "p-")
%InterfaceFunction(180, "SemWait", "SemWait", "p-w")
%InterfaceFunction(181, "SemClearProcessLocks", "SemClearProcessLocks", "w")
%InterfaceFunction(182, "SemEnumerate", "SemEnumerate", "wwp-")
%InterfaceFunction(183, "SemEnumerateWaiting", "SemEnumerateWaiting", "p-wp-w")
%InterfaceFunction(184, "SemQuery", "SemQuery", "p-p-wp-w")
%InterfaceFunction(185, "SemQueryProcessLock", "SemQueryProcessLock", "wwp-")
) ELSE (
%InterfaceFunction(175, "SemClear", "NotImplemented4Args", "")
%InterfaceFunction(176, "SemLock", "NotImplemented6Args", "")
%InterfaceFunction(177, "SemMuxWait", "NotImplemented10Args", "")
%InterfaceFunction(178, "SemNotify", "NotImplemented8Args", "")
%InterfaceFunction(179, "SemSet", "NotImplemented4Args", "")
%InterfaceFunction(180, "SemWait", "NotImplemented6Args", "")
%InterfaceFunction(181, "SemClearProcessLocks", "NotImplemented2Args", "")
%InterfaceFunction(182, "SemEnumerate", "NotImplemented8Args", "")
%InterfaceFunction(183, "SemEnumerateWaiting", "NotImplemented12Args", "")
%InterfaceFunction(184, "SemQuery", "NotImplemented16Args", "")
%InterfaceFunction(185, "SemQueryProcessLock", "NotImplemented8Args", "")
) FI
%InterfaceFunction(186, "ErrorExitUser", "ErrorExitUser", "wwww")
%IF (%CtosP) THEN (
%InterfaceFunction(187, "QuerySnInfo", "QuerySnInfo", "wp-w")
) ELSE (
%InterfaceFunction(187, "QuerySnInfo", "NotImplemented8Args", "")
) FI
%InterfaceFunction(188, "UnlockPages", "NotImplemented10Args", "wwwww")
%InterfaceFunction(189, "LockRqPages", "NotImplemented4Args", "p-")
%InterfaceFunction(190, "UnLockRqPages", "NotImplemented4Args", "p-")
%InterfaceFunction(191, "UnMapPages", "NotImplemented8Args", "wwww")
%InterfaceFunction(192, "DiscardLocalPageMap", "NotImplemented2Args", "w")
%IF (%CtosV) THEN (
%InterfaceFunction(193, "FixupPage", "FixupPage", "wwww")
%InterfaceFunction(194, "EnablePagingService", "EnablePagingService", "wp-")
%InterfaceFunction(195, "VBootstrap", "VBootstrap", "p-www")
) ELSE (
%InterfaceFunction(193, "FixupPage", "NotImplemented8Args", "")
%InterfaceFunction(194, "EnablePagingService", "NotImplemented6Args", "")
%InterfaceFunction(195, "VBootstrap", "NotImplemented10Args", "")
) FI
%IF (%CtosP) THEN (
%InterfaceFunction(196, "XlateChar", "XlateChar", "wp-p-p-p-wwp-p-w")
%InterfaceFunction(197, "SetUpOkeys", "SetUpOkeys", "wwwp-p-p-p-p-p-")
%InterfaceFunction(198, "ProcessKeys", "ProcessKeys", "wwp-wp-p-p-p-")
%InterfaceFunction(199, "AsiaNub", "AsiaNub", "wp-p-p-p-")
%InterfaceFunction(200, "CodeIkbd", "CodeIkbd", "p-")
) ELSE (
%InterfaceFunction(196, "XlateChar", "NotImplemented32Args", "")
%InterfaceFunction(197, "SetUpOkeys", "NotImplemented30Args", "")
%InterfaceFunction(198, "ProcessKeys", "NotImplemented26Args", "")
%InterfaceFunction(199, "AsiaNub", "NotImplemented18Args", "")
%InterfaceFunction(200, "CodeIkbd", "NotImplemented6Args", "")
) FI

%InterfaceFunction(201, "GetDmaBuffer", "GetDmaBuffer", "wp-p-")
%IF (%Srp) THEN (
%InterfaceFunction(202, "FMasterRqSentTestAndClear", "FMasterRqSentTestAndClear", "")
) ELSE (
%InterfaceFunction(202, "FMasterRqSentTestAndClear", "NotImplemented2Args", "")
) FI

%IF (%CtosP) THEN (
%InterfaceFunction(203, "MapDmaBufferFast", "MapDmaBufferFast", "wwwwwwp-p-ww")
%InterfaceFunction(204, "UnmapDmaBuffer", "UnmapDmaBuffer", "wwwwwwww")
) ELSE (
%InterfaceFunction(203, "MapDmaBufferFast", "NotImplemented24Args", "")
%InterfaceFunction(204, "UnmapDmaBuffer", "NotImplemented16Args", "")
) FI

%InterfaceFunction(205, "BuildGdtSlot", "BuildGdtSlot", "wwwww")

%IF (%CtosP) THEN (
%InterfaceFunction(206, "ExtractRunFileMode", "ExtractRunFileMode", "p-p-")
%InterfaceFunction(207, "SetEnvironment", "SetEnvironment", "ww")
) ELSE (
%InterfaceFunction(206, "ExtractRunFileMode", "NotImplemented8Args", "")
%InterfaceFunction(207, "SetEnvironment", "NotImplemented4Args", "")
) FI

%IF (%CtosP) THEN (
%InterfaceFunction(208, "UpdateStatistics", "NotImplemented12Args", "wp-p-w")
) ELSE (
%InterfaceFunction(208, "UpdateStatistics", "NotImplemented12Args", "")
) FI

%IF (%CtosP) THEN (
%InterfaceFunction(209, "AltMapDmaBufferFast", "AltMapDmaBufferFast", "wwwwwwwp-p-ww")
%InterfaceFunction(210, "AltUnmapDmaBuffer", "AltUnmapDmaBuffer", "wwwwwwwww")
) ELSE (
%InterfaceFunction(209, "AltMapDmaBufferFast", "NotImplemented26Args", "")
%InterfaceFunction(210, "AltUnmapDmaBuffer", "NotImplemented18Args", "")
) FI

%IF (%CtosP) THEN (
%InterfaceFunction(211, "MapXBusDma", "MapXBusDma", "wp-p-")
%InterfaceFunction(212, "UnmapXBusDma", "UnmapXBusDma", "wwwww")
) ELSE (
%InterfaceFunction(211, "MapXBusDma", "NotImplemented10Args", "")
%InterfaceFunction(212, "UnmapXBusDma", "NotImplemented10Args", "")
) FI

%InterfaceFunction(213, "LockPbCb", "ReturnOk6Args", "p-w")
%InterfaceFunction(214, "UnlockPbCb", "ReturnOk6Args", "p-w")

%IF (%CtosP) THEN (
%InterfaceFunction(215, "ResizeIoMap", "ResizeIoMap", "wp-")
) ELSE (
%InterfaceFunction(215, "ResizeIoMap", "NotImplemented6Args", "")
) FI

%IF (%CtosP AND NOT %Mf) THEN (
%InterfaceFunction(216, "GetModuleAddress", "GetModuleAddress",    "wwp-")
) ELSE (
%InterfaceFunction(216, "GetModuleAddress", "NotImplemented8Args",   "wwp-")
) FI

%IF (%MF) THEN (
%InterfaceFunction(217, "ReadNvAreaSC", "NotImplemented12Args", "")
%InterfaceFunction(218, "WriteNvAreaSC", "NotImplemented12Args", "")
%InterfaceFunction(219, "ReadNvDirect", "NotImplemented8Args", "")
%InterfaceFunction(220, "WriteNvDirect", "NotImplemented8Args", "")
) ELSE (
%InterfaceFunction(217, "ReadNvAreaSC", "NotImplemented12Args", "")
%InterfaceFunction(218, "WriteNvAreaSC", "NotImplemented12Args", "")
%InterfaceFunction(219, "ReadNvDirect", "NotImplemented8Args", "")
%InterfaceFunction(220, "WriteNvDirect", "NotImplemented8Args", "")
) FI

%IF (%CtosP) THEN (
%InterfaceFunction(221, "UpdateChordState", "UpdateChordState", "wwp-p-p-w")
) ELSE (
%InterfaceFunction(221, "UpdateChordState", "NotImplemented18Args", "")
) FI

%InterfaceFunction(222, "ConnectAgentCache", "NotImplemented2Args", "w")
%InterfaceFunction(223, "DebuggerEntry", "NotImplemented6Args", "wp-")

%IF (%CtosP) THEN (
%InterfaceFunction(224, "SetVideoLocators", "SetVideoLocators", "wwwww")
) ELSE (
%InterfaceFunction(224, "SetVideoLocators", "NotImplemented10Args", "")
) FI

%IF (%ctosp) THEN (
%InterfaceFunction(225, "GetClstrGenerationNumber",
										"NotImplemented4Args", "p-")
) FI
%IF (%ctosv) THEN (
%InterfaceFunction(226, "CallBIOS",	"CallBIOS", "w")
)ELSE(
%InterfaceFunction(226, "CallBIOS",	"NotImplemented2Args", "")
) FI

%IF (%ctosv) THEN (
%InterfaceFunction(227, "WFetchTid",	"WFetchTid", "")
)ELSE(
%InterfaceFunction(227, "WFetchTid",	"NotImplemented0Args", "")
) FI

%InterfaceFunction(228, "SetPagingParameters",	"NotImplemented8Args", "")
%InterfaceFunction(229, "QueryPagingStatistics","NotImplemented12Args", "")
%InterfaceFunction(230, "UserNumFromGla","SCUserNumFromGla", "")
%IF (%Ctosv) THEN (
%InterfaceFunction(231, "CheckHotKeys", "CheckHotKeys", "wp-p-p-")
)ELSE(
%InterfaceFunction(231, "CheckHotKeys", "NotImplemented14Args", "")
) FI
%IF (%Mf) THEN (
%InterfaceFunction(232, "SetModuleId", "NotImplemented8Args", "wwww")
) ELSE (
%InterfaceFunction(232, "SetModuleId", "SetModuleId", "wwww")
) FI
; QueryPsInternal is internal use only, do not document.
%InterfaceFunction(233, "QueryPsInternal", "NotImplemented16Args", "wwwp-wp-")
; SetClusterParams is for internal use only, do not document.
%InterfaceFunction(234, "SetClusterParams", "NotImplemented4Args", "p-")
%InterfaceFunction(235, "WriteBatteryClock", "WriteBatteryClock", "p-")
%InterfaceFunction(236, "ExpandDateTime", "ExpandDateTime", "p-")
%InterfaceFunction(237, "dummy",          "ScUndefined", "")
%InterfaceFunction(238, "dummy",          "ScUndefined", "")
;*AA*
%InterfaceFunction(239, "ReadStatusP", "ReadStatusP", "pwp")
%InterfaceFunction(240, "Dwell", "Dwell", "w")
%IF (%Srp) THEN (
%InterfaceFunction(241, "DoorbellSetHandler", "DoorbellSetHandler", "wp-")
%InterfaceFunction(242, "DoorbellRing", "DoorbellRing", "ww")
)ELSE(
%InterfaceFunction(241, "DoorbellSetHandler", "NotImplemented6args", "wp-")
%InterfaceFunction(242, "DoorbellRing", "NotImplemented4Args", "ww")
)FI
%InterfaceFunction(243, "KernelAliasRqSpec", "ReturnOk10Args", "wwwp-")

;WARNING:
;	256-292 reserved for Bull
;   293-29C reserved for Asianization (Paul Deuter)
;	512-610 reserved for Bull
;	7FC-7FF reserved for Handok
;	7FB		reserved for Flemington

%EndOsSub

end

; Change log
;
; 2/18/87  Added x feature
; 3/17/87  by MS  ADD a new System common Procedure GetDAINumber
; 3/26/87  by MDE Add SetUpLpIsr System Common Procedure
; 10/5/87  by TAB Added FillBufferLp
; 11/4/87  by TAB Added GetCommLineDmaStatus, ReceiveCommLineDma, 
;                 TransmitCommLineDma
; 12/15/87 by TAB Fixed WriteCommLineStatus parameter list
;---2.3----
; 02/10/88 by JM  merge osSubTable from kernel,
;				  expand macro to produce osSubTable entry and 'sc_' label.
; 02/16/88 by JA  Diddle some names to match os calls.
; 03/1/88  by JA  Make Mp version have no tCode.  SetpStructure in Mp.
;                 24 62 63 99 need work
; 04/27/88 by JM  SwapDebuggerVideo, DbgPosCursor.
; 05/25/88 by SAR Cacher Primitives
; 05/31/88 by PGJ StealAlignedSL
; 07/06/88 by JM  SRP handles debugger video calls.
; 07/13/88 by PGJ MapBusAddress and UnmapBusAddress for SRP 386
; 09/07/88 by JM  fix PutFrameChars parameter description.
; 09/14/88 by JM  SRP returns ercNotImplemented for debugger video.
; 09/29/88 by AT  QueryUserLocation.
; 10/17/88 by PGJ UpdateFsDeviceName (Init configuration parser to file system)
; 10/25/88 by MTR [Un]LockInContext.
; 11/07/88 by WRF DirtyCode for debugger
; 01/10/89 by RLM change all cache calls to start with Cache
; 01/25/89 by AT, GetSlotFromName.
; 01/30/89 by JA, QueryUserLocation has cbMax arg.
; 02/04/89 by MTR CacheGetStatistics, add parms to Cache*
; 03/07/89 by PGJ MapBusAddress/UnmapBusAddress in all CTOS, not just pSrpGp
; 03/17/89 by JA/RLM Whiners get GetSlotInfo, GetProcInfo, Lpt stuff.
; 03/23/89 by MTR CacheFlush changes.
; 03/24/89 by PGJ DmaTransfer so MassIo can move to and from cache.
; 04/05/89 by MTR Add CacheGetEntry flags
; 04/14/89 by JA, 165 BSACReserved.
; 05/22/89 by AT, QueryCoprocessor for 186 SRP boards.
; 07/31/89 by JM, reserve slots for Handok & Flemington
; 08/15/89 by MBS add AllocMemDisk (167) for use by memory disk driver
; 08/18/89 by MTR Reserve #s 168 & 169
; 08/18/89 by WRF CRAQOsNamePlace, 168
; 08/18/89 by WRF fix bug in reservation for CRAQOsNamePlace, 168 "ww" .NE. "p-"
; 09/19/89 by SAR Reserve #170 (for Camarillo)
; 09/19/89 by MTR Doze really does now
; 09/21/89 by JMR added Read&Write debugger terminal for comm independant dbgr.
; 09/23/89 by MTR {Read|Write}DbgTerm = NotImplemented for WS.  N.B. an
;				  InterfaceFunction that maps to NotImplemented needs no TCode
; 10/06/89 by MTR #165 now CallACS (==NotImplemented8Args) to match Ctos.Lib
; 10/31/89 by PGJ Add RemapBusAddress and ReserveBusAddress
; 01/05/90 by JM add QuerySgInfo
; 1/8/90 by   JWF add Semaphore procedures and ErrorExitUser for paging
; 1/23/90 by  JWF add 188-193 for Paging Service, DR make FixupPages
;                 conditional.
; 2/14/90 by  JWF put ErrorExitUser in internal name field 
; 2/15/90 by  DR  EnablePagingService
; 3/02/90 by  DR  VBootstrap
; 01/11/90 by KH  Added 196-200 for new keyboard 
; 03/15/90 by MTR Added #201 for File System
; 03/24/90 by JA  Add 202 FMasterRqSentTestAndClear.
; 03/29/90 by JC  Added Bsac support
; 04/12/90 by DR  Deleted UserNumFromGla (203) - now a request
; 04/18/90 by JM  obsolete MapSgUSerNum; change QuerySgInfo to QuerySnInfo.
; 04/24/90 by MTR New kbd calls not implemented in Mf
; 06/06/90 by PKD New loader system common calls
; 06/21/90 by MTR Reserve #208 for Camarillo's statistics server
; 07/05/90 by JC  Added Statistics Server call
; 07/27/90 by DR  #215 ResizeIoMap; Removed redundant OR CTOSV tests
; 09/06/90 by AT  Added (Un)MapXBusDma.
; 10/01/90 by JMR GetProcInfo and GetSlotInfo for RKVS Workstation.
; 09/28/90 by AT  Added GetModuleAddress for FileSystem.
; 10/30/90 by JC  Added Nvram Service calls
; 10/31/90 by MTR Undo 10/01/90 change
; 11/06/90 by JM  change GetpRgLineMap from ScUndefined to not implemented,
;				  means OS won't kill itself if GetpRgLineMap not installed.
; 11/11/90 by KH  UpdateChordState for keyboardprocess
; 11/18/90 by KH  Changes to CodeIkbd 
; 11/26/90 by JC  Changed Nvram calls to not implemented
; 11/29/90 by MTR Unconditional DisplayInfoOnLeds
; 12/17/90 by JA  Added ConnectAgentCache (222)
; 01/07/91 by JA  ConnectAgentCache(w)
; 01/07/91 by JM  add DebuggerEntry.
; 01/23/91 by DR  SetVideoLocators
; 02/03/92 by JF SetPagingParameters and QueryPagingStatistics
; 02/27/92 by JM  enable CheckUserActive on ctosv
; 03/08/92 by KH  Add Laptop Power management 'CheckHotkeys' call for Laptop 
;				  Power management (231)
; 03/27/92 by DR  SetModuleId
; 06/23/92 by JM  QueryPsInternal.
; 08/23/92 by FW  Add SetClusterParams.
; 10/20/92 by JF  WriteBatteryClock and ExpandDateTime
; 11/06/92 by KK  GetEisaBusInfo
; 01/21/93 by RA, ReadStatusP.
; 01/19/93 by JA  ReleaseFileCacheEntry (238)
; 02/23/93 by sg  undo ReleaseFileCacheEntry (238)
; 03/13/93 by JM  ReadDbgTerm, WriteDbgTerm.
; 05/04/93 by KK  undo GetEisaBusInfo (237).
; 05/14/93 by JA  ReturnOk6Args for Un/LockPbCb for OpenRtClock.
; 07/06/93 by JA  KernelAliasRqSpec(243)
