; FILE: EBifISR.asm
;
;
;   10 Nov 92: KK,  created
;
;
DATA   SEGMENT PUBLIC 'DATA'

    EXTRN pEBifIsrTable: DWORD

    sEBifIsr DW 12
    iEBifISR DW  0

	pProcISR DD  0
	dsISR    DW  0
	ldtrISR  DW  0

DATA   ENDS
DGROUP GROUP DATA

EXTRN SetLdtrDS:far

EBifDisp SEGMENT public 'CODE'

PUBLIC EBifISR
PUBLIC EBifDummyISR

EBifISR PROC FAR

ASSUME CS: EBifDisp
ASSUME ES: nothing
ASSUME DS: DGROUP

    jmp  DoEBifIsrLoop

EBifIsrRet:
    ret

DoEBifIsrLoop:
ASSUME DS:DGROUP, ES:NOTHING
    mov  cx, 8          ; There are currently 8 entries in the ISR table.
                        ; If you change this value you must:
                        ;    1) Modify nEBifIsr in CtosGlobal.edf
                        ;    2) Compile InitOSSubs_V.plm
                        ;    3) Compile EBifService.plm
                        ;
EBifIsrLoop:
    push cx

    mov  ax, iEBifIsr
    inc  ax
    and  ax, 0Fh
    mov  iEBifIsr, ax

    call CallEBifIsr
    pop  cx

    rcr  al, 1
    jc   EBifIsrRet
    loop EBifIsrLoop

    jmp short EBifIsrRet

CallEBifIsr PROC NEAR
;
; on entry, ax is iRgEBifIsr
; on exit,  ax is status
;
rgPProcRa  EQU ES: dword ptr [si+4]
rgPProcSa  EQU ES: dword ptr [si+6]
rgDsISR    EQU ES: word  ptr [si+8]
rgLdtrISR  EQU ES: word  ptr [si+10]
pProcRa    EQU word ptr pProcISR
pProcSa    EQU word ptr pProcISR[2]

ASSUME DS: DGROUP

    les  bx, pEBifIsrTable
    mov  dx, sEBifIsr   ; offset calculation for rgEBifIsrTable
    mul  dx
    mov  si, ax
    add  si, bx
    mov  bx, rgLdtrISR
    mov  ldtrISR, bx
    mov  bx, rgDsISR
    mov  dsISR, bx
    mov  bx, rgPProcRa
    mov  pProcRa, bx
    mov  bx, rgPProcSa
    mov  pProcSa, bx

    mov  ax, ldtrISR
    push ax
    push dsISR
    call SetLdtrDs      ; ISR Ldtr

ASSUME DS:NOTHING
    mov  ax, DGROUP
    mov  es, ax

ASSUME ES:DGROUP
    call pProcISR
    push 0
    push DGROUP
    call SetLdtrDs      ; clear ldt ISR

ASSUME DS:DGROUP
    ret
CallEBifIsr ENDP

EBifISR ENDP


EBifDummyISR PROC FAR

ASSUME CS: EBifDisp
ASSUME ES: nothing
ASSUME DS: DGROUP

	mov  ax, 0
	ret

EBifDummyISR ENDP


EBifDisp ENDS
END
