%IF (0) THEN (

ExCmpCmd.Asm:  compare a command name to an abreviation typed by the user.

Syntax:

  fMatch = CmpCmd(oStrCmd, oStrUser)

where

	oStrCmd		is the offset of the command name, and

	oStrUser		is the offset of the abreviation.

Both are null-terminated strings.

The command match routine matches tokens in a user string with the executives command file to report a "hit" or "miss".  The rules allow a "hit" if enough characters are given by user to "imply" a string match if missing characters were assumed to all be correct.  The following examples show "hits" and "misses":

    Command:	    User entry:	    Result:

	Set Time	s		hit
	Set Time	s t		hit
	Set Time	se    t		hit
	Set Time	settime		miss
	Set Time	time		miss

The match is case insensitive.  The routine is an implementation of a finite state machine with 11 states defined as follows:

state0 (initial) -- read next character (execChar) from exec command being checked.  If character is SP (space) then goto state 0 (throw character away). otherwise goto state1.

state1 -- read next character (userChar) from user input string.  If character is a null then we have completed parsing user string and so goto state9.  If character is a SP then goto state1 (throw away). If character is same as execChar then goto state2.  If not, then we have a mismatch and goto state10.

state2 -- read next character (execChar) from exec command being checked.  If null then goto state1 to make sure next user character is also a null.  If character is an SP then goto state3 to discard white and start the next token.  If not a null or SP then goto state5 to continue checking the current token.

state3 -- read next character (execChar) from exec command being checked.  If null then goto state 1 to make sure next user character is also a null.  If its another SP then goto state3 to discard.  If not a null or SP then goto state4 to make sure next  user character is also an SP (or null).

state4 -- read next character (userChar) from user input string.  If null then we have a match and goto state9.  If not an SP or null then we have a longer user token than exec token and so goto state10.  Otherwise goto state1 to eat rest of user SP's and start next token.

state5 -- read next character (userChar) from user input string.  If character is same as execChar then we goto state2 to check next character in token.  If character is a null then we have a match and goto state9.  If character is a space then we have a match within the token and we goto state7 to get start of next token and throw away rest of current exec token.  If character is not an SP or null, and is not same as execChar then we have a failure and goto state10.

state6 -- read next character (userChar) from user input string.  If character is a null then we have a match and goto state9.  If character is an SP then we goto state6 again to discard it.  Otherwise we goto state7 to get rid of rest of current exec token.

state7 -- read next character (execChar) from exec command being checked.  If character is a null then we have a failure because user has more tokens, so we goto state10.  If character is an SP then we go on to state8 to start next token.  If character is anything else we goto state7 again to discard it.

state8 -- read next character (execChar) from exec command being checked.  If character is an SP then we goto state8 again to discard it.  If character is a null then we goto state10.  If character is same as userChar then next token has started OK and we goto state2 to continue parsing.  If character is not an SP and does not match then we have a failure and goto state10.

state9 -- return successful match.

state10 -- return failure.
)FI
ASSUME CS:NOTHING, DS:NOTHING, ES:NOTHING, SS:NOTHING

ExCmpCmdCode SEGMENT PUBLIC 'CODE'
ASSUME CS:ExCmpCmdCode

PUBLIC CmpCmd
CmpCmd PROC FAR;:
	PUSH	BP
	MOV	BP, SP

sArgs	EQU 4
chE	EQU AL
chU	EQU AH

	MOV	SI, 0
	MOV	DI, 0

NodeA:	CALL	GetE
	CMP	chE, ' '
	JE	NodeA
;	JMP	NodeB

NodeB:	CALL	GetU
	JE	NodeMatch0
	CMP	chU, ' '
	JE	NodeB
	CMP	chU, chE
	JE	NodeC
	JMP	NodeNoMatch
NodeD EQU NodeB
NodeG EQU NodeB

NodeC:	CALL	GetE
	JE	NodeD
	CMP	chE, ' '
	JE	NodeE
	JMP	NodeH


NodeE:	CALL	GetE
	JE	NodeD
	CMP	chE, ' '
	JE	NodeE
;	JMP	NodeF

NodeF:	CALL	GetU
	CMP	chU, ' '
	JE	NodeG
	CMP	chU, 0
	JNE	NodeNoMatch
	NodeMatch0:
	JMP	NodeMatch


NodeH:	CALL	GetU
	JE	NodeMatch
	CMP	chU, ' '
	JE	NodeI
	CMP	chE, chU
	JE	NodeC
	JMP	NodeNoMatch

NodeI:	CALL	GetU
	JE	NodeMatch
	CMP	chU, ' '
	JE	NodeI
;	JMP	NodeJ

NodeJ:	CALL	GetE
	JE	NodeNoMatch
	CMP	chE, ' '
	JNE	NodeJ
;	JMP	NodeK

NodeK:	CALL	GetE
	CMP	chE, ' '
	JE	NodeK
	CMP	chE, chU
	JNE	NodeNoMatch
	JMP	NodeC

NodeMatch:
	MOV	AL, 0FFh
	JMP	CmpRet
	
NodeNoMatch:
	MOV	AL, 0
;	JMP	CmpRet

CmpRet:
	POP	BP
	RET	sArgs
CmpCmd ENDP;
GetE PROC;:
	MOV	BX, [BP+8]
	MOV	chE,[BX][SI]
	INC	SI
	CMP	chE, 'a'
	JB	GetEx
	CMP	chE, 'z'
	JA	GetEx
	SUB	chE, 'a'-'A'
GetEx:	CMP	chE, 0
	RET
GetE ENDP

GetU PROC;:
	MOV	BX, [BP+6]
	MOV	chU, [BX][DI]
	INC	DI
	CMP	chU, 'a'
	JB	GetUx
	CMP	chU, 'z'
	JA	GetUx
	SUB	chU, 'a'-'A'
GetUx:	CMP	chU, 0
	RET
GetU ENDP

ExCmpCmdCode ENDS
END
