;******************************* MODULE HEADER *******************************;
;*                                                                           *;
;* FILE: SmString.asm                                                        *;
;*                                                                           *;
;* MACHINE: B20        LANGUAGE: ASSEMBLER  OS: BTOS                         *;
;*                                                                           *;
;* DESCRIPTION:  System Manager text messages                                *;
;*                                                                           *;
;* HISTORY:                                                                  *;
;*                                                                           *;
;* MM/DD/YY VVVV/MM PROGRAMMER   / DESCRIPTION OF CHANGE (Most recent first) *;
;*                                                                           *;
;* 05/09/91 121SDV/06 D. Joshi   / Made it working for B25-MF1 properly.     *;
;* 05/01/91 121J/07 R. Ramesh    / Added SG5000 Icons.                       *;
;* 04/10/91 121j/06 D. Joshi     / Added an Icon for B25-MF1.                *;
;* 12/03/90 121E/05 R. Ramesh    / Added an Icon for SG5000 cabinet.         *;
;* 09/06/89 120C/04 T. Ball      / Removed unused KbdIcon, added Icon36      *;
;* 08/29/89 120C/03 T. Ball      / Merged below changes                      *;
;* 08/22/89 120C/02 N. Vazarkar  / Added ICons for MCR and single floppy     *;
;*                                 drive.                                    *;
;* 08/22/89 120C/01 T. Ball      / Added Unisys data comm module             *;
;*                                                                           *;
;*                                                                           *;
;* TITLE:  BTOS SYSTEM SOFTWARE                                              *;
;*                                                                           *;
;*            PROPRIETARY PROGRAM MATERIAL                                   *;
;*                                                                           *;
;* THIS MATERIAL IS PROPRIETARY TO UNISYS CORPORATION AND IS NOT TO BE       *;
;* REPRODUCED, USED OR DISCLOSED EXCEPT IN ACCORDANCE WITH PROGRAM LICENSE   *;
;* OR UPON WRITTEN AUTHORIZATION OF THE PATENT DIVISION OF UNISYS            *;
;* CORPORATION, DETROIT, MICHIGAN 48232, USA.                                *;
;*                                                                           *;
;* COPYRIGHT (C) 1980, 1989 CONVERGENT TECHNOLOGIES INC. ALL RIGHTS RESERVED *;
;* COPYRIGHT (C) 1980, 1989 UNISYS CORPORATION. ALL RIGHTS RESERVED          *;
;* ************************************************************************* *;
;*                                                                           *;
;* UNISYS BELIEVES THAT THE SOFTWARE FURNISHED HEREWITH IS ACCURATE AND      *;
;* RELIABLE, AND MUCH CARE HAS BEEN TAKEN IN ITS PREPARATION.  HOWEVER,      *;
;* NO RESPONSIBILITY, FINANCIAL OR OTHERWISE, CAN BE ACCEPTED FOR ANY        *;
;* CONSEQUENCES ARISING OUT OF THE USE OF THIS MATERIAL, INCLUDING LOSS OF   *;
;* PROFIT, INDIRECT, SPECIAL, OR CONSEQUENTIAL DAMAGES, THERE ARE NO         *;
;* WARRANTIES WHICH EXTEND BEYOND THE PROGRAM SPECIFICATION.                 *;
;*                                                                           *;
;* THE CUSTOMER SHOULD EXERCISE CARE TO ASSURE THAT USE OF THE SOFTWARE      *;
;* WILL BE IN FULL COMPLIANCE WITH LAWS, RULES AND REGULATIONS OF THE        *;
;* JURISDICTIONS WITH RESPECT TO WHICH IT IS USED.                           *;
;*                                                                           *;
;*                                                                           *;
;*************************** END OF MODULE HEADER ****************************;
;
; NGen Module Type Table
;
; Change Log:
;-- 11.0 --
;	11/15/86	IK	Complete rewrite 
;-- 12.0 --
;	05/03/88	TAB	Srp Icons
;	08/17/89 TAB	Added Unisys intelligent datacomm module (Icon33)
;

$INCLUDE(Parse.mdf)
$INCLUDE(Icon.mdf)
public rgpIcons
public nIcons, nDiskIcons
public nDualIcons, nTrioIcons
public rgDualIcons, rgTrioIcons
public rgDualIconCols, rgTrioIconCols
public rgDiskIcons, rgDiskIconDisks

%set(nIcons,0)

DGROUP GROUP CONST, data

Data segment public 'data'
RgpIcons label word
Data ends

CONST SEGMENT PUBLIC 'CONST'

; The following table determines how to highlight the icons that contain
; more than one device.  rgDualIcons and rgTrioIcons are arrays of double and
; triple icons respectively.  rgDualIconCols consists of two iCol/sCol pairs 
; for each icon, while rgTrioIconCols has three.  All iCol values are offsets
; from the beginning of the icon.

nDualIcons		DW	6
rgDualIcons		DB	1, 2, 5, 7, 36, 42
rgDualIconCols	DB	0,7,6,5, 0,7,6,5, 0,8,7,8, 0,12,11,8, 0,9,8,9, 0,7,6,5

nTrioIcons		DW	3
rgTrioIcons		DB	4, 6, 10
rgTrioIconCols	DB	0,8,7,5,11,4,  0,8,7,5,11,8,  0,7,6,6,11,5

; This table declares what modules have drives in them, and what drive type.
; There are three columns for each module, since that is the maximum number
; of possible drives per module.

F				EQU	1			; floppy drive -- [Fn] device
H				EQU	2			; hard drive -- [Dn] device
P				EQU 3			; Series x86i processor

nDiskIcons		DW	12
rgDiskIcons		DB	1, 2, 3, 4, 5, 6, 7, 10, 36, 38, 39, 42
rgDiskIconDisks	DB	F,F,0, H,F,0, H,0,0, H,F,H, H,H,0, H,F,H, H,H,0, P,H,F, F,F,0, F,0,0, H,0,0, F,F,0


; Icon Definitions

; Mystery Module (unknown)
%ICON Icon00 HEIGHT 7 WIDTH 5:

   
   
   
   


;

; Dual Floppy
%ICON Icon01 HEIGHT 7 WIDTH 11:

     
 
 
     


;

; Floppy/Hard 
%ICON Icon02 HEIGHT 7 WIDTH 11:

      
    
    
      


;

; Hard disk
%ICON Icon03 HEIGHT 7 WIDTH 11:

        
        
        
        


;

; Hard disk with expansion
%ICON Icon04 HEIGHT 7 WIDTH 15:

         
       
       
         


;


%ICON Icon05 HEIGHT 7 WIDTH 15:

           
           
           
           


;


%ICON Icon06 HEIGHT 7 WIDTH 19:

             
           
           
             


;


%ICON Icon07 HEIGHT 7 WIDTH 19:

               
               
               
               


;


; Generic single slice - GC00x, TM00x, PC00x, XE00x
%ICON Icon08 HEIGHT 7 WIDTH 5:

   
   
   
   


;




; Processor module - CP00x
%ICON Icon09 HEIGHT 7 WIDTH 11:

      
       
       
       


;


; NewGen - Series x86i
%ICON Icon10 HEIGHT 7 WIDTH 21:

             
            
            
              


;

;  Monitor
%ICON Icon11 HEIGHT 7 WIDTH 9:


     


  
  
;



; Keyboard
%ICON Icon12 HEIGHT 7 WIDTH 14:
              
              


      
    

;


; Mouse
%ICON Icon13 HEIGHT 7 WIDTH 3:
   
   
  
 

 

;


; Tape
%ICON Icon14 HEIGHT 7 WIDTH 11:

       
       
       
  


;

; CWS
%ICON Icon15 HEIGHT 7 WIDTH 17:
                 
                 
                 
                 



;

; BX004
%ICON Icon16 HEIGHT 7 WIDTH 13:

         
         
         
         


;


; DAI module
%ICON Icon17 HEIGHT 7 WIDTH 3:
   
   

 
|
 

;


; L B module
%ICON Icon18 HEIGHT 7 WIDTH 6:
      
      
      
      



;



; PinPad module
%ICON Icon19 HEIGHT 7 WIDTH 5:
     
     





;

%ICON Icon20 HEIGHT 7 WIDTH 12:

          
          
          
          


;

; SRP Processor
%ICON Icon21 HEIGHT 7 WIDTH 3:

 
 

 
:

;


; SRP Memory Expansion
%ICON Icon22 HEIGHT 7 WIDTH 3:

 
 

 
 

;


; SRP DP processor
%ICON Icon23 HEIGHT 7 WIDTH 6:

  
  

  
 :

;


; Srp QIC Drive
%ICON Icon24 HEIGHT 3 WIDTH 10:

    

;


; Srp Drive Zero
%ICON Icon25 HEIGHT 3 WIDTH 10:

       

;


; Srp Drive One
%ICON Icon26 HEIGHT 3 WIDTH 10:

       

;


; Srp Drive Two
%ICON Icon27 HEIGHT 3 WIDTH 10:

       

;


; Srp Drive Three
%ICON Icon28 HEIGHT 3 WIDTH 10:

       

;


; Srp Cabinet
%ICON Icon29 HEIGHT 13 WIDTH 20:

                  
                  
                  

                  
                  
                  
                  
                  
                  
                  

;


; SMD Drive
%ICON Icon30 HEIGHT 3 WIDTH 13:
   
       
  
;


; " Tape Drive
%ICON Icon31 HEIGHT 3 WIDTH 13:
   
  O__O  
  
;


; Multibus Adapter
%ICON Icon32 HEIGHT 7 WIDTH 3:

o



o

;


; Unisys intelligent datacomm modules
%ICON Icon33 HEIGHT 7 WIDTH 8:

     
     
     
     


;

; Mag Card Reader.
%ICON Icon34 HEIGHT 7 WIDTH 6:
      
      
     
    



;

; Single Floppy
%ICON Icon35 HEIGHT 7 WIDTH 7:

   
 
 
   


;

; B27 Dual Floppy
%ICON Icon36 HEIGHT 7 WIDTH 17:
                 
                 
                 
                 



;

;SG Cabinet
%ICON Icon37 HEIGHT 7 WIDTH 15:

            
   
            
   
            

;

; SG 31/2 " Floppy Drive
%ICON Icon38 HEIGHT 2 WIDTH 5:


;

;SG HardDisk Icon
%ICON Icon39 HEIGHT 4 WIDTH 5:

     


;

;SG TapeDrive Icon
%ICON Icon40 HEIGHT 6 WIDTH 5:

     

     

O_O
;

;SG5000 Processor
%ICON Icon41 HEIGHT 6 WIDTH 1:






;

; B25-MF1 floppy
%ICON Icon42 HEIGHT 7 WIDTH 11:

      
 
 
      


;

CONST ENDS

data segment public 'data'
nIcons dw %nIcons
data ends

END
