;******************************* MODULE HEADER *******************************;
;*                                                                           *;
;* FILE: NmiIntHandler.asm                                                   *;
;*                                                                           *;
;* MACHINE: B20        LANGUAGE: ASSEMBLER  OS: BTOS                         *;
;*                                                                           *;
;* DESCRIPTION:                                                              *;
;*                                                                           *;
;*                                                                           *;
;* HISTORY:                                                                  *;
;*                                                                           *;
;* Routines to detect unbooted processors.                                   *;
;*                                                                           *;
;* MM/DD/YY VVVV/MM PROGRAMMER   / DESCRIPTION OF CHANGE (Most recent first) *;
;*                                                                           *;
;* 03/08/90 120H/04 S. Seike     / Commented out all procedures.             *;
;* 12/08/89 120E/03 A. Thurber   / Always enable NMI when done with it.      *;
;* 10/03/89 120C/02 T. Ball      / Use 7Eh for bMbaType so it looks booted,  *;
;*                                 fQicPresent to call SetupRct, CleanupRct  *;
;* 08/28/89 120C/01 P. Campbell  / Master -> Server, Server -> Service       *;
;* 05/10/88 120A/00 T. Ball      / Created from SRP InitRemCpu_MF.asm and    *;
;*                                 SRP boot rom module FpTape.asm            *;
;*                                                                           *;
;* TITLE:  BTOS SYSTEM SOFTWARE                                              *;
;*                                                                           *;
;*            PROPRIETARY PROGRAM MATERIAL                                   *;
;*                                                                           *;
;* THIS MATERIAL IS PROPRIETARY TO UNISYS CORPORATION AND IS NOT TO BE       *;
;* REPRODUCED, USED OR DISCLOSED EXCEPT IN ACCORDANCE WITH PROGRAM LICENSE   *;
;* OR UPON WRITTEN AUTHORIZATION OF THE PATENT DIVISION OF UNISYS            *;
;* CORPORATION, DETROIT, MICHIGAN 48232, USA.                                *;
;*                                                                           *;
;* COPYRIGHT (C) 1980, 1989 CONVERGENT INCORPORATED. ALL RIGHTS RESERVED     *;
;* COPYRIGHT (C) 1980, 1989 UNISYS CORPORATION. ALL RIGHTS RESERVED          *;
;* ************************************************************************* *;
;*                                                                           *;
;* UNISYS BELIEVES THAT THE SOFTWARE FURNISHED HEREWITH IS ACCURATE AND      *;
;* RELIABLE, AND MUCH CARE HAS BEEN TAKEN IN ITS PREPARATION.  HOWEVER,      *;
;* NO RESPONSIBILITY, FINANCIAL OR OTHERWISE, CAN BE ACCEPTED FOR ANY        *;
;* CONSEQUENCES ARISING OUT OF THE USE OF THIS MATERIAL, INCLUDING LOSS OF   *;
;* PROFIT, INDIRECT, SPECIAL, OR CONSEQUENTIAL DAMAGES, THERE ARE NO         *;
;* WARRANTIES WHICH EXTEND BEYOND THE PROGRAM SPECIFICATION.                 *;
;*                                                                           *;
;* THE CUSTOMER SHOULD EXERCISE CARE TO ASSURE THAT USE OF THE SOFTWARE      *;
;* WILL BE IN FULL COMPLIANCE WITH LAWS, RULES AND REGULATIONS OF THE        *;
;* JURISDICTIONS WITH RESPECT TO WHICH IT IS USED.                           *;
;*                                                                           *;
;*                                                                           *;
;*************************** END OF MODULE HEADER ****************************;


$Include(:f0:Cdtequ.edf)
$Include(:f0:ServerHwEqu.edf)
$Include(:f0:Real186Equ.edf)


Dgroup	Group	Data

NmiLevel		Equ	2	; Nmi's are level 2 ints
nullCpuId		Equ	0F0h	; A reserved, and impossible, CpuId
ATpCdt			Equ	1F8h	; linearized cdt pointer
QICSlot			Equ	77h
ResetHwAddress		Equ	02E1h
FlagNExceptionBit	Equ	010h
FlagNInterruptBit	Equ	020h
statusDriveUnselectBit	Equ	020h
commandReadStatus	Equ	0C0h
ReadStatusAddress	Equ	00F1h
StatusDataAddress	Equ	00C9h
RequestAddress		Equ	01E9h
maxStatusBytes		Equ	005 
ReadFlagsAddress	Equ	00A9h
FlagQiciBusyBit		Equ	004h
FlagNReadyBit		Equ	008h
QICposWaitCount		Equ	30000  		; 30 seconds
RemoteAddrBias		Equ	0C000h
QICBusyWaitCount	Equ	3000  		; 3 seconds
QICITimeoutCount	Equ	5000  		; 5 seconds
AdapterUpperLinearAddress Equ	10h
AdapterIcw1Address	Equ	3
AdapterIcw1			Equ	13h
bMbaType			Equ	07Eh
bBrType				Equ	0FFh

Data	Segment	Public	'Data'

fBusTimeout	Db	0
%if (0) then (
OldNmi		DD	?
MyNmi		DD	NmiHandler
ScrWordData	DW	?
wRemoteAddrBias	DW	?
QICStatusBytes	DB	6 DUP (?)
wBr0Save	DW	?
)fi

Data	Ends

%if (0) then (
Extrn	bLocalSlot: Byte

Public	RemoteCpuType, SetupRct, CleanupRct, NmiHandler, fQicPresent
Public	fBusTimeout, FGotNmi
)fi

NmiIntHandler	Segment	Public	'Code'

Assume	Cs : NmiIntHandler, Ds : Dgroup, Es : Nothing


%if (0) then (
FGotNmi: PROCEDURE FLAG PUBLIC;
  END FGotNmi;

FGotNmi	Proc	Far
	Push	Bp
	Mov	Bp, Sp

	Mov	Cx, 10
	Loop	$			; slop a few cycles	

	Cmp	fBusTimeout, 0
	Jne	BusErr
	In	Ax, NmiSourcePort
	Mov	Dx, Ax

; writing 0 clears latched NMI
	Xor	Ax, Ax
	Out	NmiSourcePort, Ax

; nmi test bits are 0 (inverted) if nmi condition found
	Test	Dx, NonExistentMemoryBit
	Jz	BusErr
	Test	Dx, BusTimeoutBit
	Jz	BusErr
	Test	Dx, BusErrorBit
	Jz	BusErr

NoErr:             ; Return FALSE
	jmp  FGNRet

BusErr:            ; Return TRUE
	mov  AX, 0FFh

FGNRet:
	push AX
	mov  al, 1
	out  NmiSourcePort, al    ; m03, Enable NMI
	pop  AX
	pop  BP
	ret

FGotNmi	Endp
)fi
	

;  Set up for special NMI handling (using our handler)

%if (0) then (
SetupRct: PROCEDURE PUBLIC;
  END SetupRct;

SetupRct	Proc	Far
	Push	Bp
	Mov	Bp, Sp
	Xor	Ax,Ax
	cli
	Mov	Es, Ax
	Mov	Di, NmiLevel*4
	Mov	Ax, Es : Word Ptr [ Di ]
	Mov	Word ptr OldNmi, Ax
	Mov	Ax, Es : Word Ptr [ Di+2 ]
	Mov	Word ptr OldNmi+2, Ax
	Mov	Ax, word ptr MyNmi
	Mov	Es : [ Di ], Ax
	Mov	Ax, word ptr MyNmi+2
	Mov	Es : [ Di+2 ], Ax
	sti
	Pop	Bp
	Ret
SetupRct	Endp
)fi


;  Cleanup after special NMI handling (restore old handler)

%if (0) then (
CleanupRct: PROCEDURE PUBLIC;
  END CleanupRct;

CleanupRct	Proc	Far
	Push	Bp
	Mov	Bp, Sp
	Xor	Ax,Ax
	Mov	Es, Ax
	Mov	Di, NmiLevel*4
	Mov	Ax, word ptr OldNmi
	Mov	Es : [ Di ], Ax
	Mov	Ax, word ptr OldNmi+2
	Mov	Es : [ Di+2 ], Ax
	mov  al, 0                ; m03, Clear any latched NMI and re-enable.
	out  NmiSourcePort, al
	mov  al, 1
	out  NmiSourcePort, al
	Pop	Bp
	Ret
CleanupRct	Endp
)fi


;  Given a slot parameter, 
;  this routine returns the type of the remote processor
;  in Ax.  If the remote processor is not found or if
;  it has not initialized properly, then it returns the
;  distinguished value "NullCpuId" which is not the same
;  as any real processor type.


%if (0) then (
RemoteCpuType: PROCEDURE (bSlot) BYTE PUBLIC;
  DECLARE bSlot BYTE;
  END RemoteCpuType;

RemoteCpuType	Proc	Far
	Push	Bp
	Mov	Bp, Sp

	In	Ax, Br0Port
	Mov	wBr0Save, Ax

	Mov	Al, Byte Ptr [Bp+6]	; Slot number
	Out	RemoteSlotPort, Al
	Mov	Bl, Al
	And	Al, 0Fh			; Bus Repeater Slot?
	Jnz	NotBr

	Xor	Ax, Ax
	Out	Br0Port, Ax
	Mov	fBusTimeout, Al		; clear timeout checks
	Out	NmiSourcePort, Ax
	Mov	Ax, RemoteAddrBias
	Mov	Es, Ax
	Mov	Al, Es : Byte Ptr BrSlotReg

	Mov	Cx, 10
	Loop	$		; slop a few cycles	

	Cmp	fBusTimeout, 0
	Jne	NotPresent0

	Cmp	Al, Bl
	Jne	NotPresent0

	Mov	Al, bBrType
	Jmp	Xit

NotPresent0:
	Mov	Al, NullCpuId
	Jmp	Xit

NotBr:
RctLoop:
	Xor	Ax, Ax
	Out	Br0Port, Ax
	Mov	fBusTimeout, Al		; Not yet, anyhow
	Out	NmiSourcePort, Ax
	Mov	Ax, RemoteAddrBias
	Mov	Es, Ax
	Mov	Ax, Es : Word Ptr AtpCdt; first remote reference
	Push	Ax
	Call	FGotNmi
	And	Al, Al
	Pop	Ax
	Jz	KeepChking
	Jmp	CheckMba		; no processor present

KeepChking:
	Xchg	Ah, Al
	Mov	Bx, Es : Word Ptr AtpCdt+2
	Xchg	Bh, Bl
	Out	Br0Port, Ax
	Inc	Ax
	Out	Br1Port, Ax
	Mov	Ax, Bx
	Shr	Ax, 1
	Shr	Ax, 1
	Shr	Ax, 1
	Shr	Ax, 1
	Add	Ax, RemoteAddrBias
	Mov	Es, Ax
	And	Bx, 0Fh			; Now Es : Bx is remote Cdt
	Cmp	Es : Byte Ptr [Bx+bBootStructFF], 0FFh
	Jne	NotPresent
	Cmp	Es : Byte Ptr [Bx+bBootStructA6], 0A6h
	Jne	NotPresent
	Cmp	Es : Byte Ptr [Bx+bBootStruct0], 0
	Jne	NotPresent
	Mov	Al, Es : Byte Ptr [Bx+bBootCommand]
	Cmp	Al, fFailedDiagnostics
	Je	NotPresent

CkRest:
	Cmp Al, fRunning
	Je	Xit1
	Cmp	Al, fBootMe
	Je	Xit1
	Cmp	Al, fDumpThenBoot
	Je	Xit1
	Cmp	Al, fDumpThenInterrupt
	Je	Xit1
	Cmp	Al, fDumpThenError
	Jne	NotPresent
Xit1:	
	Mov	Al, Es : Byte Ptr [Bx+bProcessorType]
	Jmp Xit

CheckMba:
	Xor	Ax, Ax
	Out	Br0Port, Ax
	Mov	fBusTimeout, Al		; Not yet, anyhow
	Out	NmiSourcePort, Ax
	Mov	Ax, RemoteAddrBias
	Mov	Es, Ax
	Xor	Ax, Ax
	Mov	Es : Word Ptr [0], Ax
	Call	FGotNmi
	And	Al, Al
	Jz	NotPresent		; mba should timeout

	Mov	Ax, AdapterUpperLinearAddress;
	Out	Br0Port, Ax
	Xor	Ax, Ax
	Mov	fBusTimeout, Al
	Out	NmiSourcePort, Ax
	Mov	Ax, RemoteAddrBias
	Mov	Es, Ax
	Mov	Al, AdapterICW1
	Mov	Es : Byte Ptr AdapterIcw1Address, Al
	Call	FGotNmi
	And	Al, Al
	Jnz	NotPresent
	Mov	Al, bMbaType
	Xor	Ah, Ah
	Jmp Xit

NotPresent:
	Mov	Al, NullCpuId

Xit:
	Xor	Ah, Ah

	Push	Ax
	Mov	Ax, wBr0Save
	Out	Br0Port, Ax
	Mov	Al, Ds: Byte Ptr [bLocalSlot]
	Out	RemoteSlotPort, Al
	mov  al, 0                ; m03, Clear any latched NMI and re-enable.
	out  NmiSourcePort, al
	mov  al, 1
	out  NmiSourcePort, al
	Pop	Ax

	Pop	Bp
	Ret	2

RemoteCpuType	Endp
)fi


%if (0) then (
NmiHandler: PROCEDURE PUBLIC;
  END NmiHandler;

NmiHandler	Proc	Far
	Push	Ax
	Mov	fBusTimeout, 0FFh
	Pop	Ax
	Iret

NmiHandler	Endp
)fi


%if (0) then (
fQicPresent: PROCEDURE Flag PUBLIC;
  END fQicPresent;

fQicPresent	Proc	Far
	Push	Bp
	Mov	Bp, Sp

	Call	SetupRct

; Initialize Remote Address constant, Slot Number for QIC board
	Xor	Ax, Ax
	Mov	fBusTimeout, Al
	Out	NmiSourcePort, Ax
	In	Ax, Br0Port
	Mov	wBr0Save, Ax
	Mov	wRemoteAddrBias,RemoteAddrBias
	Mov	Al, QICslot
	Out	RemoteSlotPort,Al
	Mov	Es, wRemoteAddrBias

	Call	ReadQICStatusBytes
	Jc	NoQic
	Mov	Al, Byte Ptr QICStatusBytes[0]
	Test	Al, statusDriveUnselectBit
	Jnz	NoQic
	Mov	Al, 0FFh
	Jmp	QicExit

NoQic:
	Xor	Al, Al
QicExit:
	Xor	Ah, Ah
	Push	Ax
	Mov	Ax, wBr0Save
	Out	Br0Port, Ax
	Mov	Al, Ds: Byte Ptr [bLocalSlot]
	Out	RemoteSlotPort, Al
	Call	CleanupRct
	mov  al, 0                ; m03, Clear any latched NMI and re-enable.
	out  NmiSourcePort, al
	mov  al, 1
	out  NmiSourcePort, al
	Pop	Ax
	Pop	Bp
	Ret	2

fQicPresent	Endp
)fi


;*****************************************************
; Delay1Ms -- busy wait for 1 millisec
;
; arguments -- none
;	CALL	Delay1Ms
;
;	delay is calibrated for 186 cpu at 8 MHz
;

%if (0) then (
Delay1Ms	Proc
	PUSH	CX
	PUSH	DX
	MOV	CX, 54
	XOR	DX,DX
;  Inner loop is 147 cycles.  54*147 = 7928 since
;  last loop iteration is 10 clocks short.
;  The calling sequence adds approximately 70 clocks.

DelayLoop:
	Mul	ScrWordData
	Mul	ScrWordData
	Mul	ScrWordData
	Loop	DelayLoop		; 15/5 cycles
	POP	DX
	POP	CX
	RET
Delay1Ms	ENDP


;*******************************************************
; ReadQICStatusBytes
;                        
;

ReadQICStatusBytes	Proc

	Mov	Al, QICslot
	Out	RemoteSlotPort,Al
	Mov	Es, wRemoteAddrBias

; Issue read status bytes command
	Mov	Ax,ReadStatusAddress
	Out	Br0Port,Ax
	Mov	Al,commandReadStatus
	Not	Al
	Mov	Es:Byte Ptr 0,Al

; If an NMI just occurred, then the QIC board is not there
	Call	FGotNmi
	Cmp	Al, 0FFh
	Jne	QICexists
	Stc				; no QIC!
	Jmp	ReadQicStatusRet

QICexists:
;	Call	WaitTillQICNotBusy
;	Jc	ReadQICStatusRet
;
;	XOR	Bx,Bx		; counts the status bytes
;
;QICNextStatusByte:
;	Call	WaitTillQICReady
;	Jc	ReadQICStatusRet

; Read a status byte and save it
;	Mov	Ax,StatusDataAddress
;	Out	Br0Port,Ax
;	Mov	Al,Es:Byte Ptr 0
;	Not	Al
;	Mov	Byte Ptr QICStatusBytes[Bx], Al
;
; Assert REQUEST
;	Mov	Ax,RequestAddress
;	Out	Br0Port,Ax
;	Mov	Es:Byte Ptr 0,0

;	Inc	Bx
;	Cmp	Bx,maxStatusBytes
;	Jbe	QICNextStatusByte
	Clc

ReadQICStatusRet:
	Ret

ReadQICStatusBytes	Endp


;*******************************************************
; WaitForQICint
;                 
;  Waits for the next interrupt from QICI board.
;  Leaves the QICI flags in Al
;
;  Success (carry clear) means that QICI interrupt was received.
;  Failure (carry set) means that we Timed Out waiting for the
;  interrupt.
;

WaitForQICint	Proc

	Call	Delay1Ms

	Mov	Al, QICslot
	Out	RemoteSlotPort,Al
	Mov	Es, wRemoteAddrBias
	Mov	Cx, QICITimeoutCount
	Clc

; Wait for an INT to be asserted
	Mov	Ax,ReadFlagsAddress
	Out	Br0Port,Ax

LoopWaitForQICint:
	Mov	Al,Es:Byte Ptr 0
	Test	Al,FlagNInterruptBit
	Jz	DoneQICIntWait
	Call	Delay1Ms
	Loop	LoopWaitForQICInt
	Stc				;we timed out!

DoneQICIntWait:
	Ret

WaitForQICint	EndP


;*******************************************************
; WaitTillQICNotBusy
;                     
;  Waits for the QICI interface to go not busy.                    
;                     
;  Success (carry clear) means that QICI is no longer busy
;  Failure (carry set) means that we Timed Out waiting for
;  QICI to go not busy.  
;

WaitTillQICNotBusy	Proc

	Mov	Al, QICslot
	Out	RemoteSlotPort,Al
	Mov	Es, wRemoteAddrBias
	Mov	Cx, QICBusyWaitCount

; Issue read flags command
	Mov	Ax,ReadFlagsAddress
	Out	Br0Port,Ax

KeepWaitTillQICNotBusy:
	Mov	Al,Es:Byte Ptr 0
	Test	Al,FlagQICIBusyBit
	Jz	QICNotBusyOK
	Call	Delay1Ms
	Loop	KeepWaitTillQICNotBusy

	Stc
	Ret

QICNotBusyOK:
	Clc
	Ret

WaitTillQICNotBusy	Endp


;*******************************************************
; WaitTillQICReady
;                        
;  Waits for the QIC Tape Ready to be asserted.                   
;                     
;  Success (carry clear) means that QIC Tape Ready is asserted.
;  Failure (carry set) means that we Timed Out waiting for
;  QIC Tape Ready.
;

WaitTillQICReady	Proc

	Mov	Al, QICslot
	Out	RemoteSlotPort,Al
	Mov	Es,wRemoteAddrBias
	Mov	Cx, QICBusyWaitCount

; Issue read flags command
	Mov	Ax,ReadFlagsAddress
	Out	Br0Port,Ax

KeepWaitTillQICReady:
	Mov	Al,Es:Byte Ptr 0
	Test	Al,FlagNReadyBit
	Jz	QICReadyOK
	Call	Delay1Ms
	Loop	KeepWaitTillQICReady

	Stc
	Ret

QICReadyOK:
	Clc
	Ret

WaitTillQICReady	Endp
)fi


NmiIntHandler	Ends

End
