/*******************************************************************************
*  Copyright 1985 - 1990 by Advanced Programming Institute, Ltd.               *
*  All rights reserved.  May not be reproduced or distributed, in printed or   *
*  electronic form, without permission of Advanced Programming Institute, Ltd. *
*  May not be distributed as object code, separately or linked with other      *
*  object modules, without permission.                                         *
*******************************************************************************/

#ifndef KEYCODE_INCLUDED
#define KEYCODE_INCLUDED

/*=1*/
#define K_CTL_A    1		       /* control A */
#define K_CTL_B    2
#define K_CTL_C    3
#define K_CTL_D    4
#define K_CTL_E    5
#define K_CTL_F    6
#define K_CTL_G    7
#define K_BEL      7		       /* bell */
#define K_CTL_H    8
#define K_BS      8		       /* backspace */
#define K_CTL_I    9
#ifndef K_TAB
#define K_TAB      9		       /* horizontal tab */
#endif
#define K_CTL_J    10
#define K_LF      10		       /* line feed (newline) */
#define K_CTL_K    11
#define K_CTL_L    12
#define K_CTL_M    13
#ifndef K_RET
#define K_RET      13		       /* return */
#endif
#define K_CTL_N    14
#define K_CTL_O    15
#define K_CTL_P    16
#define K_CTL_Q    17
#define K_CTL_R    18
#define K_CTL_S    19
#define K_CTL_T    20
#define K_CTL_U    21
#define K_CTL_V    22
#define K_CTL_W    23
#define K_CTL_X    24
#define K_CTL_Y    25
#define K_CTL_Z    26
#define K_CTL_LB   27		       /* control [ */
#ifndef K_ESC
#define K_ESC      27		       /* escape    */
#endif
#define K_CTL_BSLSH 28		       /* control \ */
#define K_CTL_RB   29		       /* control ] */
#define K_CTL_CFLEX 30		       /* control ^ */
#define K_CTL_UNDER 31		       /* control _ */
#ifndef K_DEL
#define K_DEL      127		       /* delete */
#endif
/**/

/*=2*/
#ifndef K_UP
#define K_UP      301		       /* up arrow */
#define K_DOWN      302		       /* down arrow */
#define K_RIGHT    303		       /* right arrow */
#define K_LEFT      304		       /* left arrow */
#define K_PREV      305		       /* previous screen */
#define K_NEXT      306		       /* next screen */
#define K_LHOME    307		       /* line home */
#define K_LEND      308		       /* line end */
#define K_HOME      309		       /* home */
#define K_END      310		       /* end */
#define K_INS      312		       /* insert */
#define K_WLEFT    313		       /* word left */
#define K_WRIGHT   314		       /* word right */
#define K_BTAB      315		       /* back tab */
#define K_HELP    316		       /* help */
#define K_CLEAR  317		       /* clear */
#define K_BOD    319		       /* begin of data */
#define K_EOD    320		       /* end of data */
#define K_BOF    321		       /* begin of field */
#define K_EOF    322		       /* end of field */
#define K_SCL_RIGHT   323	       /* scroll window right */
#define K_SCL_LEFT     324	       /* scroll window left */
#endif
#define K_ZOOM_OUT   325	       /* zoom out */
#define K_ZOOM_IN   326		       /* zoom in */
#define K_SH_UP      327	       /* up arrow */
#define K_SH_DOWN   328		       /* down arrow */
#define K_SH_RIGHT    329	       /* right arrow */
#define K_SH_LEFT   330		       /* left arrow */
/**/

/*=3*/
#ifndef K_F1
#define K_F1      331		       /* function key 1 */
#define K_F2      332
#define K_F3      333
#define K_F4      334
#define K_F5      335
#define K_F6      336
#define K_F7      337
#define K_F8      338
#define K_F9      339
#define K_F10      340
#endif
/**/

/*=5*/
#ifndef K_S_F1
#define K_S_F1      341		       /* shift F1 */
#define K_S_F2      342
#define K_S_F3      343
#define K_S_F4      344
#define K_S_F5      345
#define K_S_F6      346
#define K_S_F7      347
#define K_S_F8      348
#define K_S_F9      349
#define K_S_F10    350
#endif
#ifndef K_C_F1
#define K_C_F1      351		       /* control F1 */
#define K_C_F2      352
#define K_C_F3      353
#define K_C_F4      354
#define K_C_F5      355
#define K_C_F6      356
#define K_C_F7      357
#define K_C_F8      358
#define K_C_F9      359
#define K_C_F10    360
#endif
#ifndef K_A_F1
#define K_A_F1      361		       /* alternate F1 */
#define K_A_F2      362
#define K_A_F3      363
#define K_A_F4      364
#define K_A_F5      365
#define K_A_F6      366
#define K_A_F7      367
#define K_A_F8      368
#define K_A_F9      369
#define K_A_F10    370
#endif
/**/

/*=4*/
#ifndef K_ALT_A
#define ALT_OFFSET   1024
#define ALT_TOP      2048
#define K_ALT_A    1089		       /* alternate A */
#define K_ALT_B    1090
#define K_ALT_C    1091
#define K_ALT_D    1092
#define K_ALT_E    1093
#define K_ALT_F    1094
#define K_ALT_G    1095
#define K_ALT_H    1096
#define K_ALT_I    1097
#define K_ALT_J    1098
#define K_ALT_K    1099
#define K_ALT_L    1100
#define K_ALT_M    1101
#define K_ALT_N    1102
#define K_ALT_O    1103
#define K_ALT_P    1104
#define K_ALT_Q    1105
#define K_ALT_R    1106
#define K_ALT_S    1107
#define K_ALT_T    1108
#define K_ALT_U    1109
#define K_ALT_V    1110
#define K_ALT_W    1111
#define K_ALT_X    1112
#define K_ALT_Y    1113
#define K_ALT_Z    1114
#define K_ALT_0      1072
#define K_ALT_1      1073
#define K_ALT_2      1074
#define K_ALT_3      1075
#define K_ALT_4      1076
#define K_ALT_5      1077
#define K_ALT_6      1078
#define K_ALT_7      1079
#define K_ALT_8      1080
#define K_ALT_9      1081
#endif
/**/

#endif
/* eof */

#ifndef VK_BUTTON1
/*** Virtual key values */

#define VK_BUTTON1		0x01
#define VK_BUTTON2		0x02
#define VK_BUTTON3		0x03
#define VK_BREAK		0x04
#define VK_BACKSPACE		0x05
#define VK_TAB			0x06
#define VK_BACKTAB		0x07
#define VK_NEWLINE		0x08
#define VK_SHIFT		0x09
#define VK_CTRL 		0x0A
#define VK_ALT			0x0B
#define VK_ALTGRAF		0x0C
#define VK_PAUSE		0x0D
#define VK_CAPSLOCK		0x0E
#define VK_ESC			0x0F
#define VK_SPACE		0x10
#define VK_PAGEUP		0x11
#define VK_PAGEDOWN		0x12
#define VK_END			0x13
#define VK_HOME 		0x14
#define VK_LEFT 		0x15
#define VK_UP			0x16
#define VK_RIGHT		0x17
#define VK_DOWN 		0x18
#define VK_PRINTSCRN		0x19
#define VK_INSERT		0x1A
#define VK_DELETE		0x1B
#define VK_SCRLLOCK		0x1C
#define VK_NUMLOCK		0x1D
#define VK_ENTER		0x1E
#define VK_SYSRQ		0x1F
#define VK_F1			0x20
#define VK_F2			0x21
#define VK_F3			0x22
#define VK_F4			0x23
#define VK_F5			0x24
#define VK_F6			0x25
#define VK_F7			0x26
#define VK_F8			0x27
#define VK_F9			0x28
#define VK_F10			0x29
#define VK_F11			0x2A
#define VK_F12			0x2B
#define VK_F13			0x2C
#define VK_F14			0x2D
#define VK_F15			0x2E
#define VK_F16			0x2F
#define VK_F17			0x30
#define VK_F18			0x31
#define VK_F19			0x32
#define VK_F20			0x33
#define VK_F21			0x34
#define VK_F22			0x35
#define VK_F23			0x36
#define VK_F24			0x37


#define VK_MENU 		VK_F10
#ifdef INCL_NLS
#define VK_DBCSFIRST		0x0080
#define VK_DBCSLAST		0x00ff
#endif /* INCL_NLS */

#define VK_USERFIRST		0x0100
#define VK_USERLAST		0x01ff
#endif

#ifndef KC_CHAR
#define KC_CHAR 		0x0001
#define KC_VIRTUALKEY		0x0002
#define KC_SCANCODE		0x0004

#define KC_SHIFT		0x0008
#define KC_CTRL 		0x0010
#define KC_ALT			0x0020
#define KC_KEYUP		0x0040
#define KC_PREVDOWN		0x0080
#define KC_LONEKEY		0x0100
#define KC_DEADKEY		0x0200
#define KC_COMPOSITE		0x0400
#define KC_INVALIDCOMP		0x0800

#ifndef INCL_SAADEFS
#define KC_TOGGLE		0x1000
#define KC_INVALIDCHAR		0x2000
#define KC_DBCSRSRVD1		0x4000
#define KC_DBCSRSRVD2		0x8000
#endif /* !INCL_SAADEFS */

#endif


#ifdef PROTO
int             keycode (int);

#else
int             keycode ();

#endif
