#ifndef INCL_XVT3H
#define INCL_XVT3H
/* $Revision:   1.7  $ $Date:   27 Nov 1990 19:04:44  $ */
/*---------------------------------------------------------------------------
    This supplement to XVT.H contains API changes for Release 3. Use it like
    this:

        #include "xvt3.h"

    You must not include XVT.H. You must let XVT3.H do it for you.

    Copyright 1990 - 1991 XVT Software Inc. All rights reserved.
---------------------------------------------------------------------------*/
#ifdef INCL_XVTH
#include "Invalid_Include" /* You must not include XVT.H -- see above. */
#endif
/*
    Following definitions kill off definitions in XVT.H.
*/
#define s_event                  kill01
#define EVENT                    kill02
#define EVENT_PTR                kill03
#define s_mouse                  kill04
#define s_char                   kill05
#define s_scroll_info            kill06
#define s_cmd                    kill07
#define s_size                   kill08
#define s_efont                  kill09
#define s_ctl                    kill10
#define win_select_item_text     kill11
#define main_event               kill12
#define tx_event                 kill13
#define new_dialog	         	 kill15
#define new_window	         	 kill16
#define new_child_window         kill17
#define new_control         	 kill18
#define DIALOG_TYPE         	 kill19
#ifdef OSCTO
#define s_user                   kill20
#endif
#define help_event               kill21
#define NO_CONTROL_INFO
#define CONTROL_INFO             short
#ifdef OSCTO
#define s_timer                  kill22
#endif

/******************************************************/
/**************** ADDITIONS BY PLI ********************/
/******************************************************/

#define WIN_TYPE                 kill100
#define W_DOC                    kill101
#define W_PLAIN                  kill102
#define W_DBL                    kill103
#define W_PRINT                  kill104
#define W_NONE                   kill105
#define W_NO_BORDER              kill106
#define WD_MODAL                 kill107
#define WD_MODELESS              kill108
#define WC_PUSHBUTTON            kill109
#define WC_RADIOBUTTON           kill110
#define WC_CHECKBOX              kill111
#define WC_HSCROLL               kill112
#define WC_VSCROLL               kill113
#define WC_EDIT                  kill114
#define WC_TEXT                  kill115
#define WC_LBOX                  kill116
#define WC_TE                    kill117
#define WC_ICON                  kill118

/******************************************************/
/************* END OF ADDITIONS BY PLI ****************/
/******************************************************/

/******************************************************/
/**************** ADDITIONS BY RGW ********************/
/******************************************************/

#define get_window_type 		kill120
#define get_dlg_type			kill121

/******************************************************/
/************* END OF ADDITIONS BY RGW ****************/
/******************************************************/

#include "xvt.h" /* Must be located here -- do not move! */

/******************************************************/
/**************** ADDITIONS BY PLI ********************/
/******************************************************/

#undef WIN_TYPE
#undef W_DOC
#undef W_PLAIN
#undef W_DBL
#undef W_PRINT
#undef W_NONE
#undef W_NO_BORDER
#undef WD_MODAL
#undef WD_MODELESS
#undef WC_PUSHBUTTON
#undef WC_RADIOBUTTON
#undef WC_CHECKBOX
#undef WC_HSCROLL
#undef WC_VSCROLL
#undef WC_EDIT
#undef WC_TEXT
#undef WC_LBOX
#undef WC_TE
#undef WC_ICON

typedef enum {                  /* type of window                */
    W_DOC,                      /* document window               */
    W_PLAIN,                    /* window with plain border      */
    W_DBL,                      /* window with double border     */
    W_PRINT,                    /* XVT internal use only         */
    W_NONE,                     /* app doesn't want std_win ever */
    W_NO_BORDER,                /* no border                     */
    WD_MODAL,                   /* modal dialog                  */
    WD_MODELESS,                /* modeless dialog               */
    WC_PUSHBUTTON,              /* button control                */
    WC_RADIOBUTTON,             /* radio button control          */
    WC_CHECKBOX,                /* check box control             */
    WC_HSCROLL,                 /* horizontal scroll bar control */
    WC_VSCROLL,                 /* vertical scroll bar control   */
    WC_EDIT,                    /* edit control                  */
    WC_TEXT,                    /* static text control           */
    WC_LBOX,                    /* list box control              */
    WC_TE,                      /* text-edit control             */
    WC_ICON,                    /* icon control                  */
    WC_MENUBAR                  /* menubar attached to a window  */
} WIN_TYPE;


/******************************************************/
/************* END OF ADDITIONS BY PLI ****************/
/******************************************************/

#undef s_event
#undef EVENT
#undef EVENT_PTR
#undef s_mouse
#undef s_char
#undef s_scroll_info
#undef s_cmd
#undef s_size
#undef s_efont
#undef s_ctl
#ifdef OSCTO
#undef s_user
#undef s_timer
#endif
#undef win_select_item_text
#undef main_event
#undef tx_event
#undef new_dialog
#undef new_window
#undef new_child_window
#undef new_control
#undef DIALOG_TYPE
#undef CONTROL_INFO
#undef help_event

typedef WIN_TYPE DIALOG_TYPE;
/******************************************************/
/**************** ADDITIONS BY RGW ********************/
/******************************************************/

#undef get_window_type
#undef get_dlg_type

/******************************************************/
/************* END OF ADDITIONS BY RGW ****************/
/******************************************************/

#undef XVT_VER
#define XVT_VER "3.0"

/*
    Following definition important for Zortech C medium model.
*/
#if XVTCC == ZORCC
#undef far
#endif

/*
    Changes for focus in/out notification.
*/
typedef struct s_ctlinfo {      /* info passed to dialog callback fcn */
    WIN_TYPE type;              /* type (WD_MODAL or WD_MODELESS) */
    WINDOW win;                 /* WINDOW for dialog window */
    union {
        struct s_lbox {         /* list box action */
            BOOLEAN dbl_click;  /* double click (vs. single)? */
        } lbox;
        struct s_scroll {       /* scroll bar action */
            SCROLL_CONTROL what;/* site of activity */
            short pos;          /* thumb position */
        } scroll;
        struct s_chr {          /* function key action */
            short ch;           /* char or virtual key code */
            BOOLEAN shift;      /* shift key down? */
            BOOLEAN control;    /* control or option key down? */
#if (XVTOS == CTOOS)
			UINT wStatus;
			UINT wStatus1;
			UCHAR kbdCode;
			UCHAR sChar;
			UINT chordState;
			ULONG chCode; 
#endif			
        } chr;
        struct s_edit {
            BOOLEAN focus_change;/* is event a focus change? */
            BOOLEAN active;     /* if so: gaining focus? (vs. losing) */
        } edit;
    } v;
} CONTROL_INFO, *CONTROL_INFO_PTR;
/*
    Following aren't new, but are here because CONTROL_INFO changed.
*/
typedef struct s_event {
    EVENT_TYPE type;
    union {
        struct s_mouse {            /* E_MOUSE_DOWN, E_MOUSE_UP, E_MOUSE_MOVE,
                                       E_MOUSE_DBL */
            PNT where;              /* location of event (window relative) */
            BOOLEAN shift;          /* shift key down? */
            BOOLEAN control;        /* control or option key down? */
            short button;           /* button number */
        } mouse;
        struct s_char {             /* E_CHAR */
            short ch;               /* character */
            BOOLEAN shift;          /* shift key down? */
            BOOLEAN control;        /* control or option key down? */
#if (XVTOS == CTOOS)
			UINT wStatus;
			UINT wStatus1;
			UCHAR kbdCode;
			UCHAR sChar;
			UINT chordState;
			ULONG chCode; 
#endif			
        } chr;
        BOOLEAN active;             /* E_ACTIVATE: activation? (vs. deactivation) */
        BOOLEAN query;              /* E_QUIT: query only? (app calls quit_OK) */
        struct s_scroll_info {      /* E_VSCROLL, E_HSCROLL */
            SCROLL_CONTROL what;    /* site of activity */
            short pos;              /* thumb position, if SC_THUMB */
        } scroll;
        struct s_cmd {              /* E_COMMAND */
            MENU_TAG tag;           /* menu item tag */
            BOOLEAN shift;          /* shift key? */
            BOOLEAN control;        /* control or option key? */
        } cmd;
        struct s_size {             /* E_SIZE */
            short height;           /* new height */
            short width;            /* new width */    
        } size;
        struct s_efont {            /* E_FONT */
            FONT font;              /* selected font */
            FONT_PART part;         /* part that changed */
        } font;
        struct s_ctl {              /* E_CONTROL */
            short id;               /* control's ID */
            CONTROL_INFO ci;        /* control info */
        } ctl; 
#if (XVTOS == CTOOS)
        struct s_user {             /* E_USER */
        	long info;              /* user info */
        } user;
		struct s_timer {			/* E_TIMER */
			short id;				/* not supported in XVT/CH 2.0 */
		} timer;
#endif
    } v;
} EVENT, *EVENT_PTR;

#if (XVTCC == MSCCC) || (XVTCC == MPW3CC) || (XVTCC == MWCCC) || (XVTCC == ZORCC)
typedef BOOLEAN (XVTENTRY * CALLBACK) BTCENTRY(int cid, CONTROL_INFO_PTR cip);
#else
typedef BOOLEAN (XVTENTRY *CALLBACK) BTCENTRY ();
#endif

#ifdef PROTO
void XVTENTRY main_event(WINDOW w, EVENT_PTR ep);
BOOLEAN XVTENTRY new_dialog(WIN_TYPE t, int rid, CALLBACK fcn, long data);
#else
void main_event();
BOOLEAN new_dialog();
#endif /* PROTO */

#ifdef PROTO
BOOLEAN XVTENTRY help_event(WINDOW w, EVENT_PTR ep);
#else
BOOLEAN XVTENTRY help_event();
#endif /* PROTO */


/*
    Addition for field controls in windows.
*/
#ifdef PROTO
void XVTENTRY win_select_item_text BTCENTRY(WINDOW win, int first, int last);
#else
void win_select_item_text BTCENTRY();
#endif /* PROTO */

/*
    Additions/changes for new text edit features.
*/
#define TX_NOMENU         0x0800        /* no edit menu changes */
#define TX_ENABLECLEAR    0x1000        /* leave CLEAR enabled always */
#ifdef PROTO
BOOLEAN XVTENTRY tx_event(WINDOW win, EVENT_PTR ep);
void XVTENTRY tx_set_colors(TXEDIT tx, COLOR text, COLOR border, COLOR back);
BOOLEAN XVTENTRY tx_scroll_update(void);
#else
BOOLEAN tx_event();
void tx_set_colors();
BOOLEAN tx_scroll_update();
#endif /* PROTO */

/*
    Additions for run-time dialogs.
*/
#define CTL_FLAG_ENABLED    0x0001
#define CTL_FLAG_CHECKABLE  0x0002
#define CTL_FLAG_CHECKED    0x0004
#define CTL_FLAG_DEFAULT    0x0008
#define CTL_FLAG_VISIBLE    0x0010
#define CTL_FLAG_GROUP      0x0020
#define CTL_FLAG_AUTOPOS    0x0040
#define CTL_FLAG_READONLY   0x0200
#define CTL_FLAG_MULTIPLE   0x0400
#define CTL_FLAG_OPT1       0x0800
#define CTL_FLAG_OPT2       0x1000

typedef enum e_unit_type {U_PIXELS, U_CHARS, U_SEMICHARS} UNIT_TYPE;

#define DEFINED_UNIT_TYPE

/******************************************************/
/**************** ADDITIONS BY PLI ********************/
/******************************************************/

typedef struct _tx_def {
    unsigned short attrib;
    FONT           font;
    short          margin;
    short          limit;
} TX_DEF;

typedef struct _menu_def {
    short      id;
    MENU_ITEM *mip;
} MENU_DEF;

/******************************************************/
/************* END OF ADDITIONS BY PLI ****************/
/******************************************************/

typedef struct s_ctldef {
    WIN_TYPE type;             /* type of dialog or control */
    short id;                  /* ID (-1 for dialog header) */
    short x, y;                /* bounding box upper left coord */
    short width, height;       /* bounding box width and height */
    union {
        char     *text;        /* title, label, text, etc. */
        short     rid;         /* ID for icons, etc. */

/******************************************************/
/**************** ADDITIONS BY PLI ********************/
/******************************************************/

        TX_DEF   *tx_def;      /* structure for text edit control */
        MENU_DEF *menu_def;    /* structure for menubar attached to window */

/******************************************************/
/************* END OF ADDITIONS BY PLI ****************/
/******************************************************/

    } v;
    unsigned short flags;      /* flags (e.g., FLAG_DEFAULT) */
    UNIT_TYPE units;           /* units for bounding box */
} CTL_DEF;    

#ifdef PROTO
BOOLEAN XVTENTRY new_dialog_indirect(WIN_TYPE t, CTL_DEF far *ctldefp, CALLBACK fcn,
  long data);
#else
BOOLEAN XVTENTRY new_dialog_indirect();
#endif /* PROTO */

/*
    Additions for multiple-menu bars.
*/
#define WP_DETACHED    0x0001
#define WP_NO_MENU_BAR 0x0002
#define WP_FLOATING    0x0004
typedef struct {
    struct {
        MENU_ITEM *bar;
        int rid;
    } menu_parms;
    struct {
        short flags;
    } win_parms;
    /* room for expansion */
} WINPARM;

#ifndef NO_MULT_MENU_BAR
#define menu_check(tag, check) win_menu_check(NULL_WIN, (tag), (check))
#define menu_enable(tag, enable) win_menu_enable(NULL_WIN, (tag), (enable))
#define set_font_menu(fontp) win_set_font_menu(NULL_WIN, (fontp))
#define set_menu_text(tag, text) win_set_menu_text(NULL_WIN, (tag), (text))
#define update_menu_bar() win_update_menu_bar(NULL_WIN)
#endif

#ifdef PROTO
void XVTENTRY win_menu_check(WINDOW win, MENU_TAG tag, BOOLEAN check);
void XVTENTRY win_menu_enable(WINDOW win, MENU_TAG tag, BOOLEAN enable);
void XVTENTRY win_set_font_menu(WINDOW win,FONT_PTR fontp);
void XVTENTRY win_set_menu_text(WINDOW win, MENU_TAG tag, STR text);
void XVTENTRY win_update_menu_bar(WINDOW win);
WINDOW XVTENTRY new_window(RCT_PTR grctp, STR title, WIN_TYPE t, BOOLEAN ctl_size, BOOLEAN ctl_vscroll, BOOLEAN ctl_hscroll, BOOLEAN ctl_close);
WINDOW XVTENTRY new_child_window(RCT_PTR rctp, char *title, WIN_TYPE t, BOOLEAN ctl_size,
  BOOLEAN ctl_vscroll, BOOLEAN ctl_hscroll, BOOLEAN ctl_close, WINDOW parent,
  long app_data, short reserve1, WINPARM far *parmp, BOOLEAN visible,
  BOOLEAN enabled);
WINDOW XVTENTRY new_control(RCT *lrctp, char *title, WIN_TYPE t, WINDOW parent, BOOLEAN visible, int id, char *templat);
#else
void XVTENTRY win_menu_check();
void XVTENTRY win_menu_enable();
void XVTENTRY win_set_font_menu();
void XVTENTRY win_set_menu_text();
void XVTENTRY win_update_menu_bar();
WINDOW XVTENTRY new_window();
WINDOW XVTENTRY new_child_window();
WINDOW XVTENTRY new_control();
#endif

/*
    Additions for font mapper.
*/
#define SZ_FONT_REQUEST 4
typedef struct s_font_request {
    unsigned char fr[SZ_FONT_REQUEST];
} FONT_REQUEST;

#define FR_ATTR(f)  ((f).fr[0])
#define FR_SIZE(f)  ((f).fr[1])

#define FR_FAMILY       0x03
#define   FR_SYSTEM     0x00
#define   FR_FIXED      0x01
#define   FR_TIMES      0x02
#define   FR_HELVETICA  0x03
        /* available    0x04 */
#define FR_BOLD         0x08
#define FR_ITALIC       0x10
#define FR_PRINTER      0x20
#define FR_SCALE        0x40
        /* available    0x80 */

#ifdef PROTO
FONT * XVTENTRY select_font(FONT_REQUEST *frp, FONT *fontp);
void  XVTENTRY set_font_request(int attr, int size);
#else
FONT * XVTENTRY select_font();
void XVTENTRY set_font_request();
#endif /* PROTO */

/******************************************************/
/**************** ADDITIONS BY PLI ********************/
/******************************************************/

/*
    Additions for window resources
*/

#define WIN_FLAG_ENABLED    0x0001
#define WIN_FLAG_SIZEBOX    0x0002
#define WIN_FLAG_VSCROLL    0x0004
#define WIN_FLAG_HSCROLL    0x0008
#define WIN_FLAG_VISIBLE    0x0010
#define WIN_FLAG_CLOSEBOX   0x0020
#define WIN_FLAG_DETACHED   0x0040
#define WIN_FLAG_FLOATING   0x0200
#define WIN_FLAG_NOMENU     0x0400

#ifdef PROTO
CTL_DEF far * XVTENTRY get_res_dialog      (int rid, int *nbr_ctls);
CTL_DEF far * XVTENTRY get_res_window      (int rid, int *nbr_ctls);
char    far * XVTENTRY get_res_user        (int wd_id, int ctl_id, int string_nbr, char far *buf);
WINDOW        XVTENTRY new_res_window      (int rid, WINDOW parent, long app_data);
WINDOW        XVTENTRY new_window_indirect (CTL_DEF far *windef, WINDOW parent, long app_data);
int           XVTENTRY size_res_user       (int wd_id, int ctl_id, int string_nbr);
void          XVTENTRY wd_res_free         (CTL_DEF far *ctldef);
#else
CTL_DEF far * XVTENTRY get_res_dialog      ();
CTL_DEF far * XVTENTRY get_res_window      ();
char    far * XVTENTRY get_res_user        ();
WINDOW        XVTENTRY new_res_window      ();
WINDOW        XVTENTRY new_window_indirect ();
int           XVTENTRY size_res_user       ();
void          XVTENTRY wd_res_free         ();
#endif


/******************************************************/
/************* END OF ADDITIONS BY PLI ****************/
/******************************************************/

/******************************************************/
/**************** ADDITIONS BY RGW ********************/
/******************************************************/

/*
    Additions for window resources
*/

#ifdef PROTO
MENU_ITEM * XVTENTRY get_res_menu(int rid);
#else
MENU_ITEM * XVTENTRY get_res_menu();
#endif

/*
	Restore the prototypes that we had to kill above
*/

#ifdef PROTO
WIN_TYPE  XVTENTRY get_dlg_type(WINDOW w);
WIN_TYPE  XVTENTRY get_window_type(WINDOW w);
#else
WIN_TYPE  XVTENTRY get_dlg_type();
WIN_TYPE  XVTENTRY get_window_type();
#endif

/******************************************************/
/************* END OF ADDITIONS BY RGW ****************/
/******************************************************/

#endif /* XVT3H */
