/************************************************************************
 * XVT_CTOS.h                                                           *
 *                                                                      *
 * This include file contains definitions or redefinitions unique to the*
 * CTOS platform.                                                       *
 *                                                                      *
 * Includes globals variables defined in the XVT API.                   *
 *                                                                      *
 *                                                                      *
 ************************************************************************
 */

#ifndef XVT_CTOS_HXX
#define XVT_CTOS_HXX

#if (XVTWS == PMWS)
#if !defined(DG_STYLE_MODAL)
typedef int DLOG;
typedef DLOG * DLOG_PTR;
#endif
#else 
#if (XVTWS == WMWS)
#if !(defined (CTSVR)) && !(defined(CTLIB))
#ifndef DLOG_PTR
#define DLOG_PTR char far *
#endif
#else 
#include "template.h"
#endif
#endif
#endif

#if !defined(OS2DEF_INCLUDED)
typedef void * HAB;
typedef void * HPS;
typedef int WRECT;
#endif

/*
** since CTOS implements XVT as a service for character and
** PM, event_hook and key_hook need to have a common interface.  Our 
** interface is
**
**		BOOLEAN event_hook(int type, EHOOK_STRUCT *ev_hook);
**		BOOLEAN key_hook(int type, KHOOK_STRUCT *k_hook);
**
** where the structures are defined below		
** 
** The files EHook.c and KHook.c contain the code that uses these 
** structures
**
*/
#if !defined(EHOOK_DEFINED)
#define EHOOK_DEFINED
typedef struct {   /* args for event_hook */
  BOOLEAN modal;
  int dlg_rid;
  int ctrl_rid;  /* not used in PM */
  WINDOW win;    /* not used in PM */
  void *event;
} EHOOK_STRUCT;
#endif

/* 3.3 keyboard data */

#if !defined(KBDDATA_DEFINED)
#define KBDDATA_DEFINED
typedef struct {
  UINT wStatus;
  UINT wStatus1;
  UCHAR kbdCode;
  UCHAR sChar;
  UINT chordState;
  ULONG chCode;
} KBD_DATA;
#endif

#if !defined(KHOOK_DEFINED)
#define KHOOK_DEFINED
typedef struct {    
  int rid;			/* PM only args */
  BOOLEAN modal;
  long far *wParamp;
  long far *lParamp;
  int wm_key;		/* CH only args */
  int *vkeyp;
  BOOLEAN *shift;
  BOOLEAN *control;
  KBD_DATA *data;	/* keyboard info */
} KHOOK_STRUCT;
#endif

#define PMHOOK 0
#define CHHOOK 1

/* test against these for npctos_env */

#define CHSERVICE 1
#define PMSERVICE 2

#if !defined(PGLOB_DEFINED)
#define PGLOB_DEFINED

typedef struct {
	HPS hdc;
	WRECT rcPaint;
  } PAINT_STRUCT;

typedef struct {
   APPL_SETUP  *pappl_setup;  /* variable for app to initialize */
   FONT         big_font;     /* bigger-than-normal proportional FONT */
   CPEN         black_cpen;   /* black pen, 1 pixel wide */
   PEN          black_pen;    /* black pen, 1 pixel wide */
   DIRECTORY    default_dir;  /* default directory */
   FONT         fixed_font;   /* fixed_width font */
   MENU_TAG     font_menu_tag;/*special tag for Font/Style menu(s) */
   CPEN         hollow_cpen;  /* hollow pen */
   PEN          hollow_pen;   /* hollow pen */
   FONT         normal_font;  /* normal proportional FONT */
   CPEN         rubber_cpen;  /* rubber-banding pen */
   PEN          rubber_pen;   /* rubber-banding pen */
   FONT         small_font;   /* smaller-than-norm. proportional FONT */
   WINDOW       std_win;      /* app's initial window */
   SYS_METRICS  sys_metrics;  /* system metrics */
   CBRUSH       white_cbrush; /* white brush */
   CPEN         white_cpen;   /* white pen, 1 pixel wide */
   PEN          white_pen;    /* white pen, 1 pixel wide */
   XVTERRNO     xvterrno;     /* error code (partially implemented) */
   int          dbgset;
   int          xvt_tx_caret_offset;
   BOOLEAN      xvt_tx_sel_scroll;

   STR_FAR     *p_npd_list_files_pat;
   BOOLEAN     *p_npd_list_files_brackets;
   BOOLEAN     *p_npd_list_files_drives;
   BOOLEAN     *p_npx_no_menu_bar; /* no menu on window; Motif only */
   BOOLEAN     *p_npc_have_color;  /* CH only */
   DLOG_PTR    *p_npc_dlg_template; /* CH only */
   BOOLEAN	   *p_npw_edit_focus;
   long        *p_npw_lParam;			/* lParam from control notification */
   STR_FAR     *p_npw_dlg_template;		/* for indirect dialog box creation */
   HAB         *p_npw_hInstance;
   STR_FAR     *p_npw_cmdline;			/* ptr to cmdline for app's use */
   PAINT_STRUCT *p_npw_paintstruct;
   BOOLEAN     *p_npw_popup;
   unsigned	   *p_npctos_env;
  } GlobType;


CXX_PASCAL_BEGIN
extern GlobType *pglob;
CXX_PASCAL_END

#undef   big_font			
#define  big_font			(pglob->big_font)
#undef   black_cpen			
#define  black_cpen			(pglob->black_cpen)
#undef   black_pen			
#define  black_pen			(pglob->black_pen)
#undef   default_dir		
#define  default_dir		(pglob->default_dir)
#undef   fixed_font			
#define  fixed_font			(pglob->fixed_font)
#undef   font_menu_tag		
#define  font_menu_tag		(pglob->font_menu_tag)
#undef   hollow_cpen		
#define  hollow_cpen		(pglob->hollow_cpen)
#undef   hollow_pen			
#define  hollow_pen			(pglob->hollow_pen)
#undef   normal_font		
#define  normal_font		(pglob->normal_font)
#undef   npx_no_menu_bar	
#define  npx_no_menu_bar	(pglob->npx_no_menu_bar)
#undef   rubber_cpen		
#define  rubber_cpen		(pglob->rubber_cpen)
#undef   rubber_pen			
#define  rubber_pen			(pglob->rubber_pen)
#undef   small_font			
#define  small_font			(pglob->small_font)
#undef   std_win			
#define  std_win			(pglob->std_win)
#undef   sys_metrics		
#define  sys_metrics		(pglob->sys_metrics)
#undef   white_cbrush		
#define  white_cbrush		(pglob->white_cbrush)
#undef   white_cpen			
#define  white_cpen			(pglob->white_cpen)
#undef   white_pen			
#define  white_pen			(pglob->white_pen)
#undef   xvterrno			
#define  xvterrno			(pglob->xvterrno)
#undef   dbgset                   
#define  dbgset             (pglob->dbgset)
#undef   xvt_tx_caret_offset                   
#define  xvt_tx_caret_offset      (pglob->xvt_tx_caret_offset)
#undef   xvt_tx_sel_scroll                   
#define  xvt_tx_sel_scroll  (pglob->xvt_tx_sel_scroll)

#undef   npd_list_files_pat       
#define  npd_list_files_pat       (*pglob->p_npd_list_files_pat)
#undef   npd_list_files_brackets  
#define  npd_list_files_brackets  (*pglob->p_npd_list_files_brackets)
#undef   npd_list_files_drives    
#define  npd_list_files_drives    (*pglob->p_npd_list_files_drives)
#undef   npx_no_menu_bar          
#define  npx_no_menu_bar          (*pglob->p_npx_no_menu_bar)
#undef   npc_have_color           
#define  npc_have_color           (*pglob->p_npc_have_color)
#undef   npc_dlg_template         
#define  npc_dlg_template         (*pglob->p_npc_dlg_template)
#undef   npw_lParam               
#define  npw_lParam               (*pglob->p_npw_lParam)
#undef   npw_dlg_template         
#define  npw_dlg_template         (*pglob->p_npw_dlg_template)
#undef   npw_edit_focus         
#define  npw_edit_focus           (*pglob->p_npw_edit_focus)
#undef   npw_hInstance            
#define  npw_hInstance            (*pglob->p_npw_hInstance)
#undef   npw_cmdline              
#define  npw_cmdline              (*pglob->p_npw_cmdline)
#undef   npw_paintstruct          
#define  npw_paintstruct          (*pglob->p_npw_paintstruct)
#undef   npw_popup                
#define  npw_popup                (*pglob->p_npw_popup)
#undef   npctos_env
#define  npctos_env               (*pglob->p_npctos_env)

#endif /* PGLOB_DEFINED */
#endif /* XVT_CTOS_HXX */
