#ifndef _BTOS_TYPES_H_INCL
#define _BTOS_TYPES_H_INCL

typedef unsigned short int	Address;
typedef unsigned char		Byte;
typedef unsigned short int	DirectionType;
typedef unsigned long int	DWord;
typedef void *			Pointer;
typedef unsigned short int	Selector;
typedef unsigned short int	Word;

#define	offsetof(X)		(((Word *)&(X))[0])
#define	selectorof(X)		(((Word *)&(X))[1])

#if defined(Syscom) || defined(All)
#undef Syscom
#define ATpSysTime 0x240
#define ATpVcb 0x244
#define ATpCdt 0x244
#define ATpRgSysError 0x248
#define ATpOPcbRun 0x24C
#define ATpParamBlk 0x250 
#define ATpVersionNo 0x254
#define ATpIvWord 0x258
#define ATpDSWord 0x25C
#define ATpComIntRet 0x260
#define ATpMsgWaitCount 0x264
#define ATpMsgWaitFree 0x268
#define ATpMsgWaitReserve 0x26C
#define ATpRgInfoIKey 0x270
#define ATpORgExchg 0x274
#define ATpORgMsgWait 0x278
#define ATpORgODcb 0x27C
#define ATpORgOFcb 0x280
#define ATpORgOUcb 0x284
#define ATpORgOVhb 0x288
#define ATpORgPcb 0x28C
#define ATpORgPTiming 0x290
#define ATpRgRqExchgSys 0x294
#define ATpRgRqExchgusr 0x298
#define ATpRunQ 0x29C
#define ATpSaSemiHighest 0x2A0
#define ATpSaSemiLowest 0x2A4
#define ATpSaTempHighest 0x2A8
#define ATpSaTempLowest 0x2AC
#define ATpSaEndMemory 0x2B0
#define ATpBootBlock 0x2B4
#define ATpBootDevName 0x2B8
#define ATpCrashFileDevName 0x2BC
#define ATpHdcCntlBlk 0x2C0
#define ATpFloppyCntlBlk 0x2C4
#define ATpConfiguration 0x2C8
#define ATpIoErrorLog 0x2CC
#define ATpPerformance 0x2D0
#define ATpSysDeviceNum 0x2D4
#define ATpRgLocalServiceCodeSys 0x2D8
#define ATpRgLocalServiceCodeUsr 0x2DC
#define ATpContingencyLog 0x2E0
#define AtpExtCntlRegAws 0x2E4
#define ATpGraphicsPort 0x2E8
#define ATpFontRamBuf 0x2EC
#define ATpHdwState 0x2F0
#endif

#if defined(Syslit) || defined(All)
#undef Syslit
typedef unsigned long int		DateTimeType;
typedef unsigned short int		ModeType;
typedef unsigned short int		Offset;
#ifndef __ERCTYPE
typedef unsigned short int		ErcType;
#endif
typedef unsigned short int		ExchType;
typedef unsigned short int		FhType;
typedef unsigned char			Flag;
typedef unsigned char			FlagType;
typedef unsigned long int		LfaType;
typedef unsigned short int		ProcessType;
typedef unsigned long int		Quad;
typedef unsigned long int		QuadType;
typedef unsigned short int		Segment;

typedef struct {
	Word		ra;
	Word		sa;
	}		POINTERWords;

typedef struct {
	Word		low;
	Word		high;
	}		QUADWords;

#define ercOK				0
#ifndef _BOOLEAN_DEFINED
typedef short BOOLEAN;          /* Boolean type */
#define FALSE				(0==1)
#define TRUE				(0==0)
#define _BOOLEAN_DEFINED
#endif
#define FOREVER				while (1)
#define lastWdPg			255
#define magic				0x7C39
#define modeAppend			0x6D61
#define modeModify			0x6D6D
#define modeRead			0x6D72
#define modeWrite			0x6D77
#define ONES				0xFFFF
#define pageSize			512
#define wdsPerPg			256
#endif

#if defined(Sublit) || defined(All)
#undef Sublit
#define compareMatch			0xFFFF
#define NIL				0x0
#define notFound			0xFFFF
#define sdType
#endif

#if defined(ParDescType) || defined(All)
#undef ParDescType
typedef struct {
	Offset		oForwardLink;
	Offset		oBackwardLink;
	Segment		saLowBound;
	Segment		saMinLL;
	Segment		saCurLL;
	Segment		saCurSL;
	Segment		saMaxSL;
	Segment		saHighBound;
	Byte		sbPartitionName[13];
	FlagType	fPartitionVacant;
	FlagType	fPartitionLocked;
	ExchType	PartitionExch;
	FlagType	fBatchPartition;
	FlagType	fCCB;
	Byte		filler;
	Word		cparCreated;
	Segment		saMinCode;
	Segment		saMaxCode;
	}	ParDescType;
#define		sParDesc	sizeof(ParDescType)
#endif

#if defined(GetpStructureCase) || defined(All)
#undef GetpStructureCase
/* GetpStructure wCase values */

#define lGetpExParDesc 0
#define lGetpCharMap 1
#define lGetpVCB 2
#define lGetpAscb 3
#define lGetpVLPB 4
#define lGetpBcb 5
#define lGetpTypeAhead 6
#define lGetpRgpVidMemLine 7
#define lGetpRgLineMap 8
#define lGetpContextStatus 9
#define lGetpRgUserReadCount 10
#define lGetpRgpDebug 11
#define lGetpGraphicsInfo 12
#define lGetpEcb 13
#define lGetpNGenPortStructure 14
#define lGetpNGenPortsStructure 14
#define lGetpUserNum 15
#define lGetpUserNumVid 15
#define lGetpOsSubTable 16
#define lGetpSystemCommonTable 16
#define lGetpIBusIDTable 17
#define lGetpKernelJumpTable 18
#define lGetprgprgRqExch 19
#define lGetprgprcLookup 20
#define lGetprgprcLookupBase 21
#define lGetprgRcMax 22
#define lGetprgprgLSC 23
#define lGetprgprgNetRouting 24
#define lGetpNlsTables 25
#define lGetpScreenMap 26
#define lGetpScreenStuff 26
#define lGetpCdt 27
#define lGetpEncryptionKey 29
#define lGetprgVidMemLineReal 32
#define lGetpIntSwTbl 33
#define lGetpDiskStat 34
#define lGetpStat 35
#define lGetpSbScratchVolumeSpec 36
#define lGetpVf 38
#define lGetpVideoConfig 39
#define lGetprgprgRouting 40
#endif

#if defined(PcbType) || defined(All)
#undef PcbType
typedef struct {
	Address		oPcbLnk;
	Byte		status;
	Byte		priority;
	Word		spSave;
	Word		ssSave;
	Pointer		msgRetAddr;
	Word		exchgSync;
	Word		userNum;
	Word		oExPcb;
	}	PcbType;

#define pcbSize		sizeof(PcbType)

/************************
#define fSys 		0x40
****************************/
#define pcbUsed		0x80
#define suspend		0x02
#define swapped		0x04
#endif

#if defined(FhbType) || defined(All)
#undef FhbType
/***** define the fhb structure */
#define sFhb 512
#define runsPerFhb 32
#define fhLongLive 1
#define fhShortLive 0
#define	lDosMagic  0x57

typedef	struct	{
	Word			checksum;
	Word			fileHeaderPageNum;
	Byte			fileName[51];
	Byte			password[13];
	Byte			dirName[13];
	Word			fileHeaderNum;
	Word			extensionHeaderNumChain;
	Byte			headerSequenceNum;
	Byte			fileClass;
	Byte			accessProtection;
	LfaType			dirPageLfa;
	DateTimeType		creationDT;
	DateTimeType		modificationDT;
	DateTimeType		accessDT;
	DateTimeType		expirationDT;
	Flag			fNoSave;
	Flag			fNoDirPrint;
	Flag			fNoDelete;
	LfaType			endOfFileLfa;
	LfaType			defaultExpansion;
	Word			freeRunIndex;
	LfaType			vda[runsPerFhb];
	LfaType			runLength[runsPerFhb];
	Word			userObjectType;
	Byte			rgbDistrix[62];
	Byte			fReadOnly;
	Byte			bDosMagic;
	Byte			bDosAttribute;
	Word			parentFhbNum;
	Byte			cLink;
	Byte			ObjectType;
	Byte			application[64];
	} FhbType;
#endif

#if defined(ProcDescType) || defined(All)
#undef ProcDescType
typedef struct {
	void 		(*(pEntry))(void);
	Word		saData;
	Word		saExtra;
	Word		saStack;
	Word		oStackInit;
	Byte		priority;
	Byte		fSys;
	Word		exchgDefaultResponse;
	Byte		fDebug;
		}	ProcDescType;

#define		procInitSuspend		1
#define		procInitReady		0
#define		procOs			1
#define		procSubsys		0
#define		priorityUser		0x80
#endif

#if defined(CdtType) || defined(All)
#undef CdtType

#define cpuID Byte
#define cBusConfigTableEnts 240
#define sReqRespEnt 5
#define cFPcount 8
#define cFillSize 77
#define nLevels 17
#define nullCpuId 0xF0

/* Function code values (bBootCommand field) */
#define fRunning 0
#define fBootMe 1
#define fDumpThenBoot 2
#define fDumpThenError 3
#define fDumpThenInterrupt 4
#define fFailedDiagnostics 0xF0
#define fRunningDiagnostics 0xF1
#define fStopInteractiveDiag 0xF2
#define bFpType 10
#define bTpType 11
#define bCpType 12
#define bSpType 13
#define bDpType 14
#define bRpType 15

#define bMinXp bFptype
#define bMaxXp 19

#define bApType 0x40
#define bAp2Type 0x41
#define bBrType 0xFF

#define rLocal 0xF0
#define rRemote 0xF1
#define rMasterFp 0xF2
#define rHandle 0xF3
#define rFileId 0xF4
#define rMasterCp 0xF5
#define rLineNumber 0xF6

typedef struct { Word oOffset; Word cNumberEntries} TableType;
typedef struct {
Byte filler0 [8];
Byte bProcessorType;
Byte fWatchDog;
Word ibRequestTakePtr;
Word ibRequestPutPtr;
Word ibRequestStartPtr;
Word ibRequestEndPtr;
Word ibResponseTakePtr;
Word ibResponsePutPtr;
Word ibResponseStartPtr;
Word ibResponseEndPtr;
Byte fLockByte;
Byte bInitErrorStatus;
Byte bMemorySize;
Byte bBootStructFF;
Byte bBootStruct0;
Byte bBootStructA6;
Byte bBootCommand;
cpuID bMasterFP;
FlagType fOsInitialized;
Byte fCdtIO;
Word oStatArea;
Word sStatArea;
Byte rgbFPXlate [cFPcount];
Byte rgbBusConfigTable [cBusConfigTableEnts];
Word nUserNumber;
Byte bTTIStatus;
Byte bTTIData;
Byte bTTOStatus;
Byte bTTOData;
Word wPanelStatus;
Byte bFrontPanel;
Byte fDegraded;
Byte fMasterReady;
FlagType fDisCls;
Word wCpWho;
Word WCpTimer;
Byte verifycode;
Byte filler1 [cFillSize];
/* Following extension of this structure is master FP specific */
Word nDevMounted;
Pointer pMasterMountTable;
Word oTermTable;
Word sTermTable;
Word oLineTable;
Word sLineTable;
Word oRqRoute [nLevels];
Word sRqRoute [nLevels];
} CdtType;
#endif

#if defined(RqHeaderType) || defined(All)
#undef RqHeaderType
typedef struct {
	char 	*pb;
	Word	cb;
	}	PbCbType;

typedef struct {
	Byte sCntInfo;
	Byte RtCode;
	Byte nReqPbCb;
	Byte nRespPbCb;
	Word userNum;
	Word exchResp;
	Word ercRet;
	Word rqCode;
	}		RqHeaderType;
#endif

#if defined(rqInfoType) || defined(All)
#undef rqInfoType
typedef struct	{
		Word exch;
		Word lsc;
		} rqInfoType;
#endif

#if defined(sbType) || defined(All)
#undef sbType
typedef struct {
	Byte cb;
	char rg[255];
	}	sbType;
#endif

#if defined(sdType) || defined(All)
#undef sdType
typedef struct {
	char 		*pb;
	Word		cb;
	}		sdType;
#endif

#if defined(SysConfigType)
#undef SysConfigType
#define sSysConfig		48
typedef struct {
	Byte		SystemBuildType;
	Byte		OsType;
	Word		SaMinLL;
	Word		SaCurrLL;
	Word		SaCurrSL;
	Word		SaMaxSL;
	Word		SaMemMax;
	Word		cPcb;
	Word		cExch;
	Word		cLinkBlk;
	Word		cLinkBlkRes;
	Word		cTrb;
	Word		cIob;
	Word		cFcb;
	Word		cVhb;
	Word		cUcb;
	Word		cUfb;
	Byte		HardwareType;
	Byte		ClusterConfiguration;
	Byte		fNoFileSystem;
	Byte		fCommIOP;
	Byte		fMultipartition;
	Byte		reserved;
	Word		nParDesc;
	Word		oRgUcb;
	Word		oRgOExUcb;
	Word		userNumVid;
		}	SysConfigType;
#endif

#if defined(TRBType) || defined(All)
#undef TRBType
typedef struct
{
 Word counter,counterReload,cEvents,exchResp,ercRet,rqCode;
} TRBType;
#define sTRB sizeof(TRBType)
#endif

#if defined(VHBType) || defined(All)
#undef VHBType
typedef struct	{
	Byte	cb;
	char	rg[12];
	} VHBsbType;
typedef	struct	{
	Word		checksum;
	DWord		lfaSysImageBase;
	Word		cPagesSysImage;
	DWord		lfaBadBlkBase;
	Word		cPagesBadBlk;
	DWord		lfaCrashDumpBase;
	Word		cPagesCrashDump;
	VHBsbType	sbVolName;
	VHBsbType	sbPassword;
	DWord		lfaVhb;
	DWord		lfaInitialVhb;
	DWord		creationDT;
	DWord		modificationDT;
	DWord		lfaMfdBase;
	Word		cPagesMfd;
	DWord		lfaLogBase;
	Word		cPageLog;
	Word		currentLogPage;
	Word		currentLogByte;
	DWord		lfaFileHeadersBase;
	Word		cPagesFileHeader;
	Word		altFileHeaderPageOffset;
	Word		iFreeFileHeader;
	Word		cFreeFileHeaders;
	Word		clusterFactor;
	Word		defaultExtend;
	Word		allocSkipCnt;
	DWord		lfaAllocBase;
	Word		allocPageCnt;
	Word		lastAllocPg;
	Word		lastAllocWd;
	Word		lastAllocBit;
	DWord		cFreePages;
	Word		idev;
	char		rgLruDirEntries[105];
	Word		magicWd;
	Byte		BootBaseSector;
	Byte		BootBaseHead;
	Word		BootBaseCyl;
	Word		BootMaxPageCount;
	Byte		BadBlkBaseSector;
	Byte		BadBlkBaseHead;
	Word		BadBlkBaseCyl;
	Word		BadBlkMaxPgCnt;
	Byte		DumpBaseSector;
	Byte		DumpBaseHead;
	Word		DumpBaseCyl;
	Word		DumpMaxPageCount;
	Word		bytesPerSector;
	Word		sectorsPerTrack;
	Word		tracksPerCyl;
	Word		cylindersPerDisk;
	union		{
				struct {
					Byte	verifyCode;
					Word	sectorSize;
					Byte	spiralFactor;
					Byte	startingSector;
					Byte	interleaveFactor;
					char	vendorCode[3];
				} WorkStation;
					Byte	seekStepRate;
					Byte	gapSize;
					Byte	writePrecompCyl;
					Byte	devType;
					Byte	trackSeekTime;
					Byte	settleTime;
					Byte	verifyCodep;
				struct {
					Byte	junk;
				} SRP;
			}s;
} VHBType;
#endif

#if defined(UCBType) || defined(All)
#undef UCBType
typedef	struct	{
	char	reserved[2];
	Byte	cbVol;
	char	rgbVol[12];
	Byte	cbDir;
	char	rgbDir[12];
	Byte	cbPswd;
	char	rgbPswd[12];
	Byte	cbPrefix;
	char	rgbPrefix[40];
	Byte	cbNode;
	char	rgbNode[12];
	} UCBType;
#endif

#endif
