;******************************* MODULE HEADER *******************************;
;*                                                                           *;
;* FILE: WpCnfgH.asm                                                         *;
;*                                                                           *;
;* MACHINE: B20        LANGUAGE: ASSEMBLER  OS: BTOS                         *;
;*                                                                           *;
;* DESCRIPTION:        General help menus for the Editor                     *;
;*                                                                           *;
;* HISTORY:                                                                  *;
;*                                                                           *;
;* MM/DD/YY VVVV/MM PROGRAMMER   / DESCRIPTION OF CHANGE (Most recent first) *;
;*                                                                           *;
;* 01/25/90 120F/03 T. Ball      / More Pubs changes                         *;
;* 01/16/90 120F/02 T. Ball      / Standardized capitalized per Pubs         *;
;* 08/25/89 120C/01 T. Ball      / Fixed typo in Misc Cmds menu text         *;
;*                                                                           *;
;* TITLE:  BTOS SYSTEM SOFTWARE                                              *;
;*                                                                           *;
;*            PROPRIETARY PROGRAM MATERIAL                                   *;
;*                                                                           *;
;* THIS MATERIAL IS PROPRIETARY TO UNISYS CORPORATION AND IS NOT TO BE       *;
;* REPRODUCED, USED OR DISCLOSED EXCEPT IN ACCORDANCE WITH PROGRAM LICENSE   *;
;* OR UPON WRITTEN AUTHORIZATION OF THE PATENT DIVISION OF UNISYS            *;
;* CORPORATION, DETROIT, MICHIGAN 48232, USA.                                *;
;*                                                                           *;
;* COPYRIGHT (C) 1980, 1989 CONVERGENT TECHNOLOGIES INC. ALL RIGHTS RESERVED *;
;* COPYRIGHT (C) 1980, 1989 UNISYS CORPORATION. ALL RIGHTS RESERVED          *;
;* ************************************************************************* *;
;*                                                                           *;
;* UNISYS BELIEVES THAT THE SOFTWARE FURNISHED HEREWITH IS ACCURATE AND      *;
;* RELIABLE, AND MUCH CARE HAS BEEN TAKEN IN ITS PREPARATION.  HOWEVER,      *;
;* NO RESPONSIBILITY, FINANCIAL OR OTHERWISE, CAN BE ACCEPTED FOR ANY        *;
;* CONSEQUENCES ARISING OUT OF THE USE OF THIS MATERIAL, INCLUDING LOSS OF   *;
;* PROFIT, INDIRECT, SPECIAL, OR CONSEQUENTIAL DAMAGES, THERE ARE NO         *;
;* WARRANTIES WHICH EXTEND BEYOND THE PROGRAM SPECIFICATION.                 *;
;*                                                                           *;
;* THE CUSTOMER SHOULD EXERCISE CARE TO ASSURE THAT USE OF THE SOFTWARE      *;
;* WILL BE IN FULL COMPLIANCE WITH LAWS, RULES AND REGULATIONS OF THE        *;
;* JURISDICTIONS WITH RESPECT TO WHICH IT IS USED.                           *;
;*                                                                           *;
;*                                                                           *;
;*************************** END OF MODULE HEADER ****************************;

; WpCnfgH.asm -- general help menus

$include(WpKbd.mdf)
$include(WpCmid.mdf)
$include(WpCmdd.mdf)
$include(WpMsg.mdf)
$include(WpCnfg.mdf)


extrn cmidWindowsHelp: abs
extrn cmidDocumentsHelp: abs

DGroup group CmidSeg, CmddSeg, MenuSeg
assume ds: DGroup


%DefineMenu(cmidDspHelpKeys, iCmrDisplayHelpMenu, false, 5,
~ FUNCTION KEYS ~,
~|(Press CANCEL to dismiss, HELP for more help)|
|
|FileCmdDiscard       | |Convert                     | |Mrk Blk       MrkFile
LstEdit              | |              Replace Color | |       Mrk EOLMrk EOF
 Redo   Undo  BlkChk | |Windows       Search Default| |MrkWordMrkLine       
~,
~
<idParTitle>
	<idMsg, typSysBlank>
	<idMsg>
<idParHelp>
	<idNil, typProtected or maskfRev or maskfHb>
	<>
	<idNil, typProtected or maskfRev or maskfHb>
	<>
	<idNil, typProtected or maskfRev or maskfHb>
	<>
	<idNil, typProtected or maskfRev or maskfHb>
	<>
	<idNil, typProtected or maskfRev or maskfHb>
	<>
	<idNil, typProtected or maskfRev or maskfHb>
	<>
	<idNil, typProtected or maskfRev or maskfHb>
	<>
	<idNil, typProtected or maskfRev or maskfHb>
	<>
	<idNil, typProtected or maskfRev or maskfHb>
	<>
~,
~
<chHelp, cmidDspHelp>
~)%'


%DefineMenu(cmidDspHelp, iCmrDisplayHelpMenu, true, 8,
~ HELP ~,
~|(Press CANCEL to dismiss, HELP to display function keys)|
|
| |

Press G for General commands       Press F for File commands
      E     Editing commands             S     Selection commands
      W     Window commands              C     Cursor commands
      M     Miscellaneous commands       K     Keyboard quick reference
~,
~
<idParTitle>
	<idMsg,	typSysBlank>
	<idMsg>
<idParPlace>
	<1>				(version string)
<idParNoise>
~,
~
<'g', cmidGeneralHelp>
<'e', cmidEditHelp>
<'w', cmidWindowsHelp>
<'f', cmidDocumentsHelp>
<'s', cmidSelectHelp>
<'k', cmidKbdHelp>
<'c', cmidCursorHelp>
<'m', cmidMiscHelp>
~)%'


%DefineMenu(cmidGeneralHelp, iCmrDisplayHelpMenu, true, 22,
~ GENERAL COMMANDS HELP ~,
~|(Press CANCEL to dismiss, HELP for more help)|
|
|Command|	|Keystroke|	|Description|

Delete Menu Line	CODE-DELETE	Clears menu line.

Display Colors	SHIFT-F7	Displays and changes current color display
		(for workstations with color displays only).

File Commands	CODE-F1	Opens, copies, renames, deletes files;
		changes default path; lists directory files, 
		volume directories, and opened files.

Finish	FINISH	Finishes an editing session by saving
		all the edits and closing all the files.

Help	HELP	Displays these lists of commands and 
		keystrokes.

Redo	F1	Repeats the last command.

Save	CODE-S	Saves all the edits made during a word
		processing session without closing the 
		current files.

Undo	F2	Undoes the last editing operation.

Window Commands	F4	Sets full or tiled window display; divides,
	CODE-GO	closes, and moves to the previous or next 
		window.
~,
~
<idParTitle>
	<idMsg, typSysBlank>
	<idParPlace>
<idParHelp>
	<idNil, typProtected or maskfUl>
	<>
	<idNil, typProtected or maskfUl>
	<>
	<idNil, typProtected or maskfUl>
	<>
~,
~
<chHelp, cmidDspHelp>
~)%'



%DefineMenu(cmidEditHelp, iCmrDisplayHelpMenu, true, 22,
~ EDIT COMMANDS HELP ~,
~|(Press CANCEL to dismiss, HELP for more help)|
|
|Command|	|Keystroke|	|Description|

Back Word	CODE-BACKSPACE	Moves the cursor to the beginning of the
	CODE-W	previous word.  In Insert mode the word is
		deleted, but not in Overtype mode.

Copy	COPY	Copies selected text from one location to
		the location at the cursor position.

Delete	DELETE	Deletes a single character or a block of
		selected characters.

Discard	CODE-U	Discards all edits made in the current
	CODE-F2	file since the last Finish or Save.

Insert	CODE-I	Inserts hexadecimal character(s) in the text.
Hexadecimal

Insert	CODE-Quote	Inserts literal character(s) in the text.
Literal

Insert	CODE-TAB	Inserts a tab without moving the cursor.
Tab

Lowercase	CODE-[	Converts the selected text to lowercase.

Move	MOVE	Moves selected text to the cursor position 
		and deletes the text from its original 
		location.

Replace	SHIFT-F6	Replaces old text with new text.

Search	F6	Searches through a file for specific text.

Spaced Tabs	SHIFT-TAB	Inserts spaces from the cursor position
		to the next tab stop.

Uppercase	CODE-]	Converts the selected text to uppercase.
~,
~
<idParTitle>
	<idMsg, typSysBlank>
	<idParPlace>
<idParHelp>
	<idNil, typProtected or maskfUl>
	<>
	<idNil, typProtected or maskfUl>
	<>
	<idNil, typProtected or maskfUl>
	<>
~,
~
<chHelp, cmidDspHelp>
~)%'


%DefineMenu(cmidSelectHelp, iCmrDisplayHelpMenu, true, 22,
~ SELECTION COMMANDS HELP ~,
~|(Press CANCEL to dismiss, HELP for more help)|
|
|Command|	|Keystroke|	|Description|

Bound	BOUND	Moves the cursor and extends the selection
		to include another character, word, or line.
		See Mark, Mark Word, and Mark Line.

Locate	CODE-L	Moves the cursor or the selection to the
		center of the current window.

Mark	MARK	Selects and highlights the character at the
		cursor position.

Mark Block	CODE-F8	Selects and highlights from the beginning of
		a block to its end.  If a block is nested,
		subsequent Mark Blocks highlight succeeding
		outer blocks.

Mark to 	SHIFT-F10	Selects and highlights from the current cur-
End of File		sor position to the end of the file.

Mark to 	SHIFT-F9	Selects and highlights from the current cur-
End of Line		sor position to the end of the current line.

Mark File	CODE-F10	Selects and highlights the entire file in
		which the cursor is positioned.

Mark Line	F9	Selects and highlights the line in which the
		cursor is positioned.

Mark Word	F8	Selects and highlights the word in which the
		cursor is positioned.
~,
~
<idParTitle>
	<idMsg, typSysBlank>
	<idParPlace>
<idParHelp>
	<idNil, typProtected or maskfUl>
	<>
	<idNil, typProtected or maskfUl>
	<>
	<idNil, typProtected or maskfUl>
	<>
~,
~
<chHelp, cmidDspHelp>
~)%'


%DefineMenu(cmidKbdHelp, iCmrDisplayHelpMenu, true, 22,
~ KEYBOARD QUICK REFERENCE ~,
~|(Press CANCEL to dismiss, HELP for more help)|
|
The keyboard commands are listed below.  The left column lists each key.  The
second column contains the keystroke when the key is pressed alone.  The third
column contains the keystroke when the key is pressed with the SHIFT key.  The
fourth column contains the keystroke when the key is pressed with the CODE key.
The last column contains the keystroke when the key is pressed with both the
CODE and SHIFT keys.  If a column entry is blank, it means that no command
exists for that key combination.

|Key|	|Unshifted|	|SHIFT|	|CODE|	|CODE/SHIFT|

B			Go to Beginning
C			Close Window	Copy File
D			Divide Window	Delete File
E			Go to End	Mark File
F			Search	List Open Files
G			Go to Line	Go to Line
H			Display Hex
I			Insert Hex
L			Locate	List Files
N			Current Line	Character Count
O			Open File	Open File
P				Set Path
R				Rename File
S			Save
T			Display Time
U			Discard Changes
V			Visible	Volume Status
W			Back Word
Z			Zoom

|Key|	|Unshifted|	|SHIFT|	|CODE|	|CODE/SHIFT|

F1	Redo	Goto Last Point	File Commands
F2	Undo		Discard Changes
F3	Block Check
F4	Window Commands		Convert
F5
F6	Search	Replace
F7	Set Defaults	Set Colors
F8	Mark Word		Mark Block
F9	Mark Line	Mark to Line End
F10		Mark to File End	Mark File

BACKSPACE	Backspace	Backspace	Back Word
TAB	Tab	Space Tab	Insert Tab
RETURN	New Line	Forced New Line
Quote			Insert Literal	Insert Literal
^, 1 - 10			Thumb
[			Make Lowercase
]			Make Uppercase

|Key|	|Unshifted|	|SHIFT|	|CODE|	|CODE/SHIFT|

NEXT PAGE	Next Screen	Next Form Feed	Form Feed
PREV PAGE	Prev Screen	Prev Form Feed	Prev Screen
SCROLL UP	Scroll Up	Prev Screen	Prev Screen
SCROLL DOWN	Scroll Down	Next Screen	Next Screen
CANCEL	Cancel
HELP	Function Keys	Display Help	Display Help	Display Help
FINISH	Finish
MOVE	Move		Set Move Place
DELETE	Delete		Clear Field
OVERTYPE	Toggle OverType	Toggle OverType	Toggle OverType
COPY	Copy		Set Copy Place

Up Arrow	Cursor Up	Cursor Up Three	Top Of Window
Left Arrow	Cursor Left	Cursor Left Five
Right Arrow	Cursor Right	Cursor Rt Five
Down Arrow	Cursor Down	Cursor Dn Three	Top of Next Wnd
MARK	Mark Char	Unmark	Unmark
BOUND	Bound
GO	Go		Window Commands
Numeric Key -			Prev Window
NEXT	Next		Next Window
~,
~
<idParTitle>
	<idMsg, typSysBlank>
	<idParPlace>
<idParKbdHelp>
	<idNil, typProtected or maskfUl>
	<>
	<idNil, typProtected or maskfUl>
	<>
	<idNil, typProtected or maskfUl>
	<>
	<idNil, typProtected or maskfUl>
	<>
	<idNil, typProtected or maskfUl>
	<>
	<idNil, typProtected or maskfUl>
	<>
	<idNil, typProtected or maskfUl>
	<>
	<idNil, typProtected or maskfUl>
	<>
	<idNil, typProtected or maskfUl>
	<>
	<idNil, typProtected or maskfUl>
	<>
	<idNil, typProtected or maskfUl>
	<>
	<idNil, typProtected or maskfUl>
	<>
	<idNil, typProtected or maskfUl>
	<>
	<idNil, typProtected or maskfUl>
	<>
	<idNil, typProtected or maskfUl>
	<>
	<idNil, typProtected or maskfUl>
	<>
	<idNil, typProtected or maskfUl>
	<>
	<idNil, typProtected or maskfUl>
	<>
~,
~
<chHelp, cmidDspHelp>
~)%'


%DefineMenu(cmidCursorHelp, iCmrDisplayHelpMenu, true, 22,
~ CURSOR COMMANDS HELP ~,
~|(Press CANCEL to dismiss, HELP for more help)|
|
|Command|	|Keystroke|	|Description|

Back Word	CODE-BACKSPACE	Moves the cursor to the beginning of the
	CODE-W	previous word.  In Insert mode the word is
		deleted, but not in Overtype mode.

Fast Cursor	SHIFT-Arrows	When shifted, the left and right cursor keys
		move five positions; the up and down	keys 
		move three lines.

Go to	CODE-B	Moves the cursor to the beginning of the
Beginning		file.

Go to Bottom	CODE-	Moves the cursor to the bottom of the current
of Window	Down Arrow	window.

Go to End	CODE-E	Moves the cursor to the end of the file.

Go to	CODE-	Moves the cursor to the right of the last
End of Line	Right Arrow	character of the current line.

Go to 	SHIFT-F1	Moves the cursor to the last point at
Previous Edit		which you edited or altered text.  Pressing
		SHIFT-F1 repeatedly recalls previous edits
		in succession.

Go to 	CODE-G	Moves the cursor to the specified line.
Source Line	CODE-SHIFT-G

Go to	CODE-	Moves the cursor to the beginning of the
Start of line	Left Arrow	current line.

Go to	CODE-	Moves the cursor to the top of the current
Top of Window	Up Arrow	window.

Locate	CODE-L	Moves the beginning of a selection, or the 
		cursor if nothing is selected, to the center
		of the current window.

Search	F6	Searches through a file for specific text.

Thumb	CODE-digit	Moves the cursor directly to a specific
		percentage position in a file.
~,
~
<idParTitle>
	<idMsg, typSysBlank>
	<idParPlace>
<idParHelp>
	<idNil, typProtected or maskfUl>
	<>
	<idNil, typProtected or maskfUl>
	<>
	<idNil, typProtected or maskfUl>
	<>
~,
~
<chHelp, cmidDspHelp>
~)%'


%DefineMenu(cmidMiscHelp, iCmrDisplayHelpMenu, true, 22,
~ MISCELLANEOUS COMMANDS HELP ~,
~|(Press CANCEL to dismiss, HELP for more help)|
|
|Command|	|Keystroke|	|Description|

Block Check	F3	Checks that beginning and ending characters
		used in block-structured programs match.

Character Count	CODE-SHIFT-N	Displays the number of characters in
		a selection or file.

Current Line	CODE-N	Displays line number of current place in
		file.

Discard	CODE-U	Discards all edits made in the current
	CODE-F2	file since the last Finish or Save.

Display	CODE-H	Displays the window contents as hexadecimal
Hexadecimal		values and ASCII.  In the hexadecimal portion
		of the display, new values can be entered to
		overwrite the existing text.  All normal
		editing operations can be used in the ASCII
		portion of the display.

Set Defaults	F7	Allows changing of several Editor
		defaults.

Time	CODE-T	Displays the system date/time.
~,
~
<idParTitle>
	<idMsg, typSysBlank>
	<idParPlace>
<idParHelp>
	<idNil, typProtected or maskfUl>
	<>
	<idNil, typProtected or maskfUl>
	<>
	<idNil, typProtected or maskfUl>
	<>
~,
~
<chHelp, cmidDspHelp>
~)%'


end; WpCnfgH.asm
