;******************************* MODULE HEADER *******************************;
;*                                                                           *;
;* FILE: WpCnfgHA.asm                                                        *;
;*                                                                           *;
;* MACHINE: B20        LANGUAGE: ASSEMBLER  OS: BTOS                         *;
;*                                                                           *;
;* DESCRIPTION:                                                              *;
;*                                                                           *;
;* Editor help message text.                                                 *;
;*                                                                           *;
;* HISTORY:                                                                  *;
;*                                                                           *;
;* MM/DD/YY VVVV/MM PROGRAMMER   / DESCRIPTION OF CHANGE (Most recent first) *;
;*                                                                           *;
;* 01/25/90 120F/03 T. Ball      / More Pubs changes                         *;
;* 01/16/89 120F/02 T. Ball      / Cleaned up wording per Pubs               *;
;* 01/08/90 120F/01 T. Ball      / Fixed help text                           *;
;*                                                                           *;
;* TITLE:  BTOS SYSTEM SOFTWARE                                              *;
;*                                                                           *;
;*            PROPRIETARY PROGRAM MATERIAL                                   *;
;*                                                                           *;
;* THIS MATERIAL IS PROPRIETARY TO UNISYS CORPORATION AND IS NOT TO BE       *;
;* REPRODUCED, USED OR DISCLOSED EXCEPT IN ACCORDANCE WITH PROGRAM LICENSE   *;
;* OR UPON WRITTEN AUTHORIZATION OF THE PATENT DIVISION OF UNISYS            *;
;* CORPORATION, DETROIT, MICHIGAN 48232, USA.                                *;
;*                                                                           *;
;* COPYRIGHT (C) 1980, 1989 CONVERGENT TECHNOLOGIES INC. ALL RIGHTS RESERVED *;
;* COPYRIGHT (C) 1980, 1989 UNISYS CORPORATION. ALL RIGHTS RESERVED          *;
;* ************************************************************************* *;
;*                                                                           *;
;* UNISYS BELIEVES THAT THE SOFTWARE FURNISHED HEREWITH IS ACCURATE AND      *;
;* RELIABLE, AND MUCH CARE HAS BEEN TAKEN IN ITS PREPARATION.  HOWEVER,      *;
;* NO RESPONSIBILITY, FINANCIAL OR OTHERWISE, CAN BE ACCEPTED FOR ANY        *;
;* CONSEQUENCES ARISING OUT OF THE USE OF THIS MATERIAL, INCLUDING LOSS OF   *;
;* PROFIT, INDIRECT, SPECIAL, OR CONSEQUENTIAL DAMAGES, THERE ARE NO         *;
;* WARRANTIES WHICH EXTEND BEYOND THE PROGRAM SPECIFICATION.                 *;
;*                                                                           *;
;* THE CUSTOMER SHOULD EXERCISE CARE TO ASSURE THAT USE OF THE SOFTWARE      *;
;* WILL BE IN FULL COMPLIANCE WITH LAWS, RULES AND REGULATIONS OF THE        *;
;* JURISDICTIONS WITH RESPECT TO WHICH IT IS USED.                           *;
;*                                                                           *;
;*                                                                           *;
;*************************** END OF MODULE HEADER ****************************;

; WpCnfgHA.asm -- help for menus defined in WpCnfgA.asm

$include(WpKbd.mdf)
$include(WpCmid.mdf)
$include(WpCmdd.mdf)
$include(WpMsg.mdf)
$include(WpCnfg.mdf)


extrn cmidDspHelp: abs

DGroup group CmidSeg, CmddSeg, MenuSeg
assume ds: DGroup


%DefineMenu(cmidDocumentsHelp, iCmrDisplayHelpMenu, false, 22,
~ FILE COMMANDS HELP ~,
~|(Press CANCEL to dismiss, HELP for more help)|
| |
Press O to Open file                Press P to change default Path
      D    Delete file                    L    List directory files
      C    Copy file                      V    Volume status
      R    Rename file                    F    List opened files

Open file:  Press O to display the Open File menu.  Use this command to open
	a file for editing.  This menu can also be invoked using CODE-O or
	CODE-SHIFT-O.

Delete file:  Press D to display the Delete File menu.  If the cursor is in
	a file window, the name of that file will be filled in as a default file
	name to be deleted.  This menu can also be invoked using CODE-SHIFT-D.

Copy file:  Press C to display the Copy File menu.  If the cursor is in
	a file window, the name of that file will be filled in as a default file
	name to be copied from.  This menu can also be invoked using CODE-SHIFT-C.

Rename file:  Press R to display the Rename File menu.  If the cursor is in
	a file window, the name of that file will be filled in as a default old
	file name.  This menu can also be invoked using CODE-SHIFT-R.

Change default path:  Press P to display the Path menu.  The path, also known 
	as the work area, is the current default node, volume, directory, and
	password used to access files.  The current default path is displayed in 
	the top left corner of the display.  This menu can also be invoked using 
	CODE-SHIFT-P.

List directory files:  Press L to display the List Files menu.  Use this
	command to display filenames for any directory accessible from your
	workstation.  This menu can also be invoked using CODE-SHIFT-L.

Volume status:  Press V to display the Volume Status menu.  This command 
	displays a list of directories for the specified volume, as well as the
	amount of space available on that volume.  This menu can also be invoked 
	using CODE-SHIFT-V.

List opened files:  Press F to display the status of all files currently opened
	by the Editor.  The Editor keeps open all files it has accessed until 
	you issue either a Save (CODE-S) or a Finish command.  This command 
	displays the full filename of each open file, as well as what mode it is 
	currently open in and whether it has been modified or is ready to be 
	deleted.  This menu can also be invoked using CODE-SHIFT-F.
~,
~
<idParTitle>
	<idMsg, typSysBlank>
	<idMsg> <idParPlace>
<idParMenuHelp>
	<idNil, typProtected or maskfRev or maskfHb>
	<>
~,
~
<chHelp, cmidDspHelp>
~)%'


%DefineMenu(cmidOpenDocHelp, iCmrDisplayHelpMenu, false, 21,
~ OPEN FILE HELP ~,
~|(Press CANCEL to dismiss, HELP for more help)|
| |
The Open File command is used to open one or more files for editing.  

File name(s):  Specify the name of the file to be opened.  The Editor supports
	the Executive file naming conventions, expanding wildcards and @files.
	Multiple files are separated either by spaces or commas.  File names with
	embedded spaces can be specified by surrounding the file name with single
	quotes.

Password:  If needed, specify a volume, directory, or file password used to
	access the file(s).  If not specified, the default password as defined 
	by the Path command (either in the Editor or the Executive) is used.

Allow changes?:  Specify Yes if you want to edit the file, otherwise No.  If
	you specify No and later want to modify the file, typing any editing
	character causes the Editor to prompt whether you want to edit the
	file.  If you answer Yes to that prompt, the file is made modifiable.

Copy from file:  If you are creating a new file and want to copy its initial
	contents from an existing file, specify the existing name in this field.
~,
~
<idParTitle>
	<idMsg, typSysBlank>
	<idMsg> <idParPlace>
<idParMenuHelp>
	<idNil, typProtected or maskfRev or maskfHb>
	<>
~,
~
<chHelp, cmidDspHelp>
~)%'


%DefineMenu(cmidDeleteDocHelp, iCmrDisplayHelpMenu, false, 15,
~ DELETE FILE HELP ~,
~|(Press CANCEL to dismiss, HELP for more help)|
| |
The Delete File command is used to delete one or more files.  Unlike the
Executive, the Editor does not actually delete any files until a Save or 
Finish command.  If you delete a file and later want to cancel that command,
you can do so by reopening the file.  Once a Save or Finish command has
been executed, however, all files that were to be deleted are deleted.

File name(s):  Specify the name of the file to be deleted.  Multiple files are 
	separated either by spaces or commas.  File names with embedded spaces can 
	be specified by surrounding the file name with single quotes.

Password:  If needed, specify a volume, directory, or file password used to
	access the file(s).  If not specified, the default password as defined 
	by the Path command (either in the Editor or the Executive) is used.
~,
~
<idParTitle>
	<idMsg, typSysBlank>
	<idMsg> <idParPlace>
<idParMenuHelp>
	<idNil, typProtected or maskfRev or maskfHb>
	<>
~,
~
<chHelp, cmidDspHelp>
~)%'


%DefineMenu(cmidCopyDocHelp, iCmrDisplayHelpMenu, false, 14,
~ COPY FILE HELP ~,
~|(Press CANCEL to dismiss, HELP for more help)|
| |
The Copy File command is used to copy one file to another.  A file can also be
copied using the Open File command, opening the new file and specifying the
existing file in the Copy From File field.  Like other Editor file commands,
the file is not actually copied until a Save or Finish command is executed.

Old file name:  Specify the name of the file to be copied.  

New file name:  Specify the name that the copy of the file will have.

Password:  If needed, specify a volume, directory, or file password used to
	access the file(s).  If not specified, the default password as defined 
	by the Path command (either in the Editor or the Executive) is used.
~,
~
<idParTitle>
	<idMsg, typSysBlank>
	<idMsg> <idParPlace>
<idParMenuHelp>
	<idNil, typProtected or maskfRev or maskfHb>
	<>
~,
~
<chHelp, cmidDspHelp>
~)%'


%DefineMenu(cmidRenameDocHelp, iCmrDisplayHelpMenu, false, 13,
~ RENAME FILE HELP ~,
~|(Press CANCEL to dismiss, HELP for more help)|
| |
The Rename File command is used to change the name of a file.  Like other 
Editor file commands, the file is not actually renamed until a Save or Finish 
command is executed.

Old file name:  Specify the current name of the file.

New file name:  Specify the new name of the file.

Password:  If needed, specify a volume, directory, or file password used to
	access the file(s).  If not specified, the default password as defined 
	by the Path command (either in the Editor or the Executive) is used.
~,
~
<idParTitle>
	<idMsg, typSysBlank>
	<idMsg> <idParPlace>
<idParMenuHelp>
	<idNil, typProtected or maskfRev or maskfHb>
	<>
~,
~
<chHelp, cmidDspHelp>
~)%'


%DefineMenu(cmidWorkAreaHelp, iCmrDisplayHelpMenu, false, 5,
~ SET PATH HELP ~,
~|(Press CANCEL to dismiss, HELP for more help)|
| |
The Set Path command is used to change the default node, volume, directory,
default prefix, and password used to access files.  It is equivalent to the 
Executive Path command.
~,
~
<idParTitle>
	<idMsg, typSysBlank>
	<idMsg> <idParPlace>
<idParMenuHelp>
	<idNil, typProtected or maskfRev or maskfHb>
	<>
~,
~
<chHelp, cmidDspHelp>
~)%'


%DefineMenu(cmidListDocsHelp, iCmrDisplayHelpMenu, false, 22,
~ LIST FILES HELP ~,
~|(Press CANCEL to dismiss, HELP for more help)|
| |
The List Files command creates a listing of a specified directory.  The 
Pattern and Look For fields restrict the listing to only those files matching
the specified pattern(s).  Files can be opened from a directory listing by
moving the cursor to the desired file, selecting it, and invoking an Editor
file command.

Pattern:  If you want to restrict the directory list, enter a wildcard file 
	specification for the desired list.  The default is to list all files in
	the directory.

Node, Volume, Directory, Prefix:  Fill in the node, volume, directory name,
	and prefix to be listed.  The default is either the current path, or a 
	directory selected in a Volume Status listing.

Password:  If needed, specify a volume or directory password used to access 
	the directory.  If not specified, the default password as defined by the 
	Path command (either in the Editor or the Executive) is used.

Details:  If Yes is specified, next to each file name will be the length of 
	the file in bytes and sectors, and the creation, last revised, and last
	accessed dates of the file.  If No is specified, only the file names will
	be displayed.

Sort by:  If Name is specified, the listing is sorted by file name.  If
	Suffix is specified, the listing is sorted first by the extension of the
	file (the portion following the rightmost period), and then by the
	rest of the file name.  This allows all files of a certain type to be
	grouped together.

Look for:  If a search string is specified in this field, all files to be
	listed are first opened and searched for the string.  Only those files
	where the string is found are displayed in the directory listing.
~,
~
<idParTitle>
	<idMsg, typSysBlank>
	<idMsg> <idParPlace>
<idParMenuHelp>
	<idNil, typProtected or maskfRev or maskfHb>
	<>
~,
~
<chHelp, cmidDspHelp>
~)%'


%DefineMenu(cmidListVolHelp, iCmrDisplayHelpMenu, false, 14,
~ VOLUME STATUS HELP ~,
~|(Press CANCEL to dismiss, HELP for more help)|
| |
The Volume Status displays a list of directories for the specified volume, as 
well as the amount of space available on that volume.  Directories can be
selected to be used as defaults for the Open File, Set Path, and List Files
commands.

Volume:  Fill in the name of the volume to be listed.

Password:  If needed, specify a volume password used to access the volume.  If
	not specified, the default password as defined by the Path command (either 
	in the Editor or the Executive) is used.

Node:  If accessing a volume over CT-Net, specify the node name of the volume.
~,
~
<idParTitle>
	<idMsg, typSysBlank>
	<idMsg> <idParPlace>
<idParMenuHelp>
	<idNil, typProtected or maskfRev or maskfHb>
	<>
~,
~
<chHelp, cmidDspHelp>
~)%'


end; WpCnfgHA.asm
