/* Sizes of Integral types		*/

/* maximum number of bits for smallest object (byte) */
#define CHAR_BIT			 8

/* maximum value for an object of type char */
#define CHAR_MAX		       255

/* minimum value for an object of type char */
#define CHAR_MIN			 0

/* maximum value for an object of type signed char */
#define SCHAR_MAX		      +127

/* minimum value for an object of type signed char */
#define SCHAR_MIN		      -128

/* maximum value for an object of type unsigned char */
#define UCHAR_MAX		       255

/* maximum value for an object of type short */
#define SHRT_MAX		    +32767

/* minimum value for an object of type short */
#define SHRT_MIN		    -32768

/* maximum value for an object of type signed short */
#define USHRT_MAX		     65535 /* 65_535 */

/* maximum value for an object of type int */
#define INT_MAX 		    +32767 /* 32_767 */

/* minimum value for an object of type int */
#define INT_MIN 		    -32768 /* 32_768 */

/* maximum value for an object of type unsigned int */
#define UINT_MAX		     65535 /* 65_535 */

/* maximum value for an object of type long */
#define LONG_MAX	       +2147483647 /* 2_147_483_647 */

/* minimum value for an object of type long */
#define LONG_MIN	       -2147483648 /* 2_147_483_648 */

/* maximum value for an object of type unsigned long */
#define ULONG_MAX		4294967295 /* 4_294_967_295 */


/* Characteristics of floating types  */

/* radix of double exponent representation */
#define DBL_RADIX			 2

/* double addition rounds (1) or chops (0) */
#define DBL_ROUNDS			 1

/* maximum exponent power of 10 that can be represented in a double */
#define DBL_MAX_EXPONENT	       +308

/* minimum exponent power of 10 that can be represented in a double */
#define DBL_MIN_EXPONENT	       -307

/* maximum number of decimal digits of floating_point precision in a double */
#define DBL_DIG 			 16

/* radix of float exponent representation */
#define FLT_RADIX			 2

/* float addition rounds (1) or chops (0) */
#define FLT_ROUNDS			 1

/* maximum exponent power of 10 that can be represented in a float */
#define FLT_MAX_EXPONENT	       +38

/* minimum exponent power of 10 that can be represented in a float */
#define FLT_MIN_EXPONENT	       -38

/* maximum number of decimal digits of floating_point precision in a float */
#define FLT_DIG 			 7

/* radix of long double exponent representation */
#define LDBL_RADIX			  2

/* long double addition rounds (1) or chops (0) */
#define LDBL_ROUNDS			  1

/* maximum exponent power of 10 that can be represented in a long double */
#define LDBL_MAX_EXPONENT		+4932 /* 4_932 */

/* minimum exponent power of 10 that can be represented in a long double */
#define LDBL_MIN_EXPONENT		-4932 /* 4_932 */

/* maximum number of decimal digits of floating_point precision in a long double */
#define LDBL_DIG			  19

/* Note that the internal representation of a floating point number in binary
   means that the numbers LDLB_DIG, FLT_DIG, and DBL_DIG are intrinsically
   inaccurate.	In fact, for double, between 15.6 and 16.9 significant digits
   can be represented, depending upon the value actually represented.
   The value of DBL_DIG should not be construed to mean that every DBL_DIG-digit
   floating point number can be stored with complete accuracy in a double. */
