(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: Target.i3.SPARC                                       *)
(* Last Modified On Fri May 29 22:28:44 PDT 1992 By muller     *)
(*      Modified On Fri Feb 28 15:59:57 PST 1992 By kalsow     *)

INTERFACE Target  (* for SPARC *);

(* This interface describes the target architecture *)

CONST
  (* integers *)
  INTSIZE  = 32;
  INTALIGN = 32;
  MAXINT   = 2147483647;
  MININT   = (- 2147483647) - 1;

  (* shorts *)
  SHORTSIZE  =     16;
  SHORTALIGN =     16;
  MAXSHORT   =  32767;
  MINSHORT   = -32768;
  MAXUSHORT  =  65535;
  MINUSHORT  =      0;

  (* characters *)
  CHARSIZE  =    8;
  CHARALIGN =    8;
  MAXCHAR   =  127;
  MINCHAR   = -128;
  MAXSCHAR  =  127;
  MINSCHAR  = -128;
  MAXUCHAR  =  255;
  MINUCHAR  =    0;

  (* booleans *)
  BOOLSIZE  = 8;
  BOOLALIGN = 8;

  (* reals *)
  REALSIZE  = 32;
  REALALIGN = 32;
  MAXREAL   =  "1.0e+37";
  MINREAL   = "-1.0e+37";

  (* longreals *)
  LONGREALSIZE  = 64;
  LONGREALALIGN = 64;
  MAXLONGREAL   =  "1.0e+37";
  MINLONGREAL   = "-1.0e+37";

  (* extended reals *)
  EXTENDEDSIZE  = LONGREALSIZE;
  EXTENDEDALIGN = LONGREALALIGN;
  MAXEXTENDED   = MAXLONGREAL;
  MINEXTENDED   = MINLONGREAL;


  (* addresses *)
  ADDRSIZE  = 32;
  ADDRALIGN = 32;
  ADDRUNIT  = 8;

  (* C structures *)
  PCCBITFIELDTYPEMATTERS = TRUE;   (* use the type rather than the size of
                                      a bit-field to compute alignment *)
  STRUCTURESIZEBOUNDARY = 8;   (* every structure size must be a multiple 
                                  of this *)
  BITFIELDCANOVERLAP = FALSE;  (* a bit field cannot overlap two adjacent 
                                  storage units *)  

  (* NIL checking *)
  FIRSTREADABLEADDR = 8192;
  (* Read or write references to addresses in the range [0..FIRSTREADABLE-1]
     will cause an address faults.  Hence, no explicit NIL checks are needed
     for dereferencing with offsets in this range. *)

  (* Thread stacks *)
  JumpBufSize    = 83 * ADDRSIZE;   (* size of a "jmp_buf" *)
  FixedFrameSize = 20 * ADDRSIZE;   (* size of an "empty" stack frame *)
  GuardPageSize  = 4096 * CHARSIZE; (* size of the "unmapped" region at the
                                       end of a thread stack *)
  (* These parameters are used to estimate the size each procedure's
     frame.  If the estimated size of a procedure's frame is less
     than the guard page's size, no explict check for stack overflow
     is needed.  *)

END Target.
