(* Copyright (C) 1992, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* File: WordDivide.m3                                         *)
(* Last Modified On Tue Jun 30 09:32:05 PDT 1992 By kalsow     *)
(*      Modified On Tue Apr 10 11:07:52 1990 By muller         *)

MODULE WordDivide;

IMPORT CallExpr, Expr, Type, Procedure, Emit, BuiltinArgs, ProcType;
IMPORT Word, Int, IntegerExpr, WordPlus, Value, Formal, Temp;

VAR Z: CallExpr.MethodList;
VAR formals: ARRAY [0..1] OF Value.T;

PROCEDURE Check (<*UNUSED*> proc: Expr.T; VAR args: Expr.List;  VAR cs: Expr.CheckState): Type.T =
  BEGIN
    EVAL Formal.CheckArgs (cs, args, formals);
    RETURN Int.T;
  END Check;

PROCEDURE Compile (<*UNUSED*> proc: Expr.T; args: Expr.List): Temp.T =
  VAR t1, t2, t3: Temp.T;
  BEGIN
    t1 := Expr.Compile (args[0]);
    t2 := Expr.Compile (args[1]);
    t3 := Temp.AllocEmpty (Int.T);
    Emit.OpTTT ("@ = ((unsigned)@ / (unsigned)@);\n", t3, t1, t2);
    Temp.Free (t1);
    Temp.Free (t2);
    RETURN t3;
  END Compile;

PROCEDURE Fold (<*UNUSED*> proc: Expr.T; args: Expr.List): Expr.T =
  VAR w0, w1: Word.T;
  BEGIN
    IF WordPlus.GetArgs (args, w0, w1)
      THEN RETURN IntegerExpr.New (Word.Divide (w0, w1));
      ELSE RETURN NIL;
    END;
  END Fold;

PROCEDURE Initialize () =
  BEGIN
    formals[0] := BuiltinArgs.f1;
    formals[1] := BuiltinArgs.f5;
    Z := CallExpr.NewMethodList (2, 2, TRUE, TRUE, Int.T,
                                 NIL, Check, Compile, Fold,
                                 CallExpr.IsNever, (* writable *)
                                 CallExpr.IsNever, (* designator *)
                                 CallExpr.NotWritable (* noteWriter *));
    Procedure.Define ("Divide", Z, FALSE, ProcType.New (formals, Int.T));
  END Initialize;

BEGIN
END WordDivide.
