%!
%% Copyright (C) 1989, Digital Equipment Corporation
%% All rights reserved.
%% See the file COPYRIGHT for a full description.
%%
%%Title:         m3grammar.h
%%Creator:       Bill Kalsow
%%CreationDate:  Fri Oct 23 13:21:27 1987 by kalsow
%%EditDate:      Last modified on Fri Oct  4 19:31:07 1991 by kalsow
%%EditDate:           modified on Fri Nov  3 16:32:19 1989 by muller

%%
%%  a Modula-3 grammar
%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%
% terminals
%

/ident    { (id)           :TERM } def
/number   { (number)       :TERM } def
/char     { (char literal) :TERM } def
/string   { (text literal) :TERM } def

/PLUS     { (+)   :TERM } def
/MINUS    { (-)   :TERM } def
/STAR     { (*)   :TERM } def
/SLASH    { (/)   :TERM } def
/GETS     { (:=)  :TERM } def
/CONCAT   { (&)   :TERM } def
/DOT      { (.)   :TERM } def
/COMMA    { (,)   :TERM } def
/SEMI     { (;)   :TERM } def
/LPAREN   { (\()  :TERM } def
/RPAREN   { (\))  :TERM } def
/LBRACK   { ([)   :TERM } def
/RBRACK   { (])   :TERM } def
/LBRACE   { ({)   :TERM } def
/RBRACE   { (})   :TERM } def
/ARROW    { (^)   :TERM } def
/EQ       { (=)   :TERM } def
/NE       { (#)   :TERM } def
/LT       { (<)   :TERM } def
/GT       { (>)   :TERM } def
/LE       { (<=)  :TERM } def
/GE       { (>=)  :TERM } def
/DOTDOT   { (..)  :TERM } def
/COLON    { (:)   :TERM } def
/BAR      { (|)   :TERM } def
/SUBTYPE  { (<:)  :TERM } def
/HENCE    { (=>)  :TERM } def
/SQUOTE   { (')   :TERM } def
/DQUOTE   { (")   :TERM } def
/BSLASH   { (\\)  :TERM } def

/AND             { (AND)            :TERM } def
/ANY             { (ANY)            :TERM } def
/ARRAY           { (ARRAY)          :TERM } def
/AS              { (AS)             :TERM } def
/BEGIN           { (BEGIN)          :TERM } def
/BITS            { (BITS)           :TERM } def
/BRANDED         { (BRANDED)        :TERM } def
/BY              { (BY)             :TERM } def
/CASE            { (CASE)           :TERM } def
/CONST           { (CONST)          :TERM } def
/DEC             { (DEC)            :TERM } def
/DIV             { (DIV)            :TERM } def
/DO              { (DO)             :TERM } def
/ELSE            { (ELSE)           :TERM } def
/ELSIF           { (ELSIF)          :TERM } def
/END             { (END)            :TERM } def
/EVAL            { (EVAL)           :TERM } def
/EXCEPT          { (EXCEPT)         :TERM } def
/EXCEPTION       { (EXCEPTION)      :TERM } def
/EXIT            { (EXIT)           :TERM } def
/EXPORTS         { (EXPORTS)        :TERM } def
/FINALLY         { (FINALLY)        :TERM } def
/FOR             { (FOR)            :TERM } def
/FROM            { (FROM)           :TERM } def
/GENERIC         { (GENERIC)        :TERM } def
/IF              { (IF)             :TERM } def
/IMPORT          { (IMPORT)         :TERM } def
/IN              { (IN)             :TERM } def
/INC             { (INC)            :TERM } def
/INTERFACE       { (INTERFACE)      :TERM } def
/LOCK            { (LOCK)           :TERM } def
/LOOP            { (LOOP)           :TERM } def
/METHODs         { (METHODS)        :TERM } def
/MOD             { (MOD)            :TERM } def
/MODULE          { (MODULE)         :TERM } def
/NEW             { (NEW)            :TERM } def
/NOT             { (NOT)            :TERM } def
/OBJECT          { (OBJECT)         :TERM } def
/OF              { (OF)             :TERM } def
/OR              { (OR)             :TERM } def
/OVERRIDES       { (OVERRIDES)      :TERM } def
/PROCEDURE       { (PROCEDURE)      :TERM } def
/RAISE           { (RAISE)          :TERM } def
/RAISES          { (RAISES)         :TERM } def
/READONLY        { (READONLY)       :TERM } def
/RECORD          { (RECORD)         :TERM } def
/REF             { (REF)            :TERM } def
/REPEAT          { (REPEAT)         :TERM } def
/RETURN          { (RETURN)         :TERM } def
/REVEAL          { (REVEAL)         :TERM } def
/ROOT            { (ROOT)           :TERM } def
/SET             { (SET)            :TERM } def
/THEN            { (THEN)           :TERM } def
/TO              { (TO)             :TERM } def
/TRY             { (TRY)            :TERM } def
/TYPE            { (TYPE)           :TERM } def
/TYPECASE        { (TYPECASE)       :TERM } def
/UNSAFE          { (UNSAFE)         :TERM } def
/UNTIL           { (UNTIL)          :TERM } def
/UNTRACED        { (UNTRACED)       :TERM } def
/VALUE           { (VALUE)          :TERM } def
/VAR             { (VAR)            :TERM } def
/WHILE           { (WHILE)          :TERM } def
/WITH            { (WITH)           :TERM } def

%
% forward declarations
%

/Expression        { (Expression) { }        :NONTERM } def
/ConstExpression   { (ConstExpression) { }   :NONTERM } def
/Type              { (Type)              { } :NONTERM } def
/StatementSequence { (StatementSequence) { } :NONTERM } def
/declarations      { (declarations) { }      :NONTERM } def

%
% non-terminals
%

/QID {
    (QualId)
    { ident OPT: DOT ident :OPT }
    :MACRO
  } def

/TypeID {
    (Type ID)
    { CHOICE: QID ROOT SEQ: UNTRACED ROOT :SEQ :CHOICE }
    :NONTERM
  } def

/ExceptionID {
    (Exception ID)
    { QID }
    :NONTERM
  } def

/IdentList {
    (ID list)
    { LIST: ident :SEP: COMMA :LIST }
    :MACRO
  } def

/actual {
    (Actual)
    { CHOICE: SEQ: OPT: ident GETS :OPT Expression :SEQ Type :CHOICE }
    :NONTERM
  } def

/ActualArgs {
    (actual arguments)
    { LPAREN OLIST: actual :SEP: COMMA :OLIST RPAREN }
    :MACRO
 } def

/Selector {
    (Selector)
    {
      CHOICE:
        :EPSILON:
	SEQ: ARROW        :SEQ
	SEQ: DOT ident    :SEQ
	SEQ: LBRACK LIST: Expression :SEP: COMMA :LIST RBRACK :SEQ
	ActualArgs
      :CHOICE
    }
    :MACRO
  } def

/setElt {
    (set element)
    { Expression OPT: DOTDOT Expression :OPT }
    :MACRO
  } def

/setCons {
    (set constructor)
    { LIST: setElt :SEP: COMMA :LIST }
    :NONTERM
  } def

/recordElt {
    (record element)
    { OPT: ident GETS :OPT Expression }
    :MACRO
  } def

/recordCons {
    (record constructor)
    { LIST: recordElt :SEP: COMMA :LIST }
    :NONTERM
  } def

/arrayCons {
    (array constructor)
    { LIST: Expression :SEP: COMMA :LIST OPT: COMMA DOTDOT :OPT }
    :NONTERM
  } def

/Constructor {
    (Constructor)
    {
      Type
      LBRACE
       CHOICE: :EPSILON: setCons recordCons arrayCons :CHOICE
      RBRACE
    }
    :NONTERM
  } def

/unaryop {
    (unary op)
    { CHOICE: :EPSILON: PLUS MINUS :CHOICE }
    :MACRO
  } def

/e8 {
    (primary)
    {
      CHOICE:
	ident
        number
	char
	string
	Constructor
	SEQ: LPAREN Expression RPAREN :SEQ
      :CHOICE
    }
    :NONTERM
  } def

/e7 {
    (e7)
    { e8 LOOP: Selector :LOOP }
    :MACRO
  } def

/e6 {
    (e6)
    { LOOP: unaryop :LOOP e7 }
    :NONTERM
  } def

/mulop {
    (mul op)
    { HCHOICE: STAR SLASH DIV MOD :HCHOICE }
    :MACRO
  } def

/e5 {
    (e5)
    { e6 OLOOP: mulop e6 :OLOOP }
    :NONTERM
  } def

/addop {
    (add op)
    { HCHOICE: PLUS MINUS CONCAT :HCHOICE }
    :MACRO
  } def

/e4 {
    (e4)
    { e5 OLOOP: addop e5 :OLOOP }
    :NONTERM
  } def

/relation {
    (relation)
    { HCHOICE: EQ NE LT LE GT GE IN :HCHOICE }
    :MACRO
  } def

/e3 {
    (e3)
    { e4 OLOOP: relation e4 :OLOOP }
    :NONTERM
  } def

/e2 {
    (e2)
    { OLOOP: NOT :OLOOP e3 }
    :NONTERM
  } def

/e1 {
    (e1)
    { e2 OLOOP: AND e2 :OLOOP }
    :NONTERM
  } def

/Expression {
    (Expression)
    { e1 OLOOP: OR e1 :OLOOP }
    :NONTERM
  } def

/ConstExpression {
    (Constant expression)
    { Expression }
    :NONTERM
  } def

/formalType {
    (formal type)
    {
      CHOICE:
        SEQ: COLON Type GETS ConstExpression :SEQ
	SEQ: COLON Type :SEQ
        SEQ: GETS ConstExpression :SEQ
      :CHOICE
    }
    :MACRO
  } def

/field {
    (field)
    { IdentList formalType }
    :NONTERM
  } def

/fields {
    (fields)
    { OPT: LIST: field :SEP: SEMI :LIST OPT: SEMI :OPT :OPT }
    :NONTERM
  } def

/ArrayType {
    (Array type)
    { ARRAY OLIST: Type :SEP: COMMA :OLIST OF Type }
    :NONTERM
  } def

/PackedType {
    (Packed type)
    { BITS ConstExpression FOR Type }
    :NONTERM
  } def

/EnumerationType {
    (Enumeration type)
    { LBRACE OPT: IdentList :OPT RBRACE }
    :NONTERM
  } def

/method {
    (method)
    { ident Signature OPT: GETS ConstExpression :OPT }
    :NONTERM
  } def

/methodList {
    (methods)
    { METHODs OPT: LIST: method :SEP: SEMI :LIST OPT: SEMI :OPT :OPT }
    :NONTERM
  } def

/override {
    (override)
    { ident GETS ConstExpression }
    :MACRO
  } def

/overrideList {
    (overrides)
    { OVERRIDES OPT: LIST: override :SEP: SEMI :LIST OPT: SEMI :OPT :OPT }
    :NONTERM
  } def

/Brand {
    (Brand)
    {  OPT: BRANDED OPT: ConstExpression :OPT :OPT  }
    :NONTERM
  } def

/ObjectType {
    (Object type)
    { CHOICE: :EPSILON: TypeID ObjectType :CHOICE  Brand OBJECT
        fields
        OPT: methodList :OPT
        OPT: overrideList :OPT
      END
    }
    :NONTERM
  } def

/ProcedureType {
    (Procedure type)
    { PROCEDURE Signature }
    :NONTERM
  } def

/SubrangeType {
    (Subrange type)
    { LBRACK ConstExpression DOTDOT ConstExpression RBRACK }
    :NONTERM
  } def

/RecordType {
    (Record type)
    { RECORD fields END }
    :NONTERM
  } def

/RefType {
    (Ref type)
    { CHOICE: :EPSILON: UNTRACED :CHOICE Brand REF Type }
    :NONTERM
  } def

/SetType {
    (Set type)
    { SET OF Type }
    :NONTERM
  } def

/Type {
    (Type)
    {
      CHOICE:
        TypeID
        ArrayType
        PackedType
        EnumerationType
        ObjectType
        ProcedureType
        RecordType
        RefType
        SetType
        SubrangeType
        SEQ: LPAREN Type RPAREN :SEQ
      :CHOICE
    }
    :NONTERM
  } def

/AssignmentStatement {
    (Assignment statement)
    { Expression GETS Expression }
    :NONTERM
  } def

/CallStatement {
    (Call statement)
    { Expression ActualArgs }
    :NONTERM
  } def

/caseLabels {
    (case label)
    { ConstExpression OPT: DOTDOT ConstExpression :OPT }
    :MACRO
  } def

/CaseLabelList {
    (Case labels)
    { LIST: caseLabels :SEP: COMMA :LIST }
    :MACRO
  } def

/case {
    (case)
    { CaseLabelList HENCE StatementSequence }
    :NONTERM
  } def

/CaseStatement {
    (Case statement)
    {
      CASE Expression OF
      OPT:   case                   :OPT
      OLOOP: BAR case               :OLOOP
      OPT:   ELSE StatementSequence :OPT
      END
    }
    :NONTERM
  } def

/DecStatement {
    (Dec statement)
    { DEC LPAREN Expression OPT: COMMA Expression :OPT RPAREN }
    :NONTERM
  } def

/ExitStatement {
    (Exit statement)
    { EXIT }
    :NONTERM
  } def

/EvalStatement {
    (Eval statement)
    { EVAL Expression }
    :NONTERM
  } def

/ForStatement {
    (For statement)
    {
      FOR ident GETS Expression TO Expression
        OPT: BY Expression :OPT
	DO StatementSequence END
    }
    :NONTERM
  } def

/IfStatement {
    (If statement)
    {
      IF Expression THEN StatementSequence
      OLOOP: ELSIF Expression THEN StatementSequence :OLOOP
      OPT: ELSE StatementSequence :OPT
      END
    }
    :NONTERM
  } def

/IncStatement {
    (Inc statement)
    { INC LPAREN Expression OPT: COMMA Expression :OPT RPAREN }
    :NONTERM
  } def

/LockStatement {
    (Lock statement)
    { LOCK Expression DO StatementSequence END }
    :NONTERM
  } def

/LoopStatement {
    (Loop statement)
    { LOOP StatementSequence END }
    :NONTERM
  } def

/RaiseStatement {
    (Raise statement)
    { RAISE ExceptionID OPT: LPAREN Expression RPAREN :OPT }
    :NONTERM
  } def

/RepeatStatement {
    (Repeat statement)
    { REPEAT StatementSequence UNTIL Expression }
    :NONTERM
  } def

/ReturnStatement {
    (Return statement)
    { RETURN OPT: Expression :OPT }
    :NONTERM
  } def

/TryFinallyStatement {
    (Try-Finally statement)
    { TRY StatementSequence FINALLY StatementSequence END }
    :NONTERM
  } def

/handler {
    (handler)
    {
      LIST: ExceptionID :SEP: COMMA :LIST
      OPT:  LPAREN ident RPAREN :OPT
      HENCE StatementSequence
    }
    :NONTERM
  } def

/TryStatement {
    (Try statement)
    {
      TRY StatementSequence
      EXCEPT
        OPT:   handler :OPT
	OLOOP: BAR handler :OLOOP
        OPT:   ELSE StatementSequence :OPT
      END
    }
    :NONTERM
  } def

/tcase {
    (tcase)
    {
      LIST: Type :SEP: COMMA :LIST
      OPT:  LPAREN ident RPAREN :OPT
      HENCE StatementSequence
    }
    :NONTERM
  } def

/TypeCaseStatement {
    (Typecase statement)
    {
      TYPECASE Expression OF
      OPT:   tcase                  :OPT
      OLOOP: BAR tcase              :OLOOP
      OPT:   ELSE StatementSequence :OPT
      END
    }
    :NONTERM
  } def

/WhileStatement {
    (While statement)
    { WHILE Expression DO StatementSequence END }
    :NONTERM
  } def

/binding {
    (binding)
    { ident EQ Expression }
    :MACRO
  } def

/WithStatement {
    (With statement)
    { WITH  LIST: binding :SEP: COMMA :LIST DO StatementSequence END }
    :NONTERM
  } def

/statement {
    (statement)
    {
      CHOICE: 
        AssignmentStatement
	Block
	CallStatement
        CaseStatement
	DecStatement
        ExitStatement
	EvalStatement
        ForStatement
        IfStatement
	IncStatement
        LockStatement
        LoopStatement
	RaiseStatement
        RepeatStatement
        ReturnStatement
        TryFinallyStatement
        TryStatement
        TypeCaseStatement
        WhileStatement
        WithStatement
      :CHOICE
    }
    :MACRO
  } def

/StatementSequence {
    (Stmts)
    { OPT: LIST: statement :SEP: SEMI :LIST OPT: SEMI :OPT :OPT }
    :NONTERM
  } def

/raises {
    (raises)
    { CHOICE:
        SEQ: LBRACE OLIST: ExceptionID :SEP: COMMA :OLIST RBRACE :SEQ
        ANY
      :CHOICE }
    :MACRO
  } def

/formal {
    (formal)
    { CHOICE: :EPSILON: VALUE VAR READONLY :CHOICE IdentList formalType }
    :NONTERM
  } def

/formals {
    (formals)
    { OPT: LIST: formal :SEP: SEMI :LIST OPT: SEMI :OPT :OPT }
    :NONTERM
  } def

/Signature {
    (Signature)
    { LPAREN formals RPAREN OPT: COLON Type :OPT OPT: RAISES raises :OPT }
    :NONTERM
  } def

/ProcedureHeading {
    (Procedure heading)
    { PROCEDURE ident Signature }
    :NONTERM
  } def

/ConstDeclaration {
    (Constant declaration)
    { ident OPT: COLON Type :OPT EQ ConstExpression }
    :NONTERM
  } def

/TypeDeclaration {
    (Type declaration)
    { ident CHOICE: EQ SUBTYPE :CHOICE Type }
    :NONTERM
  } def

/VariableDeclaration {
    (Variable declaration)
    {
      IdentList
      CHOICE:
	SEQ: COLON Type OPT: GETS Expression :OPT :SEQ
        SEQ: GETS Expression :SEQ
      :CHOICE
    }
    :NONTERM
  } def

/ExceptionDeclaration {
    (Exception declaration)
    { ident OPT: LPAREN Type RPAREN :OPT }
    :NONTERM
  } def

/Revelation {
    (Revelation)
    { TypeID CHOICE: EQ SUBTYPE :CHOICE Type }
    :NONTERM
  } def

/Declaration {
    (Declaration)
    {
      CHOICE: 
        SEQ: CONST     OLOOP: ConstDeclaration     SEMI :OLOOP :SEQ
        SEQ: TYPE      OLOOP: TypeDeclaration      SEMI :OLOOP :SEQ
        SEQ: EXCEPTION OLOOP: ExceptionDeclaration SEMI :OLOOP :SEQ
        SEQ: VAR       OLOOP: VariableDeclaration  SEMI :OLOOP :SEQ
        SEQ: REVEAL    OLOOP: Revelation           SEMI :OLOOP :SEQ
        SEQ: ProcedureHeading OPT: EQ Block ident :OPT SEMI :SEQ
      :CHOICE
    }
    :NONTERM
  } def

/declarations { OLOOP: Declaration :OLOOP } def

/Block {
    (Block)
    { declarations BEGIN StatementSequence END }
    :NONTERM
  } def

/AsClause {
    (as clause)
    { CHOICE: :EPSILON: SEQ: AS ident :SEQ :CHOICE }
    :MACRO
  } def

/Import {
    (Import)
    { CHOICE:
        SEQ: IMPORT LIST: ident AsClause :SEP: COMMA :LIST SEMI :SEQ
        SEQ: FROM ident IMPORT IdentList SEMI :SEQ
      :CHOICE
    }
    :NONTERM
  } def

/imports { OLOOP: Import :OLOOP } def

/GenericActuals {
    (generic actuals)
    { LPAREN OPT: IdentList :OPT RPAREN }
    :MACRO
  } def

/GenericFormals {
    (generic formals)
    { LPAREN OPT: IdentList :OPT RPAREN }
    :MACRO
  } def

/GenericHead {
    (Generic head)
    { ident GenericActuals }
    :NONTERM
  } def


/InterfaceBody {
    (Interface body)
    { imports declarations }
    :NONTERM
  } def

/Interface {
    (Interface)
    { INTERFACE ident
      CHOICE:
        SEQ: SEMI InterfaceBody  :SEQ
        SEQ: EQ GenericHead      :SEQ
      :CHOICE
      END ident DOT
    }
    :NONTERM
  } def

/ModuleBody {
    (Module body)
    { imports Block }
    :NONTERM
  } def

/Module {
    (Module)
    { MODULE ident OPT: EXPORTS IdentList :OPT
      CHOICE:
        SEQ: SEMI ModuleBody    :SEQ
        SEQ: EQ GenericHead END :SEQ
      :CHOICE
      ident DOT
    }
    :NONTERM
  } def

/GenericInterface {
    (Generic interface)
    { GENERIC INTERFACE GenericHead SEMI InterfaceBody END ident DOT }
    :NONTERM
  } def

/GenericModule {
    (Generic module)
    { GENERIC MODULE GenericHead SEMI ModuleBody ident DOT }
    :NONTERM
  } def

/CompilationUnit {
    (Compilation unit)
    { CHOICE:
        SEQ: CHOICE: :EPSILON: UNSAFE :CHOICE
             CHOICE: Interface Module :CHOICE  :SEQ
        GenericInterface
        GenericModule
      :CHOICE
    }
    :NONTERM
  } def

