(* Copyright (C) 1992, Xerox                                             *)
(* All rights reserved.                                                  *)

(* Last modified on Fri Feb 28 20:07:37 PST 1992 by stolfi               *)
(*      modified on Tue Feb 11 15:18:43 PST 1992 by muller               *)
(*      modified on Wed Sep 25 00:33:01 1991 by goldberg@xerox.parc.com  *)

INTERFACE Real;

(* Properties of REAL (for SPARCstations).

   This package defines some basic properties of the 
   built-in float type REAL, for SPARCstation machines.

   Index: REAL; floating-point; generics
*)
  
TYPE T = REAL;

CONST 
  Base: INTEGER = 2; 
  (* The radix of the floating-point representation for T *)

  Precision: INTEGER = 24;
  (* The number of digits of precision in the given Base for T. *)

  MaxFinite: T = 3.40282347E+38;
  (* The maximum finite value in T.  For non-IEEE implementations,
     this is the same as LAST(T). *)

  MinPos: T = 1.40239846E-45;
  (* The minimum positive value in T. *)

  MinPosNormal: T = 1.17549435E-38;
  (* The minimum positive "normal" value in T; differs from MinPos
     only for implementations with denormalized numbers. *)

END Real.

