(* Copyright (C) 1991, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Last modified on Fri Feb 28 20:49:49 PST 1992 by stolfi     *)
(*      modified on Wed Sep 25 00:29:55 1991 by kalsow         *)
(*      modified on Wed Jun 26 03:07:33 1991 by muller         *)

INTERFACE Real; 

(* Properties of REAL (for the VAX).

   This package defines some basic properties of the 
   built-in float type REAL, for the VAX architecture.

   Index: REAL; floating-point; generics
*)
  
TYPE T = REAL;

CONST 
  Base: INTEGER = 2; 
  (* The radix of the floating-point representation for T *)

  Precision: INTEGER = 24;
  (* The number of digits of precision in the given Base for T. *)

  MaxFinite: T = 1.70141173e+38;
  (* The maximum finite value in T.  For non-IEEE implementations,
     this is the same as LAST(T). *)

  MinPos: T = 2.93873588e-39;
  (* The minimum positive value in T. *)

  MinPosNormal: T = 2.93873588e-39;
  (* The minimum positive "normal" value in T; differs from MinPos
     only for implementations with denormalized numbers. *)

END Real.

