(* Copyright (C) 1990, Digital Equipment Corporation.         *)
(* All rights reserved.                                       *)
(* See the file COPYRIGHT for a full description.             *)

(* Last modified on Thu Nov 12 14:06:13 PST 1992 by muller        *)

INTERFACE RTThread;

IMPORT Csetjmp, Usignal;

CONST
  FramePadBottom = 2; (* additional words before old stack pointer to copy *)
  FramePadTop = 0;     (* additional words beyond new stack pointer to copy *)

(*--------------------------------------------------------- machine state ---*)

(* The pair Save/Restore is similar to _setjmp/_longjmp, and the type
   State is similar to a jmp_buf.  In fact, these are good enough on 
   many machines. *)

TYPE
  State = Csetjmp.jmp_buf;

<*EXTERNAL "_setjmp" *> PROCEDURE Save (VAR s: State): INTEGER;
<*EXTERNAL "_longjmp" *> PROCEDURE Restore (VAR s: State; v: INTEGER);


PROCEDURE SP (s: State): ADDRESS;
  (* Returns the stack pointer associated with s *)

(*-------------------------------------------------- modifying the models ---*)

(* When a new thread is forked, the contents of its stack and its state
   are built from models.  The only difference with the model is the location
   of the stack.  The two procedures below are used to modify the values of 
   the model to point to the correct state.  offset is the difference 
   between the actual stack location and the model stack location *)

PROCEDURE UpdateStateForNewSP (VAR s: State; offset: INTEGER);
  (* update the state *)

PROCEDURE UpdateFrameForNewSP (a: ADDRESS; offset: INTEGER);
  (* update the stack frame.  a is the correct value for the SP 
     on the stack that contains that frame. *)

(*------------------------------------------------------- flushing caches ---*)

(* On some machines, the stack is cached; for example, on SPARC, the stack
   is partially cached in the registers. FlushStackCache is use to make
   sure that the contents of the stack is up to date. *)

PROCEDURE FlushStackCache ();

(*------------------------------------ manipulating the SIGVTALRM handler ---*)

PROCEDURE setup_sigvtalrm (handler: Usignal.SignalHandler);
PROCEDURE allow_sigvtalrm ();
PROCEDURE disallow_sigvtalrm ();

END RTThread.
