UNSAFE MODULE Args_ux EXPORTS Args;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

IMPORT Args;
IMPORT M3toC;


PROCEDURE Initialize(): REF Args.T RAISES {}=
  VAR
    total := M3toC.argc - 1; (* we don't include the program name *)
    new := NEW(REF Args.T, total);
  BEGIN
    FOR i := 0 TO total - 1 DO
      new[i] := M3toC.CopyStoT(M3toC.argv[i+1]);
    END;
    RETURN new;
  END Initialize;


VAR
  args_g: REF Args.T := Initialize();


PROCEDURE CommandLine(): REF Args.T RAISES {} =
  BEGIN
    RETURN Args.Copy(args_g^);
  END CommandLine;


BEGIN
END Args_ux.
