INTERFACE SList;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

(* Heterogenous, singly-linked lists, with an element on at most one
list at a time. *)

IMPORT Text;

TYPE
  T = RECORD head: Elem := NIL END;

  Elem = OBJECT next: Elem := NIL END;

  IntElem = Elem OBJECT int: INTEGER END;
  CardElem = Elem OBJECT card: CARDINAL END;
  RealElem = Elem OBJECT real: REAL END;
  LongRealElem = Elem OBJECT longReal: Elem END;
  CharElem = Elem OBJECT char: CHAR END;
  BoolElem = Elem OBJECT bool: BOOLEAN END;
  TextElem = Elem OBJECT text: Text.T END;
  RefAnyElem = Elem OBJECT refany: REFANY END;

PROCEDURE AddFront(VAR l: T; elem: Elem) RAISES {};

PROCEDURE AddRear(VAR l: T; elem: Elem) RAISES {};

PROCEDURE Add(VAR l: T; elem: Elem) RAISES {};
(* Adds 'elem' to 'l' as quickly as possible - for users who don't care where
on the list 'elem' is added *)

EXCEPTION Missing;

PROCEDURE Remove(VAR l: T; elem: Elem) RAISES {Missing};

PROCEDURE Length(l: T): CARDINAL RAISES {};

END SList.
