MODULE SList;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)


PROCEDURE AddFront(VAR l: T; elem: Elem) RAISES {} =
  BEGIN
    elem.next := l.head;
    l.head := elem;
  END AddFront;


PROCEDURE Add(VAR l: T; elem: Elem) RAISES {} =
  BEGIN (* This could be tidied when INLINE works.. *)
    elem.next := l.head;
    l.head := elem;
  END Add;


PROCEDURE AddRear(VAR l: T; elem: Elem) RAISES {} =
  VAR t: Elem;
  BEGIN
    IF l.head = NIL THEN
      elem.next := l.head;
      l.head := elem;
    ELSE
      t := l.head;
      WHILE t.next # NIL DO
        t := t.next;
      END; (* while *)
      t.next := elem;
    END; (* if *)
  END AddRear;


PROCEDURE Remove(VAR l: T; elem: Elem) RAISES {Missing} =
  VAR t: Elem;
  BEGIN
    IF l.head = elem THEN
      l.head := elem.next;
    ELSE
      IF l.head # NIL THEN
        t := l.head;
        WHILE t.next # NIL DO
          IF t.next = elem THEN
            t.next := elem.next;
            RETURN
          ELSE
            t := t.next;
          END;
        END; (* while *)
      END; (* if *)
      RAISE Missing;
    END; (* if *)
  END Remove;


PROCEDURE Length(l: T): CARDINAL RAISES {}=
  VAR
    e := l.head;
    length := 0;
  BEGIN
    WHILE e # NIL DO e := e.next; INC(length) END;
    RETURN length;
  END Length;


BEGIN
END SList.
