UNSAFE INTERFACE BinaryIO;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

FROM FastIO IMPORT Stream, EndOfStream;
IMPORT IO;


(* Routines for putting and getting binary quantities to a 'FastIO.Stream'.
'PutN' and 'GetN' put or get a given number of bytes at the given address. The
other routines are all of the form 'PutBinT', 'GetBinT' where 'T' is one of
'Int', 'Card', 'Real' or 'LongReal'. The 'Card' routines are just veneers on
the corresponding 'Int' routines.
  Note that files containing numbers written in binary form are usually not
portable to other machines. E.g. the size, format and endian order of REALs
are often different on different systems *)

PROCEDURE PutN(s: Stream; a: ADDRESS; bytes: CARDINAL) RAISES {IO.Error};
PROCEDURE PutBinInt(s: Stream; int: INTEGER) RAISES {IO.Error};
PROCEDURE PutBinReal(s: Stream; real: REAL) RAISES {IO.Error};
<*INLINE*> PROCEDURE PutBinCard(s: Stream; card: CARDINAL) RAISES {IO.Error};
PROCEDURE PutBinLongReal(s: Stream; longReal: LONGREAL) RAISES {IO.Error};

PROCEDURE GetN(
    s: Stream;
    a: ADDRESS;
    bytes: CARDINAL;
    raiseEndOfStream := FALSE)
    : CARDINAL
    RAISES {IO.Error, EndOfStream};
PROCEDURE GetBinInt(s: Stream): INTEGER RAISES {IO.Error, EndOfStream};
<*INLINE*> PROCEDURE GetBinCard(
    s:Stream)
    : CARDINAL
    RAISES {IO.Error, EndOfStream};
PROCEDURE GetBinReal(s: Stream): REAL RAISES {IO.Error, EndOfStream};
PROCEDURE GetBinLongReal(s: Stream): LONGREAL RAISES {IO.Error, EndOfStream};

END BinaryIO.
