INTERFACE Stream_ux;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

IMPORT Text;
IMPORT Ctypes;
IMPORT IO, IO_impl;

(* Provides useful types and routines for building streams on top of Unix
descriptors.
  The type 'T' extends the basic stream type with a Unix descriptor and an
error code. The procedures are suitable methods for such a stream *)


TYPE
  T = IO.Stream OBJECT
    d: Ctypes.int;
    rc: Ctypes.int := 0;
  OVERRIDES
    implFlush := Flush;
    implFill := Fill;
    implSeek := Seek;
    implTruncate := Truncate;
    implClose := Close;
    implDescribeError := Error;
  END;


PROCEDURE Flush(s: T; READONLY chars: ARRAY OF CHAR): BOOLEAN RAISES {};
(* tries to flush 'chars' by a 'Unix.write' call, using 'd' as the descriptor.
Returns TRUE if successful, otherwise returns FALSE and sets 'rc' to error code
*)

PROCEDURE Fill(s: T; VAR chars: ARRAY OF CHAR): INTEGER RAISES {};
(* tries to fill 'chars' by a 'Unix.read' call, using 'd' as the descriptor.
Returns chars read if successful, otherwise returns negative number and sets
'rc' to error code *)

PROCEDURE Seek(s: T; pos: CARDINAL): BOOLEAN RAISES {};
(* tries to seek to 'pos' by a 'Unix.lseek' call, using 'd' as the descriptor.
Returns TRUE if successful, otherwise returns FALSE and sets 'rc' to error code
*)

PROCEDURE Truncate(t: T; length: CARDINAL): BOOLEAN RAISES {};
(* tries to truncate the stream to 'length' using 'Unix.ftruncate' on 'd'.
Returns TRUE if successful, otherwise returns FALSE and sets 'rc' to error code
*)

PROCEDURE Close(s: T): BOOLEAN RAISES {};
(* tries to close descriptor 'd'. Returns TRUE if successful, otherwise returns
FALSE and sets 'rc' to error code *)

PROCEDURE Error(s: T): Text.T RAISES {};
(* returns text describing the error code 'rc' *)

END Stream_ux.
