INTERFACE EnvVar;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

IMPORT Text;

PROCEDURE Get(e: Text.T; VAR res: Text.T): BOOLEAN RAISES {};
(* If e is an environment variable, res is set to its value, and TRUE is
 * returned.  If e is not an environment variable, res is unchanged, and
 * FALSE is returned.
 *)

PROCEDURE Expand(e: Text.T): Text.T RAISES {};
(* Expand environment variables in a Text.T.  The environment vars are
 * enclosed $(thusly).  If the surounded text is not an environment var,
 * it expands to the null string.  Unmatched or nested $()'s cause trouble.
 * e.g.  'abc$(TERM)def' -> 'abcsundef'; 'abc$(foo)def' -> 'abcdef';
 * 'abc$(def$(TERM)ghi' -> 'abcghi'; etc.
 *)

END EnvVar.
