MODULE EnvVar;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

IMPORT Text, TextExtras;

(*PUBLIC*)
PROCEDURE Expand(e: Text.T): Text.T RAISES {} =
(* Expand environment variables in a Text.T.  The environment vars are
 * enclosed $(thusly).  If the surounded text is not an environment var,
 * it expands to the null string.  Unmatched or nested $()'s cause trouble.
 * e.g.  'abc$(TERM)def' -> 'abcsundef'; 'abc$(foo)def' -> 'abcdef';
 * 'abc$(def$(TERM)ghi' -> 'abcghi'; etc.
 *)
  VAR
    res: Text.T := "";
    env: Text.T;
    start, end: CARDINAL := 0;
  BEGIN
    WHILE start < Text.Length(e) DO
      env := "";
      IF TextExtras.FindSub(e, "$(", start) THEN
        res := res & TextExtras.Extract(e, end, start);
        start := start + 2;
        end := start;
        IF TextExtras.FindChar(e, ')', end) THEN (* found $(xxx) *)
          EVAL Get(TextExtras.Extract(e, start, end), env);
          res := res & env;
          INC(end);
        ELSE (* unmatched $( *)
          res := res & "$(" & TextExtras.Extract(e, start, Text.Length(e));
        END; (* if $(xxx) found *)
        start := end;
      ELSE (* no $( (done, grab rest) *)
        res := res & TextExtras.Extract(e, end, Text.Length(e));
      END; (* if $( found *)
    END; (* while still to expand *)
    RETURN res;
  END Expand;

BEGIN
END EnvVar.
