UNSAFE MODULE ProgName_ux EXPORTS ProgName;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

IMPORT Text, Thread;
IMPORT M3toC;


VAR
  mutex_g := Thread.NewMutex();
  initialName_g := M3toC.StoT(M3toC.argv[0]);
  programName_g := initialName_g;


PROCEDURE Initial(): Text.T RAISES {}=
  BEGIN
    RETURN initialName_g;
  END Initial;


PROCEDURE Get(): Text.T RAISES {}=
  BEGIN
    LOCK mutex_g DO RETURN programName_g END;
  END Get;


PROCEDURE Set(t: Text.T): Text.T RAISES {}=
  BEGIN
    LOCK mutex_g DO
      VAR
        old := programName_g;
      BEGIN
        programName_g := t;
        RETURN old;
      END;
    END; (* lock *)
  END Set;


BEGIN
END ProgName_ux.
