INTERFACE M3Browser;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

(* Browsing tool, user-interface independent part *)

IMPORT IO;
IMPORT M3Context, M3CUnit;


PROCEDURE ShowInterfaces(c: M3Context.T; s: IO.Stream) RAISES {};
(* show the interfaces on 's' *)

PROCEDURE ShowModules(c: M3Context.T; s: IO.Stream) RAISES {};
(* show the modules on 's' *)

PROCEDURE ShowUses(c: M3Context.T; 
    s: IO.Stream; unitName: TEXT; unitType: M3CUnit.Type) RAISES {};
(* show the 'uses' relation for 'unitName', 'unitType' *)

PROCEDURE ShowDependsOn(c: M3Context.T; s: IO.Stream; 
    moduleName: TEXT) RAISES {};
(* shwo the 'depends-on' relation for 'moduleName' *)

PROCEDURE WhoImports(c: M3Context.T; s: IO.Stream; 
    unitName: TEXT) RAISES {};
(* show who imports interface 'unitName' on 's'. *)

PROCEDURE WhoExports(c: M3Context.T; s: IO.Stream; 
    unitName: TEXT) RAISES {};
(* show who exports interface 'unitName' on 's'. *)

PROCEDURE WhoDependsOn(c: M3Context.T; s: IO.Stream; 
    unitName: TEXT ) RAISES {};
(* show who depends on (module) 'unitName' *)

PROCEDURE ShowAncestors(c: M3Context.T; s: IO.Stream;
    typeName: TEXT;
    concrete: BOOLEAN; 
    showDetails: BOOLEAN
    ) RAISES {};
(* Provided that 'typeName' denotes an opaque or object type, show its 
   ancestors. 
   If 'concrete=TRUE', show concrete type hierarchy.
   If 'showDetails=TRUE', display object fields and methods
*)

END M3Browser.
