(* Copyright (C) 1990, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

MODULE Main;

IMPORT StdIO, Stop;
IMPORT M3Args, M3Context, M3CUnit;
IMPORT M3ToolFrame, M3CFETool, M3CWarnTool, M3UnsetAttTool, M3CharTool;
IMPORT M3AST_all;

PROCEDURE DoRun(c: M3Context.T; compileResult: INTEGER): INTEGER RAISES {}=
  BEGIN
    RETURN compileResult;
  END DoRun;

BEGIN
  M3UnsetAttTool.Init();
  M3CWarnTool.Init();
  M3CharTool.Init();
  EVAL M3Args.SetMaster(M3CFETool.GetTool());
  IF M3ToolFrame.Startup(DoRun) < 0 THEN
    Stop.Stop(Stop.Code.Bad);
  ELSE
    Stop.Stop(Stop.Code.Bad);
  END;
END Main.


