MODULE M3MGTool;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

IMPORT Text, IO, IOErr, Fmt, PathNameStream, M3Extension, Err, PathName;
IMPORT M3Args;
IMPORT M3Context, M3CUnit, M3Conventions;
IMPORT ASTCopy;
IMPORT M3AST_AS;
IMPORT M3ASTDisplay;
IMPORT M3ModGen;

IMPORT M3AST_all;


CONST 
  Version = "07-Apr-92";

VAR 
  tool_g: M3Args.T;

TYPE
  Closure = M3Context.Closure OBJECT
    copy: BOOLEAN;
  END;

PROCEDURE Run(c: M3Context.T; copy: BOOLEAN) RAISES {}=
  TYPE CClosure = Closure OBJECT OVERRIDES callback := RunModGen END;
  BEGIN
    IF M3Args.Find(tool_g) THEN
      M3Context.Apply(c, NEW(CClosure, copy := copy));
    END; (* if *)
  END Run;

PROCEDURE RunModGen(
    cl: Closure;
    ut: M3CUnit.Type; name: Text.T; 
    cu: M3AST_AS.Compilation_Unit) RAISES {}=
  VAR
    unitName: Text.T;
    s: IO.Stream;
    ext: M3Extension.T;
  BEGIN
    IF ut IN M3CUnit.Interfaces AND 
       M3Conventions.PrimarySource IN cu.fe_status THEN
      IF cl.copy THEN
        cu := ASTCopy.Nodes(cu);
      END; (* if *)

      CASE ut OF
      | M3CUnit.Type.Interface, M3CUnit.Type.Interface_gen_ins =>
          ext := M3Extension.T.Mod;
      | M3CUnit.Type.Interface_gen_def =>
          ext := M3Extension.T.ModG;
      END; (* case *)

      M3ModGen.MakeModule(cu);
      unitName := M3Extension.Extend(
          PathName.Name(M3CUnit.TextName(cu.fe_uid)),
          ext);
      s := PathNameStream.Open(unitName, IO.OpenMode.Read, quiet := TRUE);
      IF s # NIL THEN
        IO.Close(s);
	IF NOT M3Args.GetFlag(tool_g, OverWrite_Arg) THEN
          Err.Print(
              Fmt.F("module %s (file %s) already exists", name, unitName),
              Err.Severity.Error);
          RETURN;
        END;
      END; (* if *)
      TRY
        s := PathNameStream.Open(unitName, IO.OpenMode.Write);
        M3ASTDisplay.Nodes(cu, s, 0);
        IO.Close(s);
      EXCEPT
      | IO.Error(s) => 
          IOErr.Close(s, Err.Severity.Error);
      END; (* if *)
    END; (* if *)
  END RunModGen;


BEGIN
  tool_g := M3Args.New("m3modgen", "MODULE Generator Tool", Version);
  M3Args.RegisterFlag(tool_g, OverWrite_Arg, "overwrite any existing module");
END M3MGTool.
