MODULE Main;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

(* Dump m3path to stdout *)

IMPORT
  Err, Fmt, IO, M3Args, M3Path, ProgName, SList, StdIO, Stop, Text, FileOp,
  M3Env;

CONST
  Version = "21-Oct-92";
  Dir_Arg = "Directory";
  NOTransitiveClosure_Arg = "NOTransitiveClosure";
  NOExpandMacros_Arg= "NOExpandMacros";

VAR
 tool_g := M3Args.New("m3pathprint",
   "output (expanded) m3path to standard output", Version, TRUE);

PROCEDURE DoIt(): Stop.Code RAISES {}=
  BEGIN
    IF M3Args.Find(tool_g) THEN RETURN ReallyDoIt()
    ELSE RETURN Stop.Code.Bad;
    END
  END DoIt;

PROCEDURE ReallyDoIt(): Stop.Code RAISES {}=
  VAR
    dir := M3Args.GetString(tool_g, Dir_Arg);
    expand := NOT M3Args.GetFlag(tool_g, NOExpandMacros_Arg);
    transitiveClosure := NOT M3Args.GetFlag(tool_g,NOTransitiveClosure_Arg);
  BEGIN
    M3Path.AddDefault(M3Env.Std_Interface_Rep());
    IF dir = NIL THEN dir := "";
    ELSE
      (* M3Path.Read is silent about non-existent directories.
         Do a check at the top-level *)
      IF NOT FileOp.Accessible(dir) THEN
        Err.Print(Fmt.F("directory %s non-existent or inaccessible", dir),
          Err.Severity.Fatal);
      END;
    END;
    TRY
      VAR
        path := M3Path.Read(dir, doTransitiveClosure := transitiveClosure);
        elem: M3Path.Elem := path.head;
        e: TEXT;
      BEGIN
        WHILE elem # NIL DO
          IF expand THEN e := elem.text ELSE e := elem.unexpanded END;
          IO.PutText(StdIO.Out(), e); IO.PutText(StdIO.Out(), "\n");
          elem := elem.next;
        END; (* for each elem *)
      END; (* var elem *)
      RETURN Stop.Code.Good;
    EXCEPT
    | IO.Error =>
        Err.Print("IO.Error from M3Path.Read", Err.Severity.Fatal);
    | M3Path.BadDirName(dir) =>
        Err.Print(Fmt.F("M3Path.BadDirName(%s)", dir), Err.Severity.Fatal);
    END;
    RETURN Stop.Code.Bad;
  END ReallyDoIt;

BEGIN
  M3Args.RegisterString(tool_g, Dir_Arg,
    "read m3path from given directory (default is current)",
    M3Args.Opt.Positional);
  M3Args.RegisterFlag(tool_g, NOTransitiveClosure_Arg,
    "do not transitively close the m3path");
  M3Args.RegisterFlag(tool_g, NOExpandMacros_Arg,
    "do not expand macro definitions");

  IF M3Args.CheckHelp() THEN Stop.Stop(Stop.Code.Good); END;

  Stop.Stop(DoIt());
END Main.
