INTERFACE M3AST_LX;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

(* This interface defines the types of the lexical entities in the Modula-3
   AST. At this level of the specification, most of the entities are
   declared as opaque types, to be given a definition by a particular
   implementation of the AST. The exception is source position information
   which is defined as an INTEGER, although the encoding of the bits
   is not specified here. The notions of a "comment store" and a
   "pragma store" are likely to change in a future version, in favour
   of more precise association of comments, pragmas and whitespace
   with the AST.
*)

TYPE 
  Symbol_rep <: REFANY;       (* identifiers *)
  Literal_rep <: REFANY;      (* all literals *)
  Number_rep <: Literal_rep;  (* numeric literals *)
  Text_rep <: Literal_rep;    (* text and character literals *)
  SrcPos = INTEGER;           (* source positions *)
  CommentStore <: REFANY;     (* all the comments *)
  PragmaStore <: REFANY;      (* all the pragmas *)

END M3AST_LX.
