MODULE M3PPStream;

(***************************************************************************)
(*                      Copyright (C) Olivetti 1989                        *)
(*                          All Rights reserved                            *)
(*                                                                         *)
(* Use and copy of this software and preparation of derivative works based *)
(* upon this software are permitted to any person, provided this same      *)
(* copyright notice and the following Olivetti warranty disclaimer are     *) 
(* included in any copy of the software or any modification thereof or     *)
(* derivative work therefrom made by any person.                           *)
(*                                                                         *)
(* This software is made available AS IS and Olivetti disclaims all        *)
(* warranties with respect to this software, whether expressed or implied  *)
(* under any law, including all implied warranties of merchantibility and  *)
(* fitness for any purpose. In no event shall Olivetti be liable for any   *)
(* damages whatsoever resulting from loss of use, data or profits or       *)
(* otherwise arising out of or in connection with the use or performance   *)
(* of this software.                                                       *)
(***************************************************************************)

IMPORT IO, IO_impl;
IMPORT M3CSrcPos;

REVEAL
  T = IO.Stream BRANDED OBJECT
    rs: IO.Stream;
    line, pos: CARDINAL;
    nlToSpace, suppress: BOOLEAN;
  OVERRIDES
    implFlush := Flush;
  END;

PROCEDURE Flush(s: T; READONLY chars: ARRAY OF CHAR): BOOLEAN RAISES {}=
  VAR
    ch: CHAR;
  BEGIN
    (* NUMBER(chars) may be greater than 1, even though we have a buffer
       length of 1.
    *)
    TRY
      FOR i := 0 TO NUMBER(chars)-1 DO
        ch := chars[i];
        IF s.nlToSpace AND (ch = '\n') THEN ch := ' '; END;
        IF NOT s.suppress THEN IO.Put(s.rs, ch); END;
        IF ch = '\n' THEN s.pos := 0; INC(s.line); END;
        INC(s.pos);
      END; (* for *)
      RETURN TRUE;
    EXCEPT
    | IO.Error =>
        RETURN FALSE;
    END; (* try *)
  END Flush;

PROCEDURE Open(rs: IO.Stream): T RAISES {}=
  VAR
    s := NEW(T);
    buffer := NEW(REF ARRAY OF CHAR, 1);
  BEGIN
    IO_impl.Init(s, buffer, 0, IO.OpenMode.Write, 
        IO.PropertySet{});
    s.rs := rs;
    RETURN s;
  END Open;

<*INLINE*> PROCEDURE GetSrcPos(s: T): M3CSrcPos.T RAISES {}=
  BEGIN
    RETURN M3CSrcPos.Pack(s.line, s.pos);
  END GetSrcPos;

<*INLINE*> PROCEDURE PutSrcPos(s: T; t: M3CSrcPos.T) RAISES {}=
  BEGIN
    s.line := M3CSrcPos.Unpack(t, s.pos);
  END PutSrcPos;

<*INLINE*> PROCEDURE NLToSpace(s: T; set: BOOLEAN) RAISES {}=
  BEGIN
    s.nlToSpace := set;
  END NLToSpace;

PROCEDURE Suppress(s: T; set: BOOLEAN;
    VAR (*inout*) t: M3CSrcPos.T) RAISES {}=
  BEGIN
    s.suppress := set;
    IF set THEN 
      t := M3CSrcPos.Pack(s.line, s.pos);
    ELSE
      s.line := M3CSrcPos.Unpack(t, s.pos);
    END;
  END Suppress;

BEGIN

END M3PPStream.
