INTERFACE ASTNodeArray;

(* Copyright (C) 1991, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

(* Supports the view that the children of a node 'n' form an
array, indexed from 0 to Number(n) - 1. This is not an
efficient way to iterate children, use AST_Iter directly
if this is important. *)

IMPORT AST;

PROCEDURE Number(n: AST.NODE): CARDINAL RAISES {};
(* number of children in node 'n'. *)

PROCEDURE High(n: AST.NODE): INTEGER RAISES {};
(* Returns Number(n) - 1 *)

PROCEDURE Ith(n: AST.NODE; i: CARDINAL): AST.NODE RAISES {};
(* Given that '0' <= i <= High(n)', returns n[i]. *)

END ASTNodeArray.
