(* Copyright 1992 Digital Equipment Corporation.           *)
(* Distributed only by permission.                         *)
(* Last modified on Wed Aug  5 13:19:51 PDT 1992 by karsenty   *)
(*      modified on Wed Jul 22 01:10:06 1992 by mhb        *)
<* PRAGMA LL *>
MODULE MFViews2;

IMPORT MaxflowViewClass, Filter, GraphVBT, PaintOpCache, R2, ColorName,
       View, ZeusPanel, Graph, List,MFAlgs, Font, Text,
       PaintOp, VBT, MaxflowIE, Rect, RGB;

FROM MFViews IMPORT Color;
FROM MFViews IMPORT BlueColor;

CONST EdgeWidth = 4.0;

TYPE
  T = MaxflowViewClass.T BRANDED OBJECT
	gvbt : GraphVBT.T;
        source, sink: GraphVBT.Vertex;
	nVertices: INTEGER;
	nEdges: INTEGER;

      OVERRIDES
        <* LL=0 *>
        startrun := Startrun;
        oeSetup := Setup;
        oeHighlightPath := HighlightPath;
        oeDecFlow := DecFlow;
        oeIncFlow := IncFlow;
        oeFinalResult := FinalResult;
        oeRemoveHighlight := RemoveHighlight;

        <* LL=VBT.mu *>
        ueAddVBTVertex := AddVBTVertex;
        ueAddVBTEdge := AddVBTEdge;

        mouse := MouseProcess;

      END;

  Vertex = GraphVBT.Vertex BRANDED OBJECT
        myGraphVertex: MFAlgs.MFVertex;
  END;

  Edge = GraphVBT.Edge BRANDED OBJECT
        myGraphEdge: MFAlgs.MFEdge;
  END;

(* find the twins *)
PROCEDURE FindVBTVertex (g: GraphVBT.T; v: Graph.Vertex) : Vertex =
  VAR l : List.T := g.vertices;
      vbt : Vertex;
  BEGIN
    WHILE l # NIL DO
      vbt := List.Pop (l);
      IF (vbt.myGraphVertex = v) THEN RETURN vbt; END;
    END;
    RETURN NIL;
  END FindVBTVertex;

PROCEDURE FindVBTEdge (g: GraphVBT.T; e: Graph.Edge) : Edge =
  VAR l : List.T := g.vertices;
      le : List.T;
      evbt : Edge;
      vvbt : Vertex;
  BEGIN
    (********* tout ca pour recuperer les edges ********)
    WHILE l # NIL DO
      vvbt := List.Pop (l);
      le := vvbt.edges;
      WHILE le # NIL DO
        evbt := List.Pop (le);
        IF (evbt.myGraphEdge = e) THEN RETURN evbt; END;
      END;
    END;

    RETURN NIL;
  END FindVBTEdge;

(* upon a click create a new vertex *)
PROCEDURE MouseProcess(self: T; READONLY cd: VBT.MouseRec) =
  VAR r : R2.T; (* the world coordinates *)
      rect: Rect.T;
  BEGIN
    IF (cd.clickType = VBT.ClickType.FirstDown) THEN
      CASE cd.whatChanged OF
      | VBT.Modifier.MouseL =>
        rect := VBT.Domain (self);
        r := R2.T {FLOAT(cd.cp.pt.h) / FLOAT(rect.east-rect.west), 
                   1.0 - (FLOAT(cd.cp.pt.v) / FLOAT(rect.south-rect.north))};
        MaxflowIE.AddVertex (self, r);
      ELSE
      END;
    END;
  END MouseProcess;

PROCEDURE AddVBTVertex (self: T; v: MFAlgs.MFVertex; pos: R2.T; name: TEXT) =
  <* LL = VBT.mu *>
  VAR vbt: GraphVBT.Vertex;
  BEGIN
    CreateVBTVertex (v, self.gvbt);

    vbt := FindVBTVertex (self.gvbt, v);
    vbt.move (pos, FALSE);
    vbt.setLabel (name);

    v.label := vbt.label;
    v.pos := pos;
    self.gvbt.redisplay();
  END AddVBTVertex;

PROCEDURE AddVBTEdge (self: T; e: MFAlgs.MFEdge) =
  <* LL = VBT.mu *>
  BEGIN
    CreateVBTEdge (e, self.gvbt);
    self.gvbt.redisplay();
  END AddVBTEdge;

PROCEDURE Startrun (view: T) =
  (* sleazy hack: remove the old GraphVBT and just ignore it;
     heck, what else are VM and GC good for? *)
  BEGIN
    EVAL Filter.Replace(view, NEW(GraphVBT.T).init());
    (* call the superclass startrun in ZeusClass.T *)
    MaxflowViewClass.T.startrun(view); 
  END Startrun;

PROCEDURE CreateVBTVertex (obj, arg: REFANY) =
  VAR v : Graph.Vertex;
      vbt : Vertex;
      g := NARROW (arg, GraphVBT.T);
      stdsize : R2.T;
  BEGIN
    stdsize := R2.T{0.08,0.08};   
    v := NARROW (obj, Graph.Vertex);
    vbt := NEW (Vertex, graph := g, 
                pos := R2.T {0.5, 0.5},
	        sizeW := stdsize,
                shape := GraphVBT.VertexShape.Ellipse).init();

    vbt.myGraphVertex := v;
    vbt.setFont (Font.FromName(ARRAY OF TEXT {"*helvetica-bold-r-*-*-*-140-*"}));
    vbt.setFontColor (Color("Black"));
    vbt.setColor(Color ("gray"));

    EVAL  NEW (GraphVBT.VertexHighlight, vertex := vbt,
                color := Color ("gray"),
                borderMM := R2.T{1.0, 1.0}).init();	

  END CreateVBTVertex;

PROCEDURE CreateVBTEdge (obj: REFANY; arg: REFANY) =
  VAR e : Graph.Edge;
      ebt : Edge;
      arrow := ARRAY [0 .. 1] OF BOOLEAN{FALSE, TRUE};
      g := NARROW (arg, GraphVBT.T);
  BEGIN
    e := NARROW (obj, Graph.Edge);
    ebt := NARROW (NEW (Edge, 
                        vertex0 := FindVBTVertex (g, e.from),
                        vertex1 := FindVBTVertex (g, e.to)).init(),
                   Edge);
    (* initialize it *)
    ebt.setColor(Color("gray"));
    ebt.setWidthMM (EdgeWidth);

    ebt.myGraphEdge := e;

    (*** the arrow edge ***)
    ebt := NEW (Edge, 
                vertex0 := ebt.vertex0, vertex1 := ebt.vertex1).init();
    ebt.setWidthMM (0.5);
    ebt.toFront();
    ebt.setArrow (arrow);

  END CreateVBTEdge;

(* beautify retrieve the position and label in Graph.Vertex and 
   applies it to the twin GraphVBT.Vertex *)

PROCEDURE Beautify (gvbt: GraphVBT.T) =
  VAR v: List.T := gvbt.vertices;
      vert: Vertex;
    
  BEGIN
    WHILE v # NIL DO
      vert := List.Pop (v);
      vert.move (vert.myGraphVertex.pos, FALSE);
      vert.setLabel (vert.myGraphVertex.label);
    END;  
  END Beautify;


(* create a GraphVBT.T equivalent to Graph.T *)
PROCEDURE GraphToGraphVBT (g: Graph.T) : GraphVBT.T =
  VAR
      wc := GraphVBT.WorldRectangle{
            w := 0.0, s := 0.0, e := 1.0, n := 1.0};
      gvbt : GraphVBT.T;

  BEGIN
    gvbt := NEW(GraphVBT.T, world := wc).init();

    EVAL g.vertexApply (CreateVBTVertex, gvbt);
    EVAL g.edgeApply (CreateVBTEdge, gvbt);

    Beautify (gvbt);

    RETURN gvbt;
  END GraphToGraphVBT;

(* initialize the graph with the number of edges and vertices *)
PROCEDURE Setup (view: T; g: Graph.T; source, sink: Graph.Vertex) =

  BEGIN
    view.gvbt := GraphToGraphVBT(g);

    view.source := FindVBTVertex (view.gvbt, source);
    view.sink := FindVBTVertex (view.gvbt, sink);

    view.source.setColor(Color ("cornflowerblue"));
    view.source.setLabel ("Source");
    view.source.setSizeW (R2.T{0.1, 0.1});

    view.sink.setColor(Color ("cornflowerblue"));
    view.sink.setLabel ("Sink");
    view.sink.setSizeW (R2.T{0.1, 0.1});

    EVAL Filter.Replace(view, view.gvbt);
    view.gvbt.redisplay();
    view.gvbt.animate(0.0, 1.0);
  END Setup;

PROCEDURE New (): View.T =
  VAR a : T :=  NEW(T).init(NEW(GraphVBT.T).init());
  BEGIN
    a.gvbt := NIL;
    RETURN a;
  END New;

PROCEDURE HighlightPath (view: T; path : List.T; <* UNUSED *> maxC: REAL)=
  VAR vh: GraphVBT.VertexHighlight;
      curvert: Graph.Vertex;
      curedge: Graph.Edge;
      p: List.T;
      vbt_vertex: Vertex;

  BEGIN
    curedge := path.first;
    p := path.tail;
    curvert := curedge.to;

    vbt_vertex := FindVBTVertex (view.gvbt, curedge.from);
    vh := vbt_vertex.vertexHighlights.first;
    vh.setColor(Color("yellow"));

    vbt_vertex := FindVBTVertex (view.gvbt, curedge.to);
    vh := vbt_vertex.vertexHighlights.first;
    vh.setColor(Color("black"));
    
    WHILE p # NIL DO
      curedge := p.first;
      p := p.tail;
      IF (curedge.from = curvert) THEN
        vbt_vertex := FindVBTVertex (view.gvbt, curedge.to);
        vh := vbt_vertex.vertexHighlights.first;
        vh.setColor(Color("black"));
        curvert := curedge.to;
      ELSE
        vbt_vertex := FindVBTVertex (view.gvbt, curedge.from);
        vh := vbt_vertex.vertexHighlights.first;
        vh.setColor(Color("black"));
        curvert := curedge.from;
      END;
    END;
    view.gvbt.redisplay();
  END HighlightPath;

(* reminder: edge.vertex0 / 1 = from / to *)
PROCEDURE IncFlow(view: T; edge: Graph.Edge; flow: REAL;
                  number: CARDINAL; maxC, capacity: REAL) =
  VAR 
    e : GraphVBT.Edge;
    vh: GraphVBT.VertexHighlight;
    evbt : Edge := FindVBTEdge (view.gvbt, edge);

  BEGIN
    (* animate the flowing thru the edge e *)
    e := NEW (GraphVBT.Edge,  
              vertex0 := evbt.vertex0, vertex1 := evbt.vertex0).init();
    e.setWidthMM (EdgeWidth);
    e.move (e.vertex0, evbt.vertex1, NIL, NIL, TRUE);
    e.setColor (BlueColor (flow / capacity));

    (* place the arrow on top the animated edge *)
    e.toBack ();
    evbt.toBack();

    view.gvbt.redisplay(); 
    view.gvbt.animate(0.0, 1.0);

    e.remove();

    (* the new flow/edge *)
    IF (flow = capacity) THEN
      evbt.setColor(Color("magenta"));
    ELSE
      evbt.setColor(BlueColor (flow / capacity));
    END;

    vh:= evbt.vertex0.vertexHighlights.first;
    vh.setColor(Color("gray"));
    vh:= evbt.vertex1.vertexHighlights.first;
    vh.setColor(Color("yellow"));

    view.gvbt.redisplay();
END IncFlow;

PROCEDURE DecFlow(view: T; edge: Graph.Edge; oldflow, newflow: REAL;
                  number: CARDINAL; maxC, capa: REAL) =
  VAR 
    e : GraphVBT.Edge;
    vh: GraphVBT.VertexHighlight;
    evbt : Edge := FindVBTEdge (view.gvbt, edge);
  BEGIN

    e := NEW (GraphVBT.Edge,  
              vertex0 := evbt.vertex0, vertex1 := evbt.vertex1).init();
    e.setWidthMM (EdgeWidth);
    e.move (evbt.vertex0, evbt.vertex0, NIL, NIL, TRUE);
    e.setColor(Color ("limegreen"));
    e.toFront ();

    evbt.setColor(BlueColor (newflow / capa));

    view.gvbt.redisplay(); 
    view.gvbt.animate(0.0, 1.0);

    e.remove();

    vh:= evbt.vertex0.vertexHighlights.first;
    vh.setColor(Color("yellow"));
    vh:= evbt.vertex1.vertexHighlights.first;
    vh.setColor(Color("gray"));

    view.gvbt.redisplay();
  END DecFlow;

PROCEDURE RemoveHighlight(view: T; sinkvertex: Graph.Vertex) =
  VAR vh: GraphVBT.VertexHighlight;
  BEGIN
    vh:= view.sink.vertexHighlights.first;
    vh.setColor(Color("gray"));    
  END RemoveHighlight;


PROCEDURE FinalResult(view: T; fin: BOOLEAN) =
  BEGIN
    view.gvbt.redisplay();
    IF (fin) THEN Fin (view); END;
  END FinalResult;

PROCEDURE Fin (view: T) =
  VAR l : List.T := view.gvbt.vertices;
      vbt : Vertex;
      r : R2.T;
  BEGIN
    WHILE l # NIL DO
      vbt := List.Pop (l);
      IF Text.Equal (vbt.label, "0") THEN r := R2.T{0.1,0.2};
        ELSIF Text.Equal (vbt.label, "1") THEN r := R2.T{0.1,0.5};
        ELSIF  Text.Equal (vbt.label,"2") THEN r := R2.T{0.3,0.5};
        ELSIF Text.Equal (vbt.label,"3") THEN r := R2.T{0.1,0.7};
        ELSIF Text.Equal (vbt.label, "4") THEN r := R2.T{0.3,0.7};
        ELSIF Text.Equal (vbt.label, "5") THEN r := R2.T{0.5,0.7};
        ELSIF Text.Equal (vbt.label, "6") THEN r := R2.T{0.5,0.2};
        ELSIF Text.Equal (vbt.label,"7") THEN r := R2.T{0.7,0.2};
        ELSIF Text.Equal (vbt.label, "8") THEN r := R2.T{0.7,0.7};
        ELSIF Text.Equal (vbt.label, "9") THEN r := R2.T{0.9,0.2};
        ELSIF Text.Equal (vbt.label, "10") THEN r := R2.T{0.9,0.7};
        ELSIF Text.Equal (vbt.label, "Source") THEN r := R2.T{0.5,0.9};
        ELSIF Text.Equal (vbt.label, "Sink") THEN r := R2.T{1.1,0.2};
        END;
      vbt.move (r, TRUE);
    END;
    view.gvbt.redisplay ();
    view.gvbt.animate (0.0, 3.0);
  END Fin;

BEGIN
  ZeusPanel.RegisterView (New, "Animated Maxflow 2", "Maxflow");

END MFViews2.
