(************
Return-Path: Peter.Robinson@cl.cam.ac.uk
Received: by jumbo.pa.dec.com; id AA24726; Thu, 7 May 92 15:11:16 -0700
Received: by mts-gw.pa.dec.com; id AA21242; Thu, 7 May 92 15:10:59 -0700
Received: from kookaburra.cl.cam.ac.uk by swan.cl.cam.ac.uk           with SMTP (PP-6.0) to cl id <27725-0@swan.cl.cam.ac.uk>;          Thu, 7 May 1992 17:23:39 +0100
To: m3-request
Cc: Peter.Robinson@cl.cam.ac.uk
Subject: Problem with exceptions
Date: Thu, 07 May 92 17:23:29 +0100
From: Peter.Robinson@cl.cam.ac.uk
Message-Id: <"swan.cl.ca.621:07.04.92.16.36.10"@cl.cam.ac.uk>


The following program:
*************************)

MODULE Main;

IMPORT Stdio, Wr;

EXCEPTION A; B;

PROCEDURE Test () RAISES {B} =
BEGIN
  TRY
    RAISE A;
  FINALLY
    RAISE B;
  END;
END Test;

BEGIN
  TRY
    Test ();
    Wr.PutText (Stdio.stderr, "OK\n");
  EXCEPT
    A => Wr.PutText (Stdio.stderr, "Exception A\n");
  | B => Wr.PutText (Stdio.stderr, "Exception B\n");
  END;

END Main.

(***********************
gives rise to the following output when run:

****************** EXCEPTION HANDLER STACK *********************
0xf7fff6f4 TRY-FINALLY  proc = 0x2320   frame = 0x0
0xf7fff704 RAISES {Main.B}
0xf7fff770 TRY-EXCEPT {Main.A, Main.B}
****************************************************************


***
*** runtime error:
***    Exception "Main.A" not in RAISES list
***

Quit (core dumped)

using SRC Modula-3 version 2.06 on a SPARC.

I had expected the RAISE B to take precedence over the RAISE A in the
TRY..FINALLY inside Test (SPwM3 2.3.8, p31).  Indeed, this happens if I
expand the procedure in-line.

Any thoughts?

- Peter Robinson.
****************************************)
