(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Wed Nov 11 15:21:05 PST 1992 by msm     *)
<*PRAGMA LL*>

MODULE JoinFont;

IMPORT ScrnFont, JoinScreen;

PROCEDURE New(st: JoinScreen.T): Oracle =
  BEGIN
    RETURN NEW(Oracle, st := st)
  END New;

PROCEDURE Apply (           st : JoinScreen.T;
                 <*UNUSED*> cl : Palette.FontClosure;
                            fnt: Font.T               ): ScrnFont.T =
  BEGIN
    Resolve(st, cs);
    IF 
    RETURN NEW(T, id := 2 * fnt.fnt + 1, st := st);
  END Apply;

PROCEDURE FontApply(st: T;
                    cl: Palette.FontClosure;
                    ft: Font.T): ScrnFont.T = 
  BEGIN
    IF st.sts = NIL THEN RAISE FatalError; END;
    LOOP
      WITH fnt = st.sts[0].fonts[ft.fnt] DO
        IF fnt = NIL THEN EVAL Palette.ResolveFont(st.sts[0], ft);
        ELSIF fnt # PlttFrnds.noFont THEN
          RETURN NEW(ScrnFont.T, id := -ft.fnt,
                     metrics := fnt.metrics);
        END;
      END; (* with *)
    END; (* loop *)
  END FontApply;
  
REVEAL
  Oracle = ScrnFont.Oracle OBJECT
             st: JoinScreen.T;
           (*
           OVERRIDES
             match   := Match;
             list    := List;
             lookup  := Lookup;
             builtIn := BuiltIn
           *)
           END;

TYPE
  T = ScrnFont.T OBJECT
        st: JoinScreen.T;
      (*
      OVERRIDES
        localize := Localize;
        unload   := Unload
      *)
      END;

(*
PROCEDURE FontMatch(orc: FontOracle; 
                    family: TEXT;
                    pointSize: INTEGER;
                    slant: ScrnFont.Slant;
                    maxResults: CARDINAL;
                    weightName: TEXT;
                    version: TEXT;
                    foundry: TEXT;
                    width: TEXT;
                    pixelsize: INTEGER;
                    hres, vres: INTEGER;
                    spacing: ScrnFont.Spacing;
                    averageWidth: INTEGER;
                    charsetRegistry: TEXT;
                    charsetEncoding: TEXT)
                    : REF ARRAY OF TEXT =
  BEGIN
    IF orc.st.sts = NIL THEN RAISE FatalError; END;
    RETURN orc.st.sts[0].font.match(family, pointSize, slant, maxResults,
                             weightName, version, foundry, width,
                             pixelsize, hres, vres, spacing,
                             averageWidth, charsetRegistry, charsetEncoding);
  END FontMatch;
                    
PROCEDURE FontBuiltIn(orc: FontOracle; id: Font.Predefined): ScrnFont.T =
  BEGIN
    IF orc.st.sts = NIL THEN RAISE FatalError; END;
    RETURN orc.st.sts[0].font.builtIn(id);
  END FontBuiltIn;

PROCEDURE FontList(orc: FontOracle;
                   pat: TEXT;
                   maxResults: INTEGER) : REF ARRAY OF TEXT =
  BEGIN
    IF orc.st.sts = NIL THEN RAISE FatalError; END;
    RETURN orc.st.sts[0].font.list(pat, maxResults);
  END FontList;

PROCEDURE FontLookup(orc: FontOracle; name: TEXT): ScrnFont.T =
  BEGIN
    IF orc.st.sts = NIL THEN RAISE FatalError; END;
    RETURN orc.st.sts[0].font.lookup(name);
  END FontLookup;
*)

BEGIN END JoinFont.

