(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Tue Nov 10 13:39:17 PST 1992 by msm     *)
<*PRAGMA LL*>

MODULE JoinPixmap;

IMPORT ScrnPixmap, JoinScreen;

PROCEDURE New(st: JoinScreen.T): Oracle =
  BEGIN
    RETURN NEW(Oracle, st := st)
  END New;

PROCEDURE Apply (           st: JoinScreen.T;
                 <*UNUSED*> cl: Palette.PixmapClosure;
                            pm: Pixmap.T               ): ScrnPixmap.T =
  BEGIN
    Resolve(st, cs);
    RETURN NEW(T, id := 2 * pm.pm + 1, st := st);
  END Apply;

REVEAL
  Oracle = ScrnPixmap.Oracle OBJECT
             st: JoinScreen.T;
           (*
           OVERRIDES
             load    := Register;
             list    := List;
             lookup  := Lookup;
             builtIn := BuiltIn
           *)
           END;

TYPE
  T = ScrnPixmap.T OBJECT
        st: JoinScreen.T;
      (*
      OVERRIDES
        localize := Localize;
        unload   := Unload
      *)
      END;

(*
PROCEDURE PixmapRegister(orc: PixmapOracle; 
                         READONLY pm: ScrnPixmap.Raw; 
                         nm: TEXT := NIL): ScrnPixmap.T 
    RAISES {TrestleComm.Failure} =
  BEGIN
    IF orc.st.sts = NIL THEN RAISE FatalError; END;
    RETURN orc.st.sts[0].pixmap.load(pm, nm);
  END PixmapRegister;

PROCEDURE PixmapList(orc: PixmapOracle;  pat: TEXT;
                     maxResults: CARDINAL := 1) : REF ARRAY OF TEXT 
    RAISES {TrestleComm.Failure} =
  BEGIN
    IF orc.st.sts = NIL THEN RAISE FatalError; END;
    RETURN orc.st.sts[0].pixmap.list(pat, maxResults);
  END PixmapList;

PROCEDURE PixmapLookup(orc: PixmapOracle;
                       name: TEXT) : ScrnPixmap.T
    RAISES {TrestleComm.Failure} =
  BEGIN
    IF orc.st.sts = NIL THEN RAISE FatalError; END;
    RETURN orc.st.sts[0].pixmap.lookup(name);
  END PixmapLookup;
  
PROCEDURE PixmapBuiltIn(orc: PixmapOracle;
                        pm: Pixmap.Predefined): ScrnPixmap.T =
  BEGIN
    IF orc.st.sts = NIL THEN RAISE FatalError; END;
    RETURN orc.st.sts[0].pixmap.builtIn(pm);
  END PixmapBuiltIn;
*)

BEGIN END JoinPixmap.

