(* Copyright (C) 1992, Digital Equipment Corporation *)
(* All rights reserved. *)
(* See the file COPYRIGHT for a full description. *)
(* *)
(* by Steve Glassman, Mark Manasse and Greg Nelson *)
(* Last modified on Fri Nov  6 17:50:55 PST 1992 by msm    *)
(*      modified on Mon Feb 24 13:59:53 PST 1992 by muller *)
<*PRAGMA LL*>

UNSAFE INTERFACE XScrnPxmp;

IMPORT Rect, ScrnPixmap, X, XScreenType, XScrnTpRep, TrestleComm;

REVEAL XScreenType.T <: T;

TYPE
  T_Pub = XScrnTpRep.Public OBJECT END;
  T <: T_Pub;

PROCEDURE NewOracle (st: XScreenType.T): ScrnPixmap.Oracle RAISES {};

PROCEDURE FromXPixmap (         st    : XScreenType.T;
                                xpm   : X.Pixmap;
                       READONLY bounds: Rect.T;
                                depth : INTEGER        ): ScrnPixmap.T;
<* LL.sup = st.trsl *>
(* Construct and return the screen pixmap of type st whose contents are
   those of xpm, which has the given bounds and depth. *)

PROCEDURE PixmapDomain (st: XScreenType.T; pmId: INTEGER): Rect.T;
(* return the domain of the ScrnPixmap.T whose id is pmID. LL.sup =
   st.trsl. *)

PROCEDURE PixmapFromRaw (st: XScreenType.T; pm: ScrnPixmap.Raw): X.Pixmap
  RAISES {TrestleComm.Failure}; <* LL.sup = st.trsl *>

END XScrnPxmp.
