(* Copyright (C) 1991-1992, Digital Equipment Corporation                    *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Mon Jul  6 23:21:41 PDT 1992 by meehan                   *)
(*      modified on Thu Jan 2 15:50:38 PST 1992 by mhb                       *)

MODULE FormsEdit EXPORTS Main;

IMPORT Env, Fmt, FormsEditVBT, FormsVBT, ParseParams, Scan, Thread,
       TrestleComm, VBT, Wr, XParam;

FROM Stdio IMPORT stderr;

<* FATAL Wr.Failure, Thread.Alerted *>

VAR editorDisplay := ":0.0";
       
PROCEDURE main ()
  RAISES {FormsVBT.Error, Scan.BadFormat, TrestleComm.Failure, XParam.Error} =
  VAR
    frame     := NEW (FormsEditVBT.T);
    eroot     := NEW (FormsEditVBT.EditorRoot);
    editorGeo := "-50-50";      (* SE corner *)
  BEGIN
    ParseParams.BeginParsing (stderr);
    IF ParseParams.KeywordPresent ("-d")
         OR ParseParams.KeywordPresent ("-display") THEN
      editorDisplay := ParseParams.GetNext ()
    END;
    IF ParseParams.KeywordPresent ("-g")
         OR ParseParams.KeywordPresent ("-geometry") THEN
      editorGeo := ParseParams.GetNext ()
    END;
    ParseParams.UnparsedTail ();
    LOCK VBT.mu DO
      CASE ParseParams.NumParameters - ParseParams.NextParameter OF
      | 0 => EVAL frame.init () (* use dummy text *)
      | 1 => EVAL frame.initFromFile (ParseParams.GetNext ())
      ELSE
        RAISE Scan.BadFormat
      END
    END;
    EVAL eroot.init (frame, editorDisplay, editorGeo);
    EVAL Thread.Join (Thread.Fork (eroot))
  END main;
  
BEGIN
  EVAL Env.Get ("DISPLAY", editorDisplay);
  TRY
    main ()
  EXCEPT
  | FormsVBT.Error (txt) => Wr.PutText (stderr, txt)
  | TrestleComm.Failure =>
      Wr.PutText (
        stderr, "Could not install vbt on display " & editorDisplay & "\n")
  | XParam.Error (info) =>
      Wr.PutText (stderr, "Syntax error in ");
      IF ISTYPE (info, XParam.DisplayInfo) THEN
        Wr.PutText (stderr, "display")
      ELSE
        Wr.PutText (stderr, "geometry")
      END;
      Wr.PutText (stderr, Fmt.F (" parameter\n%s\n", info.spec));
      FOR i := 1 TO info.index DO Wr.PutChar (stderr, ' ') END;
      Wr.PutText (stderr, "^\n")
  | Scan.BadFormat =>
      Wr.PutText (stderr, "Usage: formsedit [-options] [file]\n");
  END;
END FormsEdit.
