(* Copyright (C) 1992, Digital Equipment Corporation *)
(* All rights reserved. *)
(* See the file COPYRIGHT for a full description. *)
(* *)
(* Last modified on Mon Aug 10  0:19:02 PDT 1992 by meehan *)
(*      modified on Tue Jun 16 13:09:04 PDT 1992 by muller *)
(*      modified on Mon Jun 15 23:43:49 1992 by mhb *)
(*      modified on Fri Mar 27 01:48:06 1992 by steveg *)


(* A "BiFeedbackVBT" is a feedback that is used for composing
   other feedbacks.  It doesn't have any visual behavior itself.
   The crux is that it is assumes that the "BiFeedbackVBT"'s
   child, "ch", is a feedback, and that "ch"'s multi-child (i.e.,
   the multi-grandchild) is also a feedback.  *)

INTERFACE BiFeedbackVBT;

IMPORT Feedback, FeedbackClass, Filter, MultiClass;

TYPE
  T <: Public;
  Public = Filter.T OBJECT
           METHODS
             init (ch           : Feedback.T;
                   multiclass   : MC           := NIL;
                   feedbackclass: FC           := NIL  ): T;
           END;

TYPE
  FC <: FeedbackClass.T;

(* The type "FC" overrides the "normal" and "excited" methods of the
   type "FeedbackClass.T".  The "excited" and "normal" methods invoke
   the corresponding methods on both child and grandchild.  *)

TYPE
  MC <: MultiClass.T;

(* The type "MC" overrides the "replace", "pred", and "succ" methods
   of the type "MultiClass.T". *) 

END BiFeedbackVBT.

