(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Sat Aug  1  0:20:27 PDT 1992 by meehan *)
(*      modified on Tue Jun 16 13:08:59 PDT 1992 by muller *)
(*      modified on Wed Jan 15  7:39:22 PST 1992 by mhb *)

MODULE DragSwitchVBT;

IMPORT BtnVBTClass, ButtonVBT, Feedback, Filter, Multi, MultiClass,
         SwitchVBT, VBT;

FROM VBT IMPORT ClickType;

REVEAL
  T = Public BRANDED OBJECT
      OVERRIDES
        init     := Init;
        during   := During;
        mouse    := Mouse;
        position := Position;
        callback := Callback;
        pre      := SwitchVBT.Pre;
        post     := SwitchVBT.Post;
        cancel   := SwitchVBT.Cancel;
      END;

PROCEDURE Init (v: T; f: Feedback.T; multiclass: MC := NIL): T =
  BEGIN
    EVAL ButtonVBT.T.init (v, f, Action);
    IF multiclass = NIL THEN multiclass := NEW (MC) END;
    MultiClass.Be (v, multiclass);
    MultiClass.BeChild (v, Multi.Child (f));
    RETURN v
  END Init;

PROCEDURE Action(selfAsButtonVBT: ButtonVBT.T; READONLY cd: VBT.MouseRec) =
  BEGIN
    NARROW(selfAsButtonVBT, T).callback(cd)
  END Action;

PROCEDURE Callback (<* UNUSED *>          v : T;
                    <* UNUSED *> READONLY cd: VBT.MouseRec) =
  BEGIN
  END Callback;

PROCEDURE During ( <* UNUSED *> v: T;  
                   <* UNUSED *> READONLY cd: VBT.PositionRec) =
  BEGIN
  END During;

PROCEDURE Mouse(v: T; READONLY cd: VBT.MouseRec) =
  BEGIN
    Filter.T.mouse(v, cd);
    IF cd.clickType = ClickType.FirstDown THEN
      v.ready := TRUE;
      v.pre();
      VBT.SetCage(v, VBT.CageFromPosition(cd.cp, TRUE));
    ELSIF v.ready THEN
      v.ready := FALSE;
      IF cd.clickType = ClickType.LastUp AND NOT cd.cp.offScreen THEN
        v.action(v, cd);
        v.post();
      ELSE
        v.cancel();
      END;
    END;
  END Mouse;

PROCEDURE Position (v: T; READONLY cd: VBT.PositionRec) =
  BEGIN
    Filter.T.position(v, cd);
    IF v.ready THEN
      VBT.SetCage(v, VBT.CageFromPosition(cd.cp, TRUE));
      IF NOT cd.cp.offScreen THEN
        v.during(cd);
      END;
    END;
  END Position;

BEGIN
END DragSwitchVBT.





