(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Fri Jul 31 16:19:21 PDT 1992 by meehan *)
(*      modified on Tue Jun 16 13:08:56 PDT 1992 by muller *)
(*      modified on Mon Jun 15 18:53:38 1992 by mhb *)

MODULE FeedbackClass;

IMPORT VBT;

REVEAL
  T = Public BRANDED OBJECT
      OVERRIDES
        normal  := NoOp;
        excited := NoOp;
      END;

TYPE 
  Prop = REF RECORD fc: T END;

PROCEDURE Be (v: VBT.T; fc: T) =
  BEGIN
    fc.vbt := v;
    VBT.PutProp (v, NEW (Prop, fc := fc))
  END Be;

PROCEDURE Resolve (vbt: VBT.T): T =
  VAR prop: Prop := VBT.GetProp (vbt, TYPECODE (Prop));
  BEGIN
    IF prop = NIL THEN RETURN NIL ELSE RETURN prop.fc END;
  END Resolve;

PROCEDURE NoOp (<* UNUSED *> fc: T) =
  BEGIN
  END NoOp;

BEGIN
END FeedbackClass.
 
