(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Sat Aug  1  0:23:27 PDT 1992 by meehan     *)
(*      modified on Tue Jun 16 13:08:37 PDT 1992 by muller     *)
(*      modified on Thu Jan  9 11:20:23 PST 1992 by mhb        *)

MODULE MenuSwitchVBT;

IMPORT ButtonVBT, Feedback, MenuBtnVBT, Multi, MultiClass, SwitchVBT, VBT;

REVEAL
  T = Public BRANDED OBJECT
      OVERRIDES
        init     := Init;
        callback := Callback;
        pre      := SwitchVBT.Pre;
        post     := SwitchVBT.Post;
        cancel   := SwitchVBT.Cancel;
      END;

PROCEDURE Init (v: T; f: Feedback.T; multiclass: MC := NIL): T =
  BEGIN
    EVAL MenuBtnVBT.T.init (v, f, Action);
    IF multiclass = NIL THEN multiclass := NEW (MC) END;
    MultiClass.Be (v, multiclass);
    MultiClass.BeChild (v, Multi.Child (f));
    RETURN v
  END Init;

PROCEDURE Callback ( <* UNUSED *> v: T;  
                     <* UNUSED *> READONLY cd: VBT.MouseRec) =
  BEGIN
  END Callback;

PROCEDURE Action (selfAsButtonVBT: ButtonVBT.T; READONLY cd: VBT.MouseRec) =
  BEGIN
    NARROW (selfAsButtonVBT, T).callback (cd)
  END Action;

BEGIN
END MenuSwitchVBT.




