(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Tue Jun 16 13:08:19 PDT 1992 by muller     *)
(*      modified on Wed Jul 31  1:48:11 PDT 1991 by mhb        *)

MODULE Shadow;

IMPORT PaintOp, PaintOpCache, ScreenType, VBT;

PROCEDURE New (size : REAL      := 2.0;
               bg   : PaintOp.T := PaintOp.Bg;
               fg   : PaintOp.T := PaintOp.Fg;
               light: PaintOp.T := PaintOp.Fg;
               dark : PaintOp.T := PaintOp.Fg  ): T =
  VAR 
    shadow := NEW(T);
    cs := PaintOpCache.MakeColorScheme(bg, fg);
  BEGIN
    shadow.bg := cs.bg;
    shadow.fg := cs.fg;
    shadow.bgFg := cs.bgFg;
    shadow.transparentFg := cs.transparentFg;
    shadow.swap := cs.swap;
    shadow.bgTransparent := cs.bgTransparent;
    shadow.bgSwap := cs.bgSwap;
    shadow.fgBg := cs.fgBg;
    shadow.fgTransparent := cs.fgTransparent;
    shadow.fgSwap := cs.fgSwap;
    shadow.transparentBg := cs.transparentBg;
    shadow.transparentSwap := cs.transparentSwap;
    shadow.swapBg := cs.swapBg;
    shadow.swapFg := cs.swapFg;
    shadow.swapTransparent := cs.swapTransparent;
    shadow.size := size;
    shadow.light := light;
    shadow.dark := dark;
    RETURN shadow;
  END New;

PROCEDURE SetSize (shadow: T; newSize: REAL): T =
  VAR s := NEW(T);
  BEGIN
    s := shadow;
    s.size := newSize;
    RETURN s;
  END SetSize;


PROCEDURE SetBg (shadow: T; newBg: PaintOp.T): T  =
  BEGIN
    RETURN New(shadow.size, newBg, shadow.fg, shadow.light, shadow.dark);
  END SetBg;

PROCEDURE SetFg (shadow: T; newFg: PaintOp.T): T  =
  BEGIN
    RETURN New(shadow.size, shadow.bg, newFg, shadow.light, shadow.dark);
  END SetFg;

PROCEDURE SetLight (shadow: T; newLight: PaintOp.T): T =
  VAR s := NEW(T);
  BEGIN
    s := shadow;
    s.light := newLight;
    RETURN s;
  END SetLight;

PROCEDURE SetDark (shadow: T; newDark: PaintOp.T): T =
  VAR s := NEW(T);
  BEGIN
    s := shadow;
    s.dark := newDark;
    RETURN s;
  END SetDark;

PROCEDURE Supported (shadow: T; v: VBT.T): BOOLEAN  =
  VAR st: ScreenType.T;
  BEGIN
    st := VBT.ScreenTypeOf (v);
    RETURN (shadow.size > 0.0) AND (st # NIL) AND (st.depth > 1);
  END Supported;

BEGIN
  None := New (0.0);
END Shadow.
