(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Mon Aug 10  0:27:38 PDT 1992 by meehan *)
(*      modified on Tue Jun 16 13:08:13 PDT 1992 by muller *)
(*      modified on Mon Jun 15 21:49:38 1992 by mhb *)
(* modified on Fri Mar 27 02:12:01 1992 by steveg*)
(* modified on Mon Jun 18 16:11:27 PDT 1990 by birrell *)

(* A "SplitterVBT.T" is a parent window that partitions its screen
   into a row or column of children windows, depending on the
   {\em axis} of the split, with adjusting bars between all
   children.  The adjusting bars allow the user to adjust the
   allocation of screen real estate among the splitter's
   children, subject to the size constaints of each child.

   A "SplitterVBT" is subclass of an "HVSplit", but through the
   "Multi" interface, only the ``interesting'' children of the
   "HVSplit" are exposed.  That is, adjusting bars are never
   exposed to the client: they are inserted automatically when a
   new child is added, and removed as necessary.  To access all
   children, including the adjusting bars, use the "Split"
   interface instead.  The "HVSplit" routines "Move", "Adjust",
   "FeasibleRange", "AvailSize", and "AxisOf" can be used. *)

INTERFACE SplitterVBT;

IMPORT Axis, HVSplit, MultiClass, PaintOp, Pixmap;

TYPE Points = REAL;

CONST DefaultSize: Points = 5.0;

TYPE
  T <: Public;
  Public = HVSplit.T OBJECT
           METHODS
             init (hv       : Axis.T;
                   asTargets           := FALSE;
                   size     : Points   := DefaultSize;
                   op                  := PaintOp.BgFg;
                   txt                 := Pixmap.Gray;
                   saveBits            := FALSE;
                   parlim              := -1            ): T;
           END;

(* The call "v.init(...)" initializes "v" as a "SplitterVBT" with
   no children.  See the "HVSplit" interface for an explanation
   of parameters "saveBits" and "parlim".  See the "HVBar"
   interface for an explanation of the "size", "op", and "txt"
   parameters.

   When the "asTargets" flag is "TRUE", each child---including
   the "HVBar"s---of the "SplitterVBT" will be marked as a
   potential target for a "SourceVBT".  Also, there will be an
   "HVBar" both before and after all children. *)

TYPE MC <: MultiClass.T;
(* The type "MC" overrides the "replace" and "insert" methods
   of the type "MultiClass.T". *)

(* Be sure to use the routines in "Multi", not "Split", for
   accessing the children of a "SplitterVBT". *)
   
PROCEDURE New (hv       : Axis.T;
               asTargets           := FALSE;
               size     : Points   := DefaultSize;
               op                  := PaintOp.BgFg;
               txt                 := Pixmap.Gray;
               saveBits            := FALSE;
               parlim              := -1            ): T;
(* "New(...)" is equivalent to "NEW(T).init(...)". *)

END SplitterVBT.



