(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Fri Jul 31 22:49:03 PDT 1992 by meehan      *)
(*      modified on Tue Jun 16 13:08:10 PDT 1992 by muller      *)
(*      modified on Mon Jun 15 22:39:06 1992 by mhb         *)
(*      modified on Thu Jan 31 10:34:05 PST 1991 by brooks      *)
(*      modified on Tue Dec 4 7:01:44 PST 1990 by steveg        *)
(*      modified on Wed May 17 17:06:31 PDT 1989 by gidi        *)
<* PRAGMA LL *>

(* A "TextEditVBT" combines a "TextPort" with a scrollbar.  It
   is a "ShadowedVBT", which is a filter; if the "TextEditVBT"
   is scrollable, then the filter's child is an "HVSplit" whose
   children are a scrollbar, a solid line, and a "TextPort".
   Otherwise, the filter's child is just the "TextPort".  The
   "TextPort" handles all the editing; see
   Section~\ref{TextPortSection}.  If you need neither a
   scrollbar nor a shadow, you should probably use a "TextPort"
   instead of a "TextEditVBT".

   The scrollbar is implemented by "ScrollerVBT", and it uses
   "ScrollerVBT"'s default parameters for the time to delay
   before starting the auto-repeat, and for the period of
   auto-repeating.  (A client can change this---but only
   globally---by using "ScrollerVBT.SetScrollingTimes".)
*)

INTERFACE TextEditVBT;

IMPORT Font, PaintOp, Shadow, ShadowedVBT, TextPort;

TYPE Kind = {SingleLine, MultiLine, Scrollable};
(* "TextEditVBT"s can be single-line editors ("SingleLine"),
   nonscrollable text areas ("MultiLine"), or scrollable text
   areas ("Scrollable").  *)

TYPE
  T <: Public;
  Public =
    ShadowedVBT.T BRANDED OBJECT
      port: TextPort.T := NIL;  (* READONLY *)
    METHODS
      init (kind                         := Kind.Scrollable;
            style                        := Shadow.Style.Flat;
            scrollbar: TextPort.Scroller := NIL;
            shadow   : Shadow.T          := NIL;
            expandOnDemand := FALSE): T; <* LL <= VBT.mu *>
      getFont        (): Font.T;
      setFont        (font: Font.T); <* LL = VBT.mu *>
      getColorScheme (): PaintOp.ColorScheme;
      setColorScheme (c: PaintOp.ColorScheme); <* LL = VBT.mu *>
    END;

(* The call "v.init(...)" initializes "v" as a "TextEditVBT" and
   returns "v".  If "v.port" is "NIL", a "TextPort" will be
   created from "kind", "shadow", and "expandOnDemand" and
   assigned to "v.port".  The default value used for "shadow" is
   "Shadow.None".

   If "kind" is "Kind.Scrollable" and "v.port" is not a
   single-line textport, a scrollbar will be added to the left of
   the "TextPort".  If no scrollbar is supplied, a default one
   will be created.

   After initialization, the client should not change the value
   of "v.port". *)

PROCEDURE GetPort (v: T): TextPort.T;
(* Return "v.port". *)

END TextEditVBT.



