(* Copyright (C) 1992, Digital Equipment Corporation                         *)
(* All rights reserved.                                                      *)
(* See the file COPYRIGHT for a full description.                            *)
(*                                                                           *)
(* Last modified on Tue Jun 30 23:06:42 PDT 1992 by meehan     *)
(*      modified on Tue Jun 16 13:08:09 PDT 1992 by muller     *)
(*      modified on Wed Jul 10 13:21:41 PDT 1991 by mhb        *)
(*      modified on Tue Feb 26 15:11:39 PST 1991 by brooks     *)
(*      modified on Fri Sep 28 13:47:30 PDT 1990 by birrell    *)
<* PRAGMA LL *>

INTERFACE TextPortPrivate;

(* "TextPortPrivate" contains definitions shared by "TextPort",
   "TextEditVBT", "TypescriptVBT", and "EditCmd". *)

IMPORT ClipboardVBT, Font, PaintOp, TextPort, VText;

REVEAL TextPort.T <: Private;

TYPE
  Private = TextPort.Public OBJECT
              mu: MUTEX;
              <* LL = v.mu *>
              vtext         : VText.T;
              font          : Font.T;
              colors        : PaintOp.ColorScheme;
              scrollBar     : TextPort.Scroller;
              singleLine    : BOOLEAN;
              readOnly      : BOOLEAN;
              expandOnDemand: BOOLEAN;
              visible       : BOOLEAN;
              linesShown    : CARDINAL;
              charWidth     : CARDINAL := 0;
              fontHeight    : CARDINAL := 0;
              typeinStart   : CARDINAL;
              cur           : UndoRec;
              clipboard     : ClipboardVBT.T := NIL
            END;

TYPE
  UndoRec = REF RECORD
                  begin, end: VText.Index := 0;
                  text                    := "";
                  next, prev: UndoRec     := NIL
                END;

PROCEDURE TraceUndo (v: TextPort.T);

(* 
   "v.font" is a local copy of
   "v.vtext.vOptions.vFontxxx.vFont.font".

   "v.colors" is a local copy of "v.vtext.vOptions.whiteBlack".

   "v.charwidth" is the width in pixels of a (maximal) character.

   "v.fontHeight" is the height in pixels of a (maximal)
   character.

   "v.typeinStart" is defined only for typescripts. *)

PROCEDURE MarkAndUpdate (v: TextPort.T);
(* Call "VBT.Mark (v)" and then update the scrollbar.  This is
   like "Normalize", except that no scrolling is actually
   performed. *)

PROCEDURE InsertLocked (v: TextPort.T; t: TEXT);
<* LL = v.mu *>
(* Insert "t" at the caret (or in place of a replace-mode
   selection) in "v". *)

END TextPortPrivate.



